 function createPageItem(id, scrollTop, type, height) {
    return {
        id        : id,
        scrollTop : scrollTop,
        type      : type,
        height    : height,
        open      : function () {
            $(".list-navegation").hide();
            if(this.type === "single") {
                loadNews(this.id, false);
            }
            if(this.type === "singleURL") {
                loadNewsURL(this.id, false);
            }
            if(this.type === "home") {
                showHome();
            }
            if(this.type === 'list-cat') {
                loadCat(this.id, 1);
            }
            if(this.type === 'list-tag') {
                loadNewsTag(this.id, false, 1);
            }
            if(this.type === 'list-search') {
                connectGoogleSearch(this.id,1, $("#search-results"));
            }
            if(this.type === 'suscribe') {
                showSuscribe();
            }
            if (this.type === "list") {
                if (this.id==="recent") {
                    showRecentNews();
                    $("#update").show();
                }
                if (this.id==="featured") {
                    showFeaturedNews();
                    $("#update").show();
                }  
                $(".list-navegation").hide();
            }
            $("body").css("min-height", this.height+"px");
            $("html, body").scrollTop(this.scrollTop);
            return this;
        },
        copy : function () {
            return createPageItem(this.id, this.scrollTop, this.type, this.height);
        }
    };
}
navigate = {
    currentPage : createPageItem(0, 0, "home"),
    arrayPages  : new Array(),
    pageList : {
        currentItem : -1,
        list        : undefined    
    },
    addPage : function (id, type) {
        $("#back").show();
        $("body").css("min-height", "0");
            $("#update").hide(); 
        if (
                (type === "single" || type === "singleURL") && 
                ( this.currentPage.type === "list" ||
                  this.currentPage.type === "list-cat" || 
                  this.currentPage.type === "list-tag" || 
                  this.currentPage.type === "list-search" )
            ) {
            clearNavControls("previous-news");
            clearNavControls("next-news");
            $(".list-navegation").show();
            var preSelector = "";
            if (this.currentPage.type === "list-cat") {
                preSelector ="#category-news";
            }
            if (this.currentPage.type === "list-tag") {
                preSelector ="#tag-news";
            }
            if (type === "list" &&  id === "featured" ) {
                preSelector ="#featured-news";
            }
            if (type === "list-search") {
                preSelector ="#search-results";
            }
            if (type === "list" &&  id === "recent" ) {
                preSelector ="#recent-news";
            }
            if (type === 'singleURL') {
                this.pageList.currentItem = $(preSelector + " .newsid-"+id.replace(/([.\.:\/])/g, ''));
            } else {
                this.pageList.currentItem = $(preSelector + " .newsid-"+id);
            }
        }
        if (type === "single" || type === "singleURL") {
            $("#update").hide();            
        }
        if (type === "list" && ( id === "featured" || id === "recent")) {
            $("#update").show();  
            $(".list-navegation").hide();
        }
        if ( type === "home") {
            $("#update").show(); 
            $(".list-navegation").hide();
        }
        if ( type === "suscribe") {
            $(".list-navegation").hide();
        }
        this.currentPage.scrollTop = scrollPos();
        this.currentPage.height    = $("body").height();
        this.arrayPages.push(this.currentPage.copy());
        this.currentPage = createPageItem(id, 0, type, 0);
        $("html, body").scrollTop(0);
    }, 
    back : function () {
        this.currentPage = this.arrayPages.pop().open().copy();
        if(this.arrayPages.length=== 0) {
            $("#back").hide();
        } 
    },
    nextPost : function () {
        if (this.pageList.currentItem.next("a").length===0) {
            return;
        }
        var img = $("#next-news");
        if (this.pageList.currentItem.next("a").next("a").length===0) {
            img.attr('src', img.attr('src').replace(".png", "-disable.png"));
            img.attr("disable", "true");
        }
        if (this.pageList.currentItem.next("a").prev("a") !== 0){
            clearNavControls("previous-news");
        }
        this.pageList.currentItem = this.pageList.currentItem.next("a");
        this.pageList.currentItem.click();
    }, 
    previousPost : function (){
        if (this.pageList.currentItem.prev("a").length===0) {
            return ;
        }
        var img = $("#previous-news");
        if (this.pageList.currentItem.prev("a").prev("a").length===0) {
            img.attr('src', img.attr('src').replace(".png", "-disable.png"));
            img.attr("disable", "true");
        }
        if (this.pageList.currentItem.prev("a").next("a") !== 0){
            clearNavControls("next-news");
        }
        this.pageList.currentItem = this.pageList.currentItem.prev("a");
        this.pageList.currentItem.click();
    }
};
function clearNavControls(control) {
    var img = $("#"+control);
    img.attr('src', img.attr('src').replace("-disable", ""));
    img.removeAttr("disable");
}