var cricket = {
		
	reset : function(){
		location.reload();
	},
	
	/*********************************/
	/*		      scorer  			 */
	/*********************************/
		
	scorerInit : function (){
		document.getElementById('runsScored').value = 0;
		document.getElementById('wicketsFallen').value = 0;
		document.getElementById('oversBowled').value = 0;
		document.getElementById('ballsBowled').value = 0;
		document.getElementById('runRate').innerHTML = '0.0';
		document.getElementById('overWiseScore').innerHTML = '';
		document.getElementById('fallOfWickets').innerHTML = '';
		$('.runButtons').removeAttr('disabled');
		document.getElementById('overwiseRuns').value = 0;
		document.getElementById('ballwiseRuns').value = 0;
		document.getElementById('lastOver').innerHTML = '-';
		document.getElementById('previousOver').innerHTML = '-';
	},
	
	calculateRunRate : function(){
		var runs = parseInt(document.getElementById('runsScored').value,10);
		var overs = parseInt(document.getElementById('oversBowled').value);
		var balls = parseInt(document.getElementById('ballsBowled').value,10);
		
		if(balls != 0){
			overs = overs + (balls/6);
		}
		
		if(runs > 0 && overs > 0){
			runRate = runs / overs;
			
			document.getElementById('runRate').innerHTML = (runRate.toFixed(2));
		}
	},
	
	generateOverWiseScore : function(){
		var runs = parseInt(document.getElementById('runsScored').value,10);
		var overs = parseInt(document.getElementById('oversBowled').value,10);
		var wickets = parseInt(document.getElementById('wicketsFallen').value,10);
		
		var overwiseRuns = parseInt(document.getElementById('overwiseRuns').value,10);
		document.getElementById('overwiseRuns').value = runs;
		
		var score = runs - overwiseRuns;
		var scoreStr = '<b>'+ wickets +'/'+ runs + '</b>, Ov : ' + overs + ', Runs : '+ score +'<br/>';
		
		var d1 = document.getElementById('overWiseScore');
		d1.insertAdjacentHTML('beforeend', scoreStr);
	},
	
	fallOfWickets : function(){
		var wickets = parseInt(document.getElementById('wicketsFallen').value,10);
		var runs = parseInt(document.getElementById('runsScored').value,10);
		var overs = parseInt(document.getElementById('oversBowled').value,10);
		var balls = parseInt(document.getElementById('ballsBowled').value,10);
		
		var scoreStr = '<b>'+ wickets +'/'+ runs +'</b>, Ov : '+ overs +'.'+ balls +'<br/>';
		
		var d1 = document.getElementById('fallOfWickets');
		d1.insertAdjacentHTML('beforeend', scoreStr);
	},
	
	addWickets : function(){
		var wickets = parseInt(document.getElementById('wicketsFallen').value,10);
		
		if(wickets < 10){
			wickets = wickets + 1;
			document.getElementById('wicketsFallen').value = wickets;
			
			cricket.addBalls(1);
			cricket.fallOfWickets();
		}
		
		if(wickets == 10){
			$('.runButtons').attr('disabled', 'disabled');
		}
	},
	
	subtractWickets : function(){
		var wickets = parseInt(document.getElementById('wicketsFallen').value,10);
		
		if(wickets >= 1){
			wickets = wickets - 1;
		}
		
		document.getElementById('wicketsFallen').value = wickets;
	},
	
	addRuns : function(value, flag){
		var val = parseInt(value, 10);
		var runs = parseInt(document.getElementById('runsScored').value,10);
		
		runs = runs + val;
		
		document.getElementById('runsScored').value = runs;

		var isExtra = parseInt(flag, 10);
		
		if(isExtra == 0){
			cricket.addBalls(0);
		}
		
		cricket.calculateRunRate();
	},
	
	subtractRuns : function(){
		var runs = parseInt(document.getElementById('runsScored').value,10);
		
		if(runs > 1){
			runs = runs - 1;
		} else if(runs == 1){
			runs = runs - 1;
		}
		
		document.getElementById('runsScored').value = runs;
	},
	
	addBalls : function(wicket){
		var ballsObj = document.getElementById('ballsBowled');
		var balls = parseInt(ballsObj.value,10);

		balls = balls + 1;
		
		cricket.lastOver(balls, wicket);
		
		if(balls == 6){
			var oversObj = document.getElementById('oversBowled');
			var overs = parseInt(oversObj.value,10);
			
			overs = overs + 1;
			
			oversObj.value = overs;
			ballsObj.value = 0;
			
			cricket.generateOverWiseScore();
		} else {
			ballsObj.value = balls;
		}
		
		cricket.calculateRunRate();
	},
	
	lastOver : function(balls, wicket){
		if(balls == 1){
			$("#previousOver").html($("#lastOver").html());
			document.getElementById('lastOver').innerHTML = '';
		}

		var runs = parseInt(document.getElementById('runsScored').value,10);
		var ballwiseRuns = parseInt(document.getElementById('ballwiseRuns').value,10);
		document.getElementById('ballwiseRuns').value = runs;
		var score = runs - ballwiseRuns;
		var scoreStr = '';
		
		if(wicket == 1){
			score = 'W';
		}
		
		switch(balls){
			case 1 : 
				scoreStr = '<span>'+ score + '</span>';
				break;
			case 2 : 
				scoreStr = '-<span>'+ score + '</span>';
				break;
			case 3 : 
				scoreStr = '-<span>'+ score + '</span>';
				break;
			case 4 : 
				scoreStr = '-<span>'+ score + '</span>';
				break;
			case 5 : 
				scoreStr = '-<span>'+ score + '</span>';
				break;
			case 6 : 
				scoreStr = '-<span>'+ score + '</span>';
				break;
		}
		
		var d1 = document.getElementById('lastOver');
		d1.insertAdjacentHTML('beforeend', scoreStr);
	},
	
	// pass the element id
	toggleVisibility : function(elementId) {
		var e = document.getElementById(elementId);
		
		if(e.style.display == 'block'){
			e.style.display = 'none';
		} else {
			e.style.display = 'block';
		}
	},
	
	/*********************************/
	/*		score predictor			 */
	/*********************************/
	predictorInit : function(){
		document.getElementById('score').value = "";
		document.getElementById('oversBowled').value = "";
		document.getElementById('oversBowled').value = "";
	},
	
	rpoCalculation : function(runs, rr, remOvers){
		var calcVal = runs + (rr * remOvers);
		return calcVal;
	},
	
	predictor : function(){
		var runs = parseInt($('#score').val(), 10);
		var overs = parseInt($('#oversBowled').val(), 10);
		var totalOvers = parseInt($('#totalOvers').val(), 10);
		
		var remainingOvers = totalOvers - overs;
		
		var currentRunRate = runs / overs;
		$('#currentRunRate').empty();
		$('#currentRunRate').html(currentRunRate.toFixed(2));
		
		$('#rpoCRR').empty();
		$('#rpoCRR').html((currentRunRate * totalOvers).toFixed(0));
		
		var rpo4 = cricket.rpoCalculation(runs, 4, remainingOvers);
		$('#rpoF').empty();
		$('#rpoF').html(rpo4 +"");
		
		var rpo6 = cricket.rpoCalculation(runs, 6, remainingOvers);
		$('#rpoS').empty();
		$('#rpoS').html(rpo6 +"");
		
		var rpo8 = cricket.rpoCalculation(runs, 8, remainingOvers);
		$('#rpoE').empty();
		$('#rpoE').html(rpo8 +"");
		
		var rpo10 = cricket.rpoCalculation(runs, 10, remainingOvers);
		$('#rpoT').empty();
		$('#rpoT').html(rpo10 +"");
	},
	
	/*********************************/
	/*		umpire assistant		 */
	/*********************************/
	assistantInit : function(){
		$('.runButtons').css('background','black');
	},
	
	disableMe : function(obj){
		obj.style.background = 'grey';
		
		/*if(obj.value == '6'){
			cricket.addOvers();
			$('div').each(function(index){
				$('.runButtons').css('background','black');
			});
			
		}*/
	},
	
	/*addOvers : function(){
		var overs = parseInt(document.getElementById('oversBowled').value,10);
		
		overs = overs + 1;
		
		document.getElementById('oversBowled').value = overs;
	}*/
};