﻿sessionStorage.setItem("valor_panel", "0");
sessionStorage.setItem("id_galeria_actual", "");
sessionStorage.setItem("estado_conexion", "si");

//Otras variables
var datos_en_memoria;
var datos_recarga;



var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicity call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
        window.deviceReady = true;
        //enventos para controlar cuando hay conexión o cuando no la hay
        document.addEventListener("offline", onOffline, false);
        document.addEventListener("online", onOnline, false);
    },
    // Update DOM on a Received Event
    receivedEvent: function (id) {
        /*
        var parentElement = document.getElementById(id);
        var listeningElement = parentElement.querySelector('.listening');
        var receivedElement = parentElement.querySelector('.received');

        listeningElement.setAttribute('style', 'display:none;');
        receivedElement.setAttribute('style', 'display:block;');
        */
        console.log('Received Event: ' + id);
    }
};

sessionStorage.setItem("pagina_navegar", "index");


function actualizar_idgaleria(id) {
    sessionStorage.setItem("id_galeria_actual", id);
}

//Acciones al presionar el boton volver
function botonVolver() {
    if ($.mobile.activePage.is('#secportada')) {
        navigator.app.exitApp();
    } else {
        if (sessionStorage.getItem("valor_panel") == "1") {
            $(".panel-menu-izquierda").panel("close");
            sessionStorage.setItem("valor_panel", "0");
        }
        else {
            if ($.mobile.activePage.is('#sechistoria')) {
                llamar_archivo("");
            }
            if ($.mobile.activePage.is('#secredes')) {
                llamar_archivo("");
            }
            if ($.mobile.activePage.is('#secnoticias')) {
                llamar_archivo("");
            }
            if ($.mobile.activePage.is('#secdetallenoticia')) {
                llamar_archivo("noticias.html");
            }
            if ($.mobile.activePage.is('#secdetallegalerianoticia')) {
                llamar_archivo("detalle-noticia.html");
            }
            if ($.mobile.activePage.is('#secgalerias')) {
                llamar_archivo("");
            }
            if ($.mobile.activePage.is('#secdetallegaleria')) {
                llamar_archivo("galerias.html");
            }
            if ($.mobile.activePage.is('#secacerca')) {
                llamar_archivo("");
            }
        }
    }

}

function pagina_actual(capa) {
    var aux = "#" + $.mobile.activePage.attr('id') + " " + capa;
    return aux;
}
function llamar_archivo(archivo) {
    if (archivo != "") {
        $.mobile.changePage(archivo, {transition: "slideup",reverse: true,changeHash: true,reloadPage: false});
    }else{
        if (sessionStorage.getItem("dispositivo") == "tablet") {
            $.mobile.changePage("index-tablet.html", {transition: "slideip",reverse: true,changeHash: true,reloadPage: false});
        }else {
            $.mobile.changePage("index.html", {transition: "slideup",reverse: true,changeHash: true,reloadPage: false});
        }
    }
}
function calcular_fecha(f_actual, f_guardada) {
    f_act = Date.parse(f_actual);
    f_ant = Date.parse(f_guardada);
    diferencia = f_act - f_ant;
    if (diferencia > 900000) {
        return true;
    } else {
        return false;
    }
}


function onOffline() {
    sessionStorage.setItem("estado_conexion", "no");
}
function onOnline() {
    sessionStorage.setItem("estado_conexion", "si");
}
function establecerPagina(id) {
    sessionStorage.setItem("pagina_actual", id);
}
function cargar_panel(seccion) {
    $("#panel-menu-izquierda-"+seccion).empty();
    $("#panel-menu-izquierda-" + seccion).append('<div id="titulo-panel">CRISTO DE LA LUZ</div> <ul class="menu-panel"> <li id="historia-panel"><img class="imagen-panel" src="imagenes/vectoriales/ico-historia.svg" /> Historia</li> <li id="noticias-panel"><img class="imagen-panel" src="imagenes/vectoriales/ico-noticias.svg" /> Noticias</li> <li id="galerias-panel"><img class="imagen-panel" src="imagenes/vectoriales/ico-galerias.svg" /> Galería de fotos</li> <li id="redes-panel"><img class="imagen-panel" src="imagenes/vectoriales/ico-redes.svg" /> Redes sociales</li> <li id="acerca-panel"><img class="imagen-panel" src="imagenes/vectoriales/ico-acerca.svg" /> Acerca de ...</li> </ul>');
}
function botones_portada() {
    var clase_botones = "";
    if (sessionStorage.getItem("dispositivo") == "tablet") {
        clase_botones = "boton_menu_inicio_tablet";
    }
    $("#capa_botonera").empty().append('<div class="boton_menu_inicio ' + clase_botones + '"><img id="historia" src="./imagenes/botones/trans.png" class="boton_historia_off" /></div><div class="boton_menu_inicio ' + clase_botones + '"><img id="noticias" src="./imagenes/botones/trans.png" class="boton_noticias_off" /></div><div class="boton_menu_inicio ' + clase_botones + '"><img id="galerias" src="./imagenes/botones/trans.png" class="boton_galerias_off" /></div><div class="boton_menu_inicio ' + clase_botones + '"><img id="redes" src="./imagenes/botones/trans.png" class="boton_redes_off" /></div>');
}
function botones_noticias() {
    $(document).on('tap taphold', ".noticia_listado", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).css("background", "#dbdbdb");
        var numero_noticia = $(this).attr("id");
        var numero_noticia = numero_noticia.substring(4, numero_noticia.length);
        sessionStorage.setItem("id_noticia", numero_noticia);
        window.setTimeout('cambio_noticias()', 200);
    });
}
function botones_cabecera() {
    $(document).on('vmousedown', ".icono_atras_cabecera img", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).removeClass("boton_atras_off").addClass("boton_atras_on");
    });
    $(document).on('vmouseup', ".icono_atras_cabecera img", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).removeClass("boton_atras_on").addClass("boton_atras_off");
        botonVolver();
    });
    $(document).on('vmousedown', ".icono_inicio_cabecera img", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).removeClass("boton_inicio_off").addClass("boton_inicio_on");
    });
    $(document).on('vmouseup', ".icono_inicio_cabecera img", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).removeClass("boton_inicio_on").addClass("boton_inicio_off");
        if (sessionStorage.getItem("valor_panel") == "0") {
            $(".panel-menu-izquierda").panel("open");
            sessionStorage.setItem("valor_panel", "1");
        }
    });
}
function botones_redes() {
    $(document).on('vmousedown', "#secredes #capa_cargadora_informacion > div", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        var nombre = $(this).attr("id").replace("ficha-","");
        $(this).removeClass("clase-"+nombre).addClass("clase-"+nombre+"-on");
    });
    $(document).on('vmouseup', "#secredes #capa_cargadora_informacion > div", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        var nombre = $(this).attr("id").replace("ficha-", "");
        $(this).removeClass("clase-" + nombre + "-on").addClass("clase-" + nombre);
    });
}

function botones_panel() {
    $(document).on('vmousedown', ".menu-panel li", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        $(this).addClass("seccion-panel-on");
        var seccion_menu = $(this).attr('id');
        seccion_menu = seccion_menu.replace('-panel', '');
        $("#" + seccion_menu + "-panel img").attr("src", "imagenes/vectoriales/ico-" + seccion_menu + "-on.svg");
    });
    $(document).on('vmouseup', ".menu-panel li", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        cargar_panel(sessionStorage.getItem("pagina_navegar"));
        var valor = $(this).attr("id").replace("-panel","");
        sessionStorage.setItem("pagina_navegar", valor);
        sessionStorage.setItem("valor_panel", "0");
        window.setTimeout('cambio_pagina()', 200);
    });
    $(document).on('vmouseup', ".ui-panel-dismiss", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        if (sessionStorage.getItem("valor_panel") == "1") {
            $(".panel-menu-izquierda").panel("close");
            sessionStorage.setItem("valor_panel", "0");
        }
    });
}

function cambio_noticias() {
    $.mobile.changePage("detalle-noticia.html", {transition: "none",reverse: false,changeHash: true,reloadPage: false,});
}
function cambio_pagina() {
    final = sessionStorage.getItem("pagina_navegar");
    final = final + ".html";
    $.mobile.changePage(final, {transition: "slideup",reverse: false,changeHash: true,reloadPage: false});
}
function botones_inicio() {
    $(document).on('vmouseup', '.boton_menu_inicio img', function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        valor = $(this).attr("id");
        sessionStorage.setItem("pagina_navegar", valor);
        valor = "boton_" + valor;
        valor_on = valor + "_on";
        valor_off = valor + "_off";
        $(this).removeClass(valor_off).addClass(valor_on);
        window.setTimeout('cambio_pagina()', 200);
    });
}

function alerta_texto(texto) {
    navigator.notification.alert(texto,null,'Cristo de la Luz','Aceptar');
}

function cargar_noticias() {
    datos_en_memoria = localStorage.getItem('info_noticia');
    datos_recarga = localStorage.getItem('ultima_actualizacion_noticias');

    if ((datos_recarga == null) || (datos_recarga == "")) {
        datos_recarga = 0;
    }
    //comprobar_conexion();
    var ahora = new Date();
    sessionStorage.setItem('hora_actual', ahora);
    var longitud_entradilla = 200;
    if (sessionStorage.getItem("dispositivo") != "movil") {
        longitud_entradilla = 500;
    }
    //SI HAY CONEXION
    if (sessionStorage.getItem('estado_conexion') == "si") {
        if ((datos_en_memoria == null) || (calcular_fecha(sessionStorage.getItem('hora_actual'), datos_recarga) == true)) {
            $.ajax({
                url: 'http://www.cristodelaluz.es/app/noticias.ashx',
                dataType: 'jsonp',
                data: {},
                global: false,
                cache: false,
                crossDomain: true,
                success: function (data) {
                    localStorage.setItem('info_noticia', JSON.stringify(data));
                    datos_en_memoria = JSON.parse(localStorage.getItem('info_noticia'));
                    $('#capa_cargadora_informacion_noticias').animate({ "opacity": 0 }, 0);
                    $.each(datos_en_memoria.noticias, function (i, noticia) {
                        var str = noticia.entradilla;
                        str = str.substring(0, longitud_entradilla) + "...";
                        $('#capa_cargadora_informacion_noticias').append("<div class='noticia_listado' id='not_" +
                        noticia.idnoticia + "'><div class='linea_flechas'><div class='contenido_noticia_listado'><span class='fecha_listado'>" +
                        noticia.fecha + "</span><br/><span class='titular_listado'>" +
                        noticia.titulo + "</span><div class='texto_noticia_listado'>" +
                        str + "</div></div></div></div>");
                    });
                    $('#capa_anima_carga').css("display", "none");
                    $('#capa_cargadora_informacion_noticias').animate({ "opacity": 1 }, 200);
                    var nueva_carga = new Date();
                    localStorage.setItem('ultima_actualizacion_noticias', nueva_carga);
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    alerta_texto('Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            });
        } else {
            datos_en_memoria = JSON.parse(localStorage.getItem('info_noticia'));
            $('#capa_cargadora_informacion_noticias').animate({ "opacity": 0 }, 0);
            $.each(datos_en_memoria.noticias, function (i, noticia) {
                var str = noticia.entradilla;
                str = str.substring(0, longitud_entradilla) + "...";
                $('#capa_cargadora_informacion_noticias').append("<div class='noticia_listado' id='not_" +
                        noticia.idnoticia + "'><div class='linea_flechas'><div class='contenido_noticia_listado'><span class='fecha_listado'>" +
                        noticia.fecha + "</span><br/><span class='titular_listado'>" +
                        noticia.titulo + "</span><div class='texto_noticia_listado'>" +
                        str + "</div></div></div></div>");
            });
            $('#capa_anima_carga').css("display", "none");
            $('#capa_cargadora_informacion_noticias').animate({ "opacity": 1 }, 200);
        }
    }
    else {
        if (datos_en_memoria == null) {
            $('#capa_anima_carga').css("display", "none");
            $('#contenedor_alerta').css("display", "inherit");
            $('#capa_cargadora_informacion_noticias').css("display", "none");
            $('#contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:10%;'><img src='./imagenes/alerta.png' /><br /><strong>No hay datos disponibles.</strong><br />Necesita conectarse a Internet.</div>");
            $('#contenedor_alerta').animate({ "opacity": 1 }, 200);
        }
        else {
            datos_en_memoria = JSON.parse(localStorage.getItem('info_noticia'));
            $('#capa_cargadora_informacion_noticias').animate({ "opacity": 0 }, 0);
            $.each(datos_en_memoria.noticias, function (i, noticia) {
                var str = noticia.entradilla;
                str = str.substring(0, longitud_entradilla) + "...";
                $('#capa_cargadora_informacion_noticias').append("<div class='noticia_listado' id='not_" +
                        noticia.idnoticia + "'><div class='linea_flechas'><div class='contenido_noticia_listado'><span class='fecha_listado'>" +
                        noticia.fecha + "</span><br/><span class='titular_listado'>" +
                        noticia.titulo + "</span><div class='texto_noticia_listado'>" +
                        str + "</div></div></div></div>");
            });
            $('#capa_anima_carga').css("display", "none");
            $('#capa_cargadora_informacion_noticias').animate({ "opacity": 1 }, 200);
        }
    }
}

function enlaces_noticia(){
    $(document).on('tap taphold', ".entradilla_detalle_noticia a", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        aux = $(this).attr("rel");
        aux = aux.replace("\"", "");
        aux = aux.replace("\"", "");
        window.open(aux, '_system', 'location=yes');
    });
}

function enlace_indalweb() {
    $(document).on('tap taphold', ".logo-acercade", function (event) {
        event.preventDefault();event.stopImmediatePropagation();
        window.open("http:\www.indalweb.net", '_system', 'location=yes');
    });
}

function detalle_noticia() {
    var contenedorinfo = pagina_actual("#contenedor_detalle_noticia");
    var contenedoradjuntos = pagina_actual("#contenedor_adjuntos_noticia");
    datos_en_memoria = localStorage.getItem('detalle_noticia');
    //comprobar_conexion();
    var url = 'http://www.cristodelaluz.es/app/noticia.ashx?idnoticia=' + sessionStorage.getItem('id_noticia');
    //SI HAY CONEXION
    if (sessionStorage.getItem('estado_conexion') == "si") {
        $.ajax({
            url: url,
            dataType: 'jsonp',
            data: {},
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                localStorage.setItem('detalle_noticia', JSON.stringify(data));
                datos_en_memoria = JSON.parse(localStorage.getItem('detalle_noticia'));
                $('#capa_cargadora_informacion').animate({ "opacity": 0 }, 0);
                $.each(datos_en_memoria.noticia, function (i, noticia) {
                    $(contenedorinfo).append('<div style="width:100%; float:left;" id="noti_' +
                    noticia.idnoticia + '"><div style="width:94%; float:left; padding:15px 3%;"><span class="fecha_detalle_noticia">' +
                    noticia.fecha + '</span><br/><span class="titular_detalle_noticia">' +
                    noticia.titulo + '</span><br/><br/><span class="entradilla_detalle_noticia"> <div class="foto_detalle_noticia"><img src="' + noticia.imagen + '"></div>' +
                    noticia.entradilla + '</span><br/><br/><span class="detalle_detalle_noticia">' +
                    noticia.detalle + ' </span></div></div>');
                    if (noticia.imagen == "") { $(".foto_detalle_noticia").css("display", "none"); }
                });
                if (datos_en_memoria.galeria.length != 0) {
                    $(contenedoradjuntos).append('<div class="boton_ver_galeria"><span style="color:#fff;">DETALLE GALERIA</a></div>');
                    $(document).on('tap', ".boton_ver_galeria", function (event) {
                        event.preventDefault();event.stopImmediatePropagation();
                        $(this).css("background", "url(./imagenes/enlacegaleria.png) top left no-repeat #666");
                        sessionStorage.setItem("pagina_navegar", "detalle-galeria-noticia");
                        window.setTimeout("cambio_pagina()", 300);
                    });
                }
                if (datos_en_memoria.documentos.length != 0) {
                    $.each(datos_en_memoria.documentos, function (i, documento) {
                        $(contenedoradjuntos).append("<div class='boton_descargar_documento' rel='" + documento.enlace + "'><span class='nombre_documento_noticia'>" + documento.descripcion + "</span><br/></div>");
                    });
                    $(document).on('tap', ".boton_descargar_documento", function (event) {
                        event.preventDefault();event.stopImmediatePropagation();
                        $(this).css("background", "url(./imagenes/enlacedocumento.png) top left no-repeat #666");
                        $(this).css("color", "#fff");
                        var aux = $(this).attr("rel");
                        sessionStorage.setItem("valor_documento", aux);
                        window.setTimeout("abrir_documento()", 300);
                    });
                }
                $('.capa_anima_carga').css("display", "none");
                $('#capa_cargadora_informacion').animate({ "opacity": 1 }, 200);
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                alert('Fallo en la lectura de datos. Inténtelo más tarde.');
            }
        });

    }
    else {
        $('.capa_anima_carga').css("display", "none");
        $('.contenedor_alerta').css("display", "inherit");
        $(contenedorinfo).css("display", "none");
        $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No dispone de conexión.<br />Necesita Internet para cargar toda la información de la noticia.</div>");
        $('.contenedor_alerta').animate({ "opacity": 1 }, 200);
    }
}
function abrir_documento() {
    $(".boton_descargar_documento").css("background", "url(./imagenes/enlacedocumento.png) top left no-repeat #f2f2f2");
    $(".boton_descargar_documento").css("color", "#565656");
    var url = sessionStorage.getItem("valor_documento");
    window.open(url, '_system', 'location=yes');
}

function detalle_galeria_noticia() {
    var contenedorinfo = pagina_actual("#contenedor_galeria_noticia");
    //comprobar_conexion();
    //SI HAY CONEXION
    if (sessionStorage.getItem('estado_conexion') == "si") {
        datos_en_memoria = localStorage.getItem('detalle_noticia');
        datos_en_memoria = JSON.parse(localStorage.getItem('detalle_noticia'));

        //CARGA DE LA GALERIA DE LA NOTICIA
        if (datos_en_memoria.galeria.length != 0) {
            $.each(datos_en_memoria.galeria, function (i, galeria) {
                $(contenedorinfo).append("<div class='contenedor_info_galerias'><div class='imagen_fondo_galerias' style='background:url(" +
                    galeria.imagen + ") center center no-repeat; background-size:cover;'><a href='" + galeria.zoomimagen + "' rel='external'><img src='./imagenes/botones/trans.png'/></a></div></div>");
            });
        }
        $('.capa_anima_carga').css("display", "none");
        var
            currentPage = $("#secdetallegalerianoticia"),
            options = {},
            photoSwipeInstance = $(".imagen_fondo_galerias a", "#secdetallegalerianoticia").photoSwipe();
        sessionStorage.setItem("galeria_actual", photoSwipeInstance.id);
        return true;
    }
    else {
        $('.capa_anima_carga').css("display", "none");
        $('.contenedor_alerta').css("display", "inherit");
        $(contenedorinfo).css("display", "none");
        $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No dispone de conexión.<br />Necesita conectarse a Internet.</div>");
        $('.contenedor_alerta').animate({ "opacity": 1 }, 200);
    }
    return true;
}


//funcion para cargar las galerias
function cargar_galerias() {
    var contenedorinfo = pagina_actual("#contenedor_galerias");
    var url = "http://www.cristodelaluz.es/app/galerias.ashx";
    //comprobar_conexion();
    if (sessionStorage.getItem('estado_conexion') == "si") {
        $.ajax({
            url: url,
            dataType: 'jsonp',
            data: {},
            global: false,
            cache: false,
            crossDomain: true,
            success: function (data) {
                //salvamos los datos en local
                localStorage.setItem('detalle_galerias', JSON.stringify(data));
                datos_en_memoria = JSON.parse(localStorage.getItem('detalle_galerias'));
                var background_galeria = "";
                var nombre_galeria = "";

                if (sessionStorage.getItem("dispositivo") != "movil") {
                    background_galeria = "background-size:initial;";
                    nombre_galeria = "width:43%;";
                }
                $.each(datos_en_memoria.galerias, function (i, galerias) {
                    if ((i % 2 == 0) && (i != 0)) {
                        $(contenedorinfo).append('<div style="width:100%; float:left;">');
                    }

                    $(contenedorinfo).append('<div style="background: url(' +
                        galerias.imagen + ') top left no-repeat #c48309; ' + background_galeria + '" class="lista_entrada_galeria"><div class="boton_imagen_galeria" id="img_' +
                        galerias.idgaleria + '"><div class="nombre_lista_galeria" style="' + nombre_galeria + '">' +
                        galerias.titulo + '</div></div></div>');
                    if ((i % 2 == 0) && (i != 0)) {
                        $(contenedorinfo).append('</div>');
                    }
                });
                $('.capa_anima_carga').css("display", "none");
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                alert('Fallo en la lectura de datos. Inténtelo más tarde.');
            }
        });
    }
    //CUANDO NO HAY CONEXION
    else {
        //borramos contenido y cargamos
        $('.capa_anima_carga').css("display", "none");
        $('.contenedor_alerta').css("display", "inherit");
        $(contenedorinfo).css("display", "none");
        $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No dispone de conexión.<br />Necesita conectarse a Internet.</div>");
        $('.contenedor_alerta').animate({ "opacity": 1 }, 200);
    }
}

function botones_detalle_galeria() {
    $(document).on('tap taphold', ".boton_imagen_galeria", function (event) {
        event.preventDefault();
        event.stopImmediatePropagation();

        var id_galeria = $(this).attr("id");

        var id_galeria = id_galeria.substring(4, id_galeria.length);
        sessionStorage.setItem("id_galeria_actual", id_galeria);

        id_galeria = "#img_" + id_galeria;

        $(id_galeria).removeClass("boton_imagen_galeria");
        $(id_galeria).addClass("boton_imagen_galeria_on");


        if (sessionStorage.getItem('estado_conexion') == "si") {
            //Guardo en local los datos de la galeria en cuestion
            var url = "http://www.cristodelaluz.es/app/galeria.ashx?idgaleria=" + sessionStorage.getItem("id_galeria_actual");
            $.ajax({
                url: url,
                dataType: 'jsonp',
                data: {},
                global: false,
                cache: false,
                crossDomain: true,
                success: function (data) {
                    //salvamos los datos en local
                    localStorage.setItem('detalle_galerias_galeria', JSON.stringify(data));
                    datos_en_memoria = JSON.parse(localStorage.getItem('detalle_galerias_galeria'));
                    total = datos_en_memoria.galeria.length;
                    //CARGA DE LA GALERIA DE LA NOTICIA
                    if (total != 0) {
                        console.log(id_galeria);
                        //$(id_galeria).css("background", "url(./imagenes/fondo-galerias_on.png) top left no-repeat");
                        console.log("dentro de botones detalle galeria");
                        console.log(sessionStorage.getItem("id_galeria_actual"));
                        //cambio de pagina
                        //actualizamos las variables
                        sessionStorage.setItem("pagina_navegar", "detalle-galeria");
                        window.setTimeout('cambio_pagina()', 300);
                    }

                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    console.log('Fallo en la lectura de datos. Inténtelo más tarde.');
                }
            });
        }
        //CUANDO NO HAY CONEXION NO SE AVANZA Y SE MUESTRA UNA ALERTA O ALGO7
        else {
            console.log("no hay conexion");
        }
    });
}


//funcion para cargar fotos de una galeria
function cargar_detalle_galeria() {

    console.log("llamada a la carga");
    var contenedorinfo = pagina_actual("#contenedor_detalle_galeria");
    //comprobar_conexion();

    var total = 0;

    //SI HAY CONEXION
    if (sessionStorage.getItem('estado_conexion') == "si") {
        //Guardo en local los datos de la galeria
        //salvamos los datos en local
        datos_en_memoria = JSON.parse(localStorage.getItem('detalle_galerias_galeria'));

        total = datos_en_memoria.galeria.length;

        //CARGA DE LA GALERIA DE LA NOTICIA
        if (total != 0) {
            $.each(datos_en_memoria.galeria, function (i, galeria) {
                $(contenedorinfo).append("<div class='contenedor_info_galerias'><div class='imagen_fondo_galerias' style='background:url(" +
                    galeria.imagen + ") center center no-repeat; background-size:cover;'><a href='" + galeria.zoomimagen + "' rel='external'><img src='./imagenes/botones/trans.png'/></a></div></div>");
            });
            $('.capa_anima_carga').css("display", "none");
            var
                currentPage = $("#detalle-galeria-galeria"),
                options = {},
                photoSwipeInstance = $(".imagen_fondo_galerias a", "#secdetallegaleria").photoSwipe();
            sessionStorage.setItem("galeria_actual", photoSwipeInstance.id);
            return true;
        }
    }
    //CUANDO NO HAY CONEXION
    else {
        //borramos contenido y cargamos
        $('.capa_anima_carga').css("display", "none");
        $('.contenedor_alerta').css("display", "inherit");
        $(contenedorinfo).css("display", "none");
        $('.contenedor_alerta').append("<div style='width:100%; text-align:center; margin-top:150px;'><img src='./imagenes/alerta.png' /><br />No dispone de conexión.<br />Necesita conectarse a Internet.</div>");
        $('.contenedor_alerta').animate({ "opacity": 1 }, 200);
    }
    return true;
}


    /**
     * EVENTOS DE CADA PAGINA
     * Acciones segun la carga de una pagina u otra
     */

    //PORTADA
    $(document).on('pagebeforecreate', '#secportada', function (e) {
        sessionStorage.setItem("pagina_navegar", "index");
        botones_cabecera();
        botones_inicio();
    });

    $(document).on('pagebeforeshow', '#secportada', function (e) {
        botones_portada();
        $(".menu_cabecera").hide();
    });

    $(document).on('pageshow', '#secportada', function (e) {
        $(".contenedor_carga").addClass('contenedor_carga_portada');
    });

    //EMPRESA
    $(document).on('pagebeforeshow', '#sechistoria', function (e) {
        establecerPagina('historia');
        botones_cabecera();
        cargar_panel("historia");
        botones_panel();
    });

    //REDES SOCIALES
    $(document).on('pagebeforeshow', '#secredes', function (e) {
        establecerPagina('redes');
        botones_cabecera();
        cargar_panel("redes");
        botones_panel();
        botones_redes();
    });

    //NOTICIAS
    $(document).on('pagebeforeshow', '#secnoticias', function (e) {
        establecerPagina('noticias');
        botones_cabecera();
        cargar_panel("noticias");
        botones_panel();
        botones_noticias();
        cargar_noticias();
    });

    //DETALLE DE UNA NOTICIA
    $(document).on('pagebeforeshow', '#secdetallenoticia', function (e) {
        establecerPagina('detallenoticia');
        botones_cabecera();
        cargar_panel("detallenoticia");
        botones_panel();
        detalle_noticia();
    });
    $(document).on('pageshow', '#secdetallenoticia', function (e) {
        enlaces_noticia();
    });

    //Eventos de carga del detalle de una galeria de una noticia
    $(document).on("pagebeforeshow", "#secdetallegalerianoticia", function (e) {
        establecerPagina('detallegalerianoticia');
        botones_cabecera();
        cargar_panel("detallegalerianoticia");
        botones_panel();
        detalle_galeria_noticia();
    });

    $(document).on("pagehide", "#secdetallegalerianoticia", function (e) {
        var aux = sessionStorage.getItem("galeria_actual");
        if (typeof aux != "undefined" && aux != null) {
            $(aux).remove();
            sessionStorage.removeItem("galeria_actual");
            console.log("eliminado");
        }
        return true;
    });

    //Eventos de carga del listado de galerias
    $(document).on("pagebeforeshow", "#secgalerias", function (e) {
        establecerPagina('galerias');
        botones_cabecera();
        cargar_panel("galerias");
        botones_panel();
        cargar_galerias();
        botones_detalle_galeria();
    });

    //Eventos de carga del detalle de una galeria
    $(document).on("pagebeforeshow", "#secdetallegaleria", function (e) {
        establecerPagina('detallegaleria');
        botones_cabecera();
        cargar_panel("detallegaleria");
        botones_panel();
    });
    $(document).on("pageshow", "#secdetallegaleria", function (e) {
        cargar_detalle_galeria();
    });
    $(document).on("pagehide", "#secdetallegaleria", function (e) {
        var aux = sessionStorage.getItem("galeria_actual");
        if (typeof aux != "undefined" && aux != null) {
            $(aux).remove();
            sessionStorage.removeItem("galeria_actual");
            console.log("eliminado");
        }
        return true;
    });

    //EMPRESA
    $(document).on('pagebeforeshow', '#secacerca', function (e) {
        establecerPagina('acerca');
        botones_cabecera();
        cargar_panel("acerca");
        botones_panel();
        enlace_indalweb();
    });