(function () {
  var COMPAT_ENVS = [
    ['Firefox', ">= 16.0"],
    ['Google Chrome',
     ">= 24.0 (you may need to get Google Chrome Canary), NO Blob storage support"]
  ];
  /*var compat = $('#compat');
  compat.empty();
  compat.append('<ul id="compat-list"></ul>');
  COMPAT_ENVS.forEach(function(val, idx, array) {
    $('#compat-list').append('<li>' + val[0] + ': ' + val[1] + '</li>');
  });
*/
  const DB_NAME = 'menumbers';
  const DB_VERSION = 4; // Use a long long for this value (don't use a float)
  const DB_STORE_NAME = 'plates';

  var db;

  // Used to keep track of which view is displayed to avoid to uselessly reload it
  var current_view_pub_key;

  function openDb() {
    console.log("openDb ...");
    var req = indexedDB.open(DB_NAME, DB_VERSION);
    req.onsuccess = function (evt) {
      // Better use "this" than "req" to get the result to avoid problems with
      // garbage collection.
      // db = req.result;
      db = this.result;
	  
	  var store = getObjectStore(DB_STORE_NAME, 'readwrite');
 
	 displayPlatesList(store);
	  
	  
	  
      console.log("openDb DONE");
    };
    req.onerror = function (evt) {
      console.error("openDb:", evt.target.errorCode);
    };

    req.onupgradeneeded = function (evt) {
      console.log("openDb.onupgradeneeded");
	  
	 // var storeOld = getObjectStore(DB_STORE_NAME, 'readwrite');
	 
      var store = evt.currentTarget.result.createObjectStore(
        DB_STORE_NAME, { keyPath: 'id', autoIncrement: true });

      store.createIndex('plateNumber', 'plateNumber', { unique: true });
      
    };
  }

  /**
   * @param {string} store_name
   * @param {string} mode either "readonly" or "readwrite"
   */
  function getObjectStore(store_name, mode) {
    var tx = db.transaction(store_name, mode);
    return tx.objectStore(store_name);
  }

  function clearObjectStore(store_name) {
    var store = getObjectStore(DB_STORE_NAME, 'readwrite');
    var req = store.clear();
    req.onsuccess = function(evt) {
      displayActionSuccess("Store cleared");
      displayPlateList(store);
    };
    req.onerror = function (evt) {
      console.error("clearObjectStore:", evt.target.errorCode);
      displayActionFailure(this.error);
    };
  }

 

  /**
   * @param {IDBObjectStore=} store
   */
  function displayPlatesList(store) {
    console.log("displayPlateList");

    if (typeof store == 'undefined')
      store = getObjectStore(DB_STORE_NAME, 'readonly');

    var plates_msg = $('#plates-msg');
    plates_msg.empty();
    var plates_list = $('#plates-list');
    plates_list.empty();
    // Reseting the iframe so that it doesn't display previous content
    //newViewerFrame();

    var req;
    req = store.count();
    // Requests are executed in the order in which they were made against the
    // transaction, and their results are returned in the same order.
    // Thus the count text below will be displayed before the actual pub list
    // (not that it is algorithmically important in this case).
    req.onsuccess = function(evt) {
      plates_msg.append('<p>Trenutno imate <strong>' + evt.target.result +
                     '</strong> registarskih tablica.</p>');
					 //alert(evt.target.result);
    };
    req.onerror = function(evt) {
      console.error("add error", this.error);
      displayActionFailure(this.error);
    };

    var i = 0;
    req = store.openCursor();
    req.onsuccess = function(evt) {
      var cursor = evt.target.result;

	  
      // If the cursor is pointing at something, ask for the data
      if (cursor) {
        console.log("displayPlateList cursor:", cursor);
        //req = store.get(cursor.key);
        //req.onsuccess = function (evt) {
          //var value = evt.target.result;
         
          plates_list.append('<li> <a href="#"><p>' + cursor.value.plateNumber + '</p></a></li>');
		  console.log(cursor.value.plateNumber);
        //};

        // Move on to the next object in store
        cursor.continue();

        // This counter serves only to create distinct ids
        i++;
      } else {
        console.log("No more entries");
      }
    };
  }

  /*function newViewerFrame() {
    var viewer = $('#pub-viewer');
    viewer.empty();
    var iframe = $('<iframe />');
    viewer.append(iframe);
    return iframe;
  }

  function setInViewer(key) {
    console.log("setInViewer:", arguments);
    key = Number(key);
    if (key == current_view_pub_key)
      return;

    current_view_pub_key = key;

    var store = getObjectStore(DB_STORE_NAME, 'readonly');

  }

  /**
   * @param {string} biblioid
   * @param {string} title
   * @param {number} year
   * @param {Blob=} blob
   */
  function addPlate(plateNumber) {
    console.log("addPlate arguments:", arguments);
    var obj = { plateNumber: plateNumber};
    
    var store = getObjectStore(DB_STORE_NAME, 'readwrite');
    var req;
    try {
      req = store.add(obj);
    } catch (e) {
      if (e.name == 'DataCloneError')
        displayActionFailure("This engine doesn't know how to clone a Blob, " +
                             "use Firefox");
      throw e;
    }
    req.onsuccess = function (evt) {
      console.log("Insertion in DB successful");
      displayActionSuccess();
      displayPlatesList(store);
    };
    req.onerror = function() {
      console.error("addPlate error", this.error);
      displayActionFailure(this.error);
    };
  }

  /**
   * @param {string} biblioid
   */
  function deletePlate(plateNumber) {
    console.log("deletePublication:", arguments);
    var store = getObjectStore(DB_STORE_NAME, 'readwrite');
    var req = store.index('plateNumber');
    req.get(plateNumber).onsuccess = function(evt) {
      if (typeof evt.target.result == 'undefined') {
        displayActionFailure("No matching record found");
        return;
      }
      deletePlate(evt.target.result.id, store);
    };
    req.onerror = function (evt) {
      console.error("deletePublicationFromBib:", evt.target.errorCode);
    };
  }

  /**
   * @param {number} key
   * @param {IDBObjectStore=} store
   */
  function deletePlate(key, store) {
    console.log("deletePlate:", arguments);

    if (typeof store == 'undefined')
      store = getObjectStore(DB_STORE_NAME, 'readwrite');

    // As per spec http://www.w3.org/TR/IndexedDB/#object-store-deletion-operation
    // the result of the Object Store Deletion Operation algorithm is
    // undefined, so it's not possible to know if some records were actually
    // deleted by looking at the request result.
    var req = store.get(key);
    req.onsuccess = function(evt) {
      var record = evt.target.result;
      console.log("record:", record);
      if (typeof record == 'undefined') {
        displayActionFailure("No matching record found");
        return;
      }
      // Warning: The exact same key used for creation needs to be passed for
      // the deletion. If the key was a Number for creation, then it needs to
      // be a Number for deletion.
      req = store.delete(key);
      req.onsuccess = function(evt) {
        console.log("evt:", evt);
        console.log("evt.target:", evt.target);
        console.log("evt.target.result:", evt.target.result);
        console.log("delete successful");
        displayActionSuccess("Deletion successful");
        displayPlateList(store);
      };
      req.onerror = function (evt) {
        console.error("deletePublication:", evt.target.errorCode);
      };
    };
    req.onerror = function (evt) {
      console.error("deletePublication:", evt.target.errorCode);
      };
  }

  function displayActionSuccess(msg) {
    msg = typeof msg != 'undefined' ? "Uspjesno: " + msg : "Uspjesno";
    $('#msg').html('<span class="action-success">' + msg + '</span>');
  }
  function displayActionFailure(msg) {
    msg = typeof msg != 'undefined' ? "Greska: " + msg : "Greska";
    $('#msg').html('<span class="action-failure">' + msg + '</span>');
  }
 
  function addEventListeners() {
    

    $('#add-plate-button').click(function(evt) {
      console.log("add ...");
	  
      var plateNumber = $('#plateNumber').val();

      if (!plateNumber) {
        displayActionFailure("Molimo Vas da unesete broj tablice");
        return;
      }
        addPlate(plateNumber);
      
    });
	
	$('#close-plate-button').click(function(evt) {
      console.log("add ...");
	  
      document.querySelector('#toolbars').className = 'right';
      
    });

	$('ul.plates-list li').live("click", function() {
        
		window.localStorage['plateNumber'] = $(this).text();
		alert('Odabrali ste tablicu broj:' + $(this).text());
		window.location = "parking.html";
    });
	
    /*$('#plates-list').click(function(evt) {
      console.log("delete ...");
      var plateNumber = this.val();
      //var key = $('#key-to-delete').val();
		alert(plateNumber);
      if (plateNumber != '') {
       deletePlate(plateNumber);
      }
    });*/



  }

  
  openDb();
   
  addEventListeners();
 
 

})(); // Immediately-Invoked Function Expression (IIFE)