//Definición de variables globales
var t0; //Tiempo absoluto de inicio
var lsDisp = false; //LocalStorage disponible
var crono = new Object(); //Objeto con las propiedades del cronómetro
var difUTC = new Date().getTimezoneOffset()*6e4; //Diferencia horaria UTC - hora local en milisegundos
/*
crono.estado -> 1 en marcha, 0 parado
crono.tiempos -> contiene el vector con los tiempos
*/
var ulParciales; //<ul> con tiempos parciales
var cronoH, cronoM, cronoS, cronoMS; //Etiquetas del crono
var tacL, tacR; //Iconos de los eventos táctiles
var btnIniciar, btnParcial, btnParar, btnReiniciar; //Botones
var movCrono; //Intervalo para el crono

$(function() {
	//Se pone en funcionamiento el reloj con la hora local
	setInterval(function() {reloj();},1000);
	//Verificamos si se puede usar localStorage
	lsDisp = localStorageSoportado();
	//Asignación de los elementos HTML a las variables globales
	ulParciales = $('#ulParciales');
	cronoH = $('#cronoH');
	cronoM = $('#cronoM');
	cronoS = $('#cronoS');
	cronoMS = $('#cronoMS');
	tacL = $('#tacL');
	tacR = $('#tacR');
	btnIniciar = $('#btnIniciar');
	btnParcial = $('#btnParcial');
	btnParar = $('#btnParar');
	btnReiniciar = $('#btnReiniciar');
	btnParar.attr('disabled','disabled');
	//Asignación de eventos a los botones
	btnIniciar.on('click', iniciar);
	btnParcial.on('click', parcial);
	btnParar.on('click', parar);
	btnReiniciar.on('click', reiniciar);
	//Asignación de eventos táctiles
	$('article#crono').on('swipeRight', function() {
		if(btnReiniciar.css('display') !== 'none') {reiniciar();}
	});
	$('article#crono').on('singleTap', function() {
		if(btnIniciar.css('display') !== 'none') {iniciar();}
		else if((btnParcial.css('display') !== 'none') && (btnReiniciar.css('display') === 'none')) {parcial();}
	});
	$('article#crono').on('doubleTap', function() {
		if(btnParar.css('display') !== 'none') {parar();}
	});
	
	if(lsDisp) {
		//Verificamos que si existe un listado de tiempos guardado
		//y si el crono continúa o no en marcha
		if(localStorage.getItem('crono') !== null) {
			//Se carga el listado de tiempos
			ulParciales.empty();
			//El objeto crono está almacenado como cadena por lo que hay que recuperarlo a JSON
			crono = JSON.parse(localStorage.getItem('crono'));
			console.log('Datos previos disponibles');
			//Se convierten los elementos de crono.tiempos en objetos Date
			for(var p = 0; p < crono.tiempos.length; p++) {
				crono.tiempos[p] = new Date(crono.tiempos[p]);
				if(p === 0) {t0 = crono.tiempos[p];}
				//Se muestras los tiempos parciales excepto el últmo si el cronómetro esta parado
				else if((p !== crono.tiempos.length-1) && !crono.estado) {
					pintaParcial(p)
				}
			}
			//Verificamos si el cronómetro estaba en marcha
			if(crono.estado) {
				btnIniciar.hide();
				btnParcial.show().removeAttr('disabled');
				btnParar.removeAttr('disabled');
				pintaIconos('SingleTap','DoubleTap');
				//Se pone en marcha el cronómetro
				movCrono = setInterval(function() {mueveCrono();},50);
			} else {
				btnParcial.show().attr('disabled','disabled');
				btnIniciar.hide();
				btnParar.hide();
				btnReiniciar.show();
				//Pintamos el último tiempo registrado en el cronómetro que es el de parada
				var t = new Date(crono.tiempos.last() - t0 + difUTC);
				pintaCrono(t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds());
				pintaIconos('None','SwipeRight');
			}
		} else {
			console.log('No hay datos previos disponibles');
			//El crono se muestra inicializado
			crono.estado = 0;
			crono.tiempos = new Array();
			ulParciales.empty();
			pintaCrono(0,0,0,0);
			pintaIconos('SingleTap','None');
		}
	}
});


function iniciar() {
	//Todos lo tiempos se calculan a partir del tiempo absoluto t0
	t0 = new Date();
	crono.estado = 1;
	crono.tiempos[0] = t0;
	btnIniciar.hide();
	btnParcial.show().removeAttr('disabled');
	btnParar.removeAttr('disabled');
	pintaIconos('SingleTap','DoubleTap');
	console.log('Se inicia el crono a las '+t0);
	//Se pone en marcha el cronómetro
	movCrono = setInterval(function() {mueveCrono();},50);
	guardarLocalStorage();
}

function mueveCrono() {
	var t = new Date();
	var d = new Date(t - t0);
	//La diferencia horaria se ajusta a horas
	pintaCrono(d.getHours()+(difUTC/36e5),d.getMinutes(),d.getSeconds(),d.getMilliseconds());	
}

function parar() {
	//Se anula el movimiento del cronómetro
	clearTimeout(movCrono);
	var t = new Date();
	var d = new Date(t - t0);
	//Se representa el último tiempo en el cronómetro
	pintaCrono(d.getHours()+(difUTC/36e5),d.getMinutes(),d.getSeconds(),d.getMilliseconds());
	crono.estado = 0;
	crono.tiempos[crono.tiempos.length] = t;
	btnParcial.attr('disabled','disabled');
	btnParar.hide();
	btnReiniciar.show();
	pintaIconos('None','SwipeRight');
	guardarLocalStorage();
	console.log('Se para el crono a las '+t);
}

function reiniciar() {
	if(confirm('¿Deseas poner a cero el cronómetro y borrar los tiempos registrados?')) {
		crono.tiempos.length = 0;
		localStorage.removeItem('crono');
		ulParciales.empty();
		pintaCrono(0,0,0,0);
		console.log('Reiniciado el crono. Eliminados los tiempos parciales.');
		btnIniciar.show();
		btnParar.show().attr('disabled','disabled');
		btnReiniciar.hide();
		btnParcial.removeAttr('disabled').hide();
		pintaIconos('SingleTap','None');
	};
}

function pintaCrono(h,m,s,ms) {
	//Se ajustan todos los tiempo con ceros delante
	//y se representan en la etiqueta correspondiente
	cronoH.html(('00'+h).substr(-2));
	cronoM.html(('00'+m).substr(-2));
	cronoS.html(('00'+s).substr(-2));
	cronoMS.html(('00'+parseInt(ms/10)).substr(-2));
}

function parcial() {
	//Se registra el parcial y se añade a la lista
	var t = new Date();
	crono.tiempos[crono.tiempos.length] = t;
	guardarLocalStorage();
	pintaParcial(crono.tiempos.length-1,true);
}

function pintaParcial(p,a) {
	/*
	Cada parcial lleva tres tiempos:
	1. La diferencia con t0 o tiempo de inicio del crono
	2. Diferencia respecto del parcial anterior (a partir del segundo parcial)
	3. Diferencia respecto del primer parcial (a partir del segundo parcial)
	*/
	var t = crono.tiempos[p];
	var dAbs = new Date(t - t0 + difUTC);
	var dPrev = new Date(t - crono.tiempos[p-1] + difUTC);
	var dPrim = new Date(t - crono.tiempos[1] + difUTC);
	ulParciales.prepend(
		'<li><span class="pos" data-pos="'+p+'">'+('00'+p).substr(-2)+'</span>'+
		'<div><span class="parD">'+((p>1) ? ('+'+formatoTiempo(dPrev)) : '')+'</span>'+
		'<span class="par1">'+((p>1) ? ('+'+formatoTiempo(dPrim)) : '')+'</span></div>'+
        '<p>'+formatoTiempo(dAbs)+'</p></li>'
	);
	//Representamos un parpadeo de cada parcial cuando el crono está en marcha
	if(a) {
		var li = $('span.pos[data-pos="'+p+'"]').closest('li');
		li.animate({opacity: 0}, 500, 'ease-out', function() {
			li.animate({opacity: 1}, 500, 'ease-out', function() {
				li.animate({opacity: 0}, 500, 'ease-out', function() {
					li.animate({opacity: 1}, 500, 'ease-out');
				});
			});
		});
	}
}

function pintaIconos(l,r) {
	//Modifica las clases para representar los eventos táctiles disponibles en cada momento
	tacL.removeClass().addClass('icono ico'+l);
	tacR.removeClass().addClass('icono ico'+r);
}

function guardarLocalStorage() {
	if(lsDisp) {
		//El objeto crono se conviente en JSON para poder almacenarlo como cadena
		localStorage.setItem('crono',JSON.stringify(crono));
	}
}

function formatoTiempo(t) {
	//Se ajusta cada tiempo con ceros a la izquierda
	return ('00'+t.getHours()).substr(-2)+
		':'+('00'+t.getMinutes()).substr(-2)+
		':'+('00'+t.getSeconds()).substr(-2)+
		'.'+('00'+Math.round(t.getMilliseconds()/10, 2)).substr(-2);
}

//Muestra la hora local
function reloj() {
	var r = new Date();
	$('#reloj').html(
		('00'+r.getHours()).substr(-2)+
		':'+('00'+r.getMinutes()).substr(-2)+
		':'+('00'+r.getSeconds()).substr(-2)
	);
}

//Verifica si localStorage está disponible
function localStorageSoportado(){
  try {
    return 'localStorage' in window && window['localStorage'] !== null;
  } catch (e) {
    return false;
  }
}

//Devuelve el último elemento de un vector
if(!Array.prototype.last) {
    Array.prototype.last = function() {
        return this[this.length - 1];
    }
}