function settingsObj(localStorageName){
	instance = this;
	this.appDomain = localStorageName; 
	this.settings = null;
	
	this.load = function() {
		function isEmpty(obj) {for(var prop in obj) {if(obj.hasOwnProperty(prop))return false;	}return true;}
		var value = localStorage.getItem(this.appDomain);
		if (!isEmpty(JSON.parse(value))) {
			this.settings = value && JSON.parse(value); 
			return true;
		} else return false;
	}
	
	this.save = function() {
		localStorage.setItem(this.appDomain, JSON.stringify(this.settings));
	}
	
	this.clear = function(clearAll=false) { 
		//console.log('clear localStorage name:' + this.appDomain);
		localStorage.clear(this.appDomain);
		if (clearAll) this.settings = null;
	}	
	
	
}

settingsObj.prototype.getSettings = function() {
	return this.settings;
}


$(document).ready(function() {
	$('#viewPort').hide().transition({ scale: '0.75', opacity: 0});

	var trans = new translateObj({
		'defaultLang':'en',
		'autoDetect': true,
		'onTranslateEnd': function() {
			$('#viewPort').show().transition({ scale: '1', opacity: 1});
			
		}
	});
	trans.initTranslate();
	advertisement.init();
	
	
	var settings = new settingsObj('stopwatch');
	if (!settings.load()) $('#btnDeleteData').hide();
	$('#dataApp').html('');
	var obj = settings.getSettings();
	for(var index in obj) { 
		if (obj.hasOwnProperty(index)) {
			var value = obj[index];
			$('#dataApp').append(index + '=' + value+'<br />');
		}
	}
	
	

	$('#btnBack').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '1.25', opacity: 0}).delay(30).queue(function(){
			location.href = 'main.html';
		});
	});
	
	$('#btnDeleteData').click(function(e) {
		e.preventDefault();
		settings.clear();
		location.href="about.html"
	});
		
	
	
$('a').click(function(e) {
	e.preventDefault();
	e.stopPropagation();
	goUrl = $(this).prop('href');
	target = $(this).prop('target');
	if (target == '_blank') {
	//open url by web Activity
		var openURL = new MozActivity({
			name: "view",
			data: {
				type: "url",
				url: goUrl
			}
		});	
	}
	
});	
	
});

