Array.prototype.max = function() {
  return Math.max.apply(null, this);
};

Array.prototype.min = function() {
  return Math.min.apply(null, this);
};

var flagPlay = true;

$(document).ready(function() {
	//refresh displays
	function refreshDisplay() {
		$('#timerDisplay').html(secondsToHHMMSS(stopWatch.getTime() / 10));
		$('#lastLapInfo').html(secondsToHHMMSS(stopWatch.settings.lastLap / 10));
		
	}
	
	function refreshLapsDisplay() {	
		$('#partialList').html('');
		var laps = stopWatch.settings.laps;
		if (!(laps == null)) {
			laps = laps.toString();
			if (!(laps.indexOf(','))) {
				laps = ',' + laps;
			}
			laps = laps.split(',');
			total = laps.length;
		} else {
			total=0;
		}
		var lapsSeconds = new Array();
		if (total> 0) {
		
			//obtener los segundos transcurridos entre cada vuelta
			for (var i=total-1;i>=0;--i) {
				totalSeconds = laps[i];
				lapSeconds = laps[i-1];
				if (typeof(lapSeconds) === 'undefined') lapSeconds=0;
				lapSeconds = totalSeconds - lapSeconds;
				lapsSeconds[i] = lapSeconds;
			}
			
			//detectar que vuelta es mas rapida y la mas lenta
			lapsSeconds[0] = laps[0];
			minIndex = lapsSeconds.indexOf(lapsSeconds.min());
			maxIndex = lapsSeconds.indexOf(lapsSeconds.max());
			if (maxIndex == -1) maxIndex = 0;
			if (minIndex == -1) minIndex = 0;
			//console.log('Fast lap' + minIndex + ' ' + lapsSeconds[minIndex] );
			//console.log('Slow lap' + maxIndex + ' ' + lapsSeconds[maxIndex] );
			//console.dir(lapsSeconds);
			
			//mostrar los resultados por pantalla
			for (var i=total-1;i>=0;--i) {
				totalSeconds = laps[i];
				lapSeconds = laps[i-1];
				if (typeof(lapSeconds) === 'undefined') lapSeconds=0;
				lapSeconds = totalSeconds - lapSeconds;
				lapsSeconds[i] = lapSeconds;
				iconClass= '';
				if (i == maxIndex) iconClass = '<span class="floatLeft icon iconSlow">&nbsp</span>';
				if (i == minIndex) iconClass = '<span class="floatLeft icon iconFast">&nbsp</span>';
				$('#partialList').append('<li><span class="floatLeft">' + trans.echo('lap') + ' ' + i + '</span>' + iconClass + '<em class="floatRight textBlue">+' + secondsToHHMMSS(lapSeconds/10)+ '</em><em class="floatRight textGray">' + secondsToHHMMSS(totalSeconds/10)+'</em></li>');
			}
			$('#partialList li').first().addClass('blink');
		} else {
			$('#partialList').html('<li>' + trans.echo('empty') + '</li>');
		}	
	}
	//end display funcitons
		
	
	//initiate app
	$('#viewPort').css({opacity: 0}); 
	
	var trans = new translateObj({
		'defaultLang':'en',
		'autoDetect': true,
		'onTranslateEnd': function() {
			$('#viewPort').transition({ scale: '1.2', opacity: 0}).transition({ scale: '1', opacity: 1});	
		}
	});
	trans.initTranslate();
	
	/*Main action buttons*/
	
	stopWatch = new appObj();
	stopWatch.load();
	refreshDisplay();
	refreshLapsDisplay();
	
	$('#btnPlayPause').click(function(){
		flagPlay = !flagPlay;
		if (!flagPlay) {
			stopWatch.start();
			$(this).attr('class','').addClass('btnCircle textRed').html(trans.echo('stop'));
			$('#btnLapReset').attr('class','').addClass('btnCircle textBlue').html(trans.echo('lap'));
		} else {
			stopWatch.stop();
			$(this).attr('class','').addClass('btnCircle textGreen').html(trans.echo('start'));
			$('#btnLapReset').attr('class','').addClass('btnCircle textOrange').html(trans.echo('reset'));
		}
		stopWatch.save();
	});

	$('#btnLapReset').click(function() {
		if (!flagPlay) {
			//lap button
			stopWatch.lap();
			//refrescar laps
		} else {
			//reset button
			stopWatch.reset();
		}
		refreshDisplay();
		refreshLapsDisplay();
		stopWatch.save();
	});
	
	$('#btnDeleteAllPartials').click(function(e) {
		e.preventDefault();
		alert('send email');
	});

	/*App Menu options*/
	$('#btnHelp').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'help.html';
		});
	});
	
	$('#btnAbout').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'about.html';
		});
	});

	$('#btnExit').click(function(e) {
		e.preventDefault();
		window.close();
	});

	
});

(function($) {
	$(document).ready(function() {
		$.slidebars();
	});
}) (jQuery);