function appObj() {
	instance = this;
	this.appDomain = 'stopwatch';
	this.settings = {
		"seconds" : 0,
		"lastLap" : 0,
		"laps" : null
	}
	this.timer = null;

	//priveleged functions for load,save & clear settings in localstorage
	this.load = function() {
		function isEmpty(obj) {for(var prop in obj) {if(obj.hasOwnProperty(prop))return false;	}return true;}
		var value = localStorage.getItem(this.appDomain);
		if (!isEmpty(JSON.parse(value))) this.settings = value && JSON.parse(value); else console.log('empty values');
	}
	
	this.save = function() {
		localStorage.setItem(this.appDomain, JSON.stringify(this.settings));
	}
	
	this.clear = function(clearAll=false) { 
		//console.log('clear localStorage name:' + this.appDomain);
		localStorage.clear(this.appDomain);
		if (clearAll) this.settings = null;
	}
	
	this.countTime = function() {
		this.settings.seconds++;
		//console.log(this.settings.seconds);
		this.onCountTime();
	}
	
}

function secondsToHHMMSS(number) {
    var sec_num = parseInt(number, 10); // don't forget the second param
    var hours   = Math.floor(sec_num / 3600);
    var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
    var seconds = sec_num - (hours * 3600) - (minutes * 60);
	
    if (hours   < 10) {hours   = "0"+hours;}
    if (minutes < 10) {minutes = "0"+minutes;}
    if (seconds < 10) {seconds = "0"+seconds;}

	//var intPart = Math.floor(number / 10);
	var miliseconds = (number % 1)*10;
	miliseconds = miliseconds.toFixed(0);
	
	//seconds = seconds + 'a' + miliseconds;
    var time = hours+':'+minutes+':'+seconds + '.' + miliseconds;
    return time;
}

//set public methods

appObj.prototype.start = function() {
	clearInterval(this.timer);
	this.timer = setInterval(function() {instance.countTime();},100);
}

appObj.prototype.stop = function() {
	clearInterval(this.timer);
}

appObj.prototype.reset = function() {
	clearInterval(this.timer);
	this.settings.seconds = 0;
	this.settings.lastLap = 0;
	this.settings.laps=null;
}

appObj.prototype.lap = function() {
	str = this.settings.seconds;
	this.settings.lastLap = str;
	
	if (this.settings.laps != null) str = ',' + str; 
	this.settings.laps = this.settings.laps + str;
	
	//console.log(this.settings.laps);
}

appObj.prototype.clearLaps = function() {
	this.settings.laps = null;
}

appObj.prototype.getTime = function() {
	return this.settings.seconds;
}

/*refreshing display methods*/
appObj.prototype.onCountTime = function() {
	var secondsNow = this.getTime();
	var secondsLast = this.settings.lastLap;
	$('#timerDisplay').html(secondsToHHMMSS(secondsNow / 10));
	
	$('#lastLapInfo').html(secondsToHHMMSS((secondsNow - secondsLast) / 10));

}
