var selections = JSON.parse(sessionStorage.selections);
var data = new Object;
var toLoad = selections.length;
var loaded = 0;

var askYear = false;

var score = 0;
var start = Date.now();
var hud;

function updateHUD(){
	var now = Date.now();
	var elapsed = new Date(now - start);
	document.getElementById("score").textContent = score;
	document.getElementById("time").textContent = elapsed.getUTCMinutes() + ":" + elapsed.getUTCSeconds();
}

function gameOver(){
	// puntuación y redes sociales
	clearInterval(hud);
	document.getElementById("question").textContent = "Fin del juego - " + score + " puntos";
	document.getElementById("question").className = "game-over";
	document.getElementById("slot1").className = "slot-over";
	document.getElementById("slot2").className = "slot-over";
	document.getElementById("slot3").className = "slot-over";
	document.getElementById("slot4").className = "slot-over";
	document.getElementById("game-over").className = "";
}

function checkAnswer(evt){
	var correct;
	if(evt.target.dataset.answer == "true"){
		score += 100;
		evt.target.className += " slot-correct";
		correct = true;
	}else{
		evt.target.className += " slot-wrong";
		correct = false;
	}
	setTimeout(function(){
		if(correct){
			// Next Question
			doQuestion();
		}else{
			gameOver();
		}
	},750); // Wait for CSS Transition
	
	
	// Efectos Visuales y sonoros
	
	// Actualizar HUD
	
	// gameOver si necesario
	
	// Más preguntas
	// Evitar dobles respuestas
}

function getRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function doQuestion(){
	document.getElementById("slot1").className = "slot";
	document.getElementById("slot2").className = "slot";
	document.getElementById("slot3").className = "slot";
	document.getElementById("slot4").className = "slot";
	
	var keys = Object.getOwnPropertyNames(data);
	var ballot = getRandomInt(0,keys.length);
	var question = data[keys[ballot]];
	
	// Mitad de probabilidades de preguntar año / mitad de preguntar evento
	if(getRandomInt(0,2) == 0){
		askYear = true;
	}else{
		askYear = false;
	}
	
	// Obtener otras respuestas falsas
	var ballot1 = getRandomInt(0,keys.length);
	var ballot2 = getRandomInt(0,keys.length);
	var ballot3 = getRandomInt(0,keys.length);
	
	if(ballot1 === ballot) {
		ballot1++;
		if(ballot1 === keys.length)
		{
			ballot1-=2;
		}
	}
	if(ballot2 === ballot) {
		ballot2++;
		if(ballot2 === keys.length)
		{
			ballot2-=2;
		}
	}
	if(ballot3 === ballot) {
		ballot3++;
		if(ballot3 === keys.length)
		{
			ballot3-=2;
		}
	}
	
	var answer1 = data[keys[ballot1]];
	var answer2 = data[keys[ballot2]];
	var answer3 = data[keys[ballot3]];
	
	
	// Poner pregunta
	document.getElementById("question").textContent = (askYear) ? ""+question : ""+keys[ballot];
	
	// Elegir lugar para la verdadera
	document.getElementById("slot1").dataset.answer = "false";
	document.getElementById("slot2").dataset.answer = "false";
	document.getElementById("slot3").dataset.answer = "false";
	document.getElementById("slot4").dataset.answer = "false";
	
	var lugar = getRandomInt(1,4+1);
	if(lugar == 1){
		document.getElementById("slot1").textContent = (askYear) ? keys[ballot] : question;
		document.getElementById("slot1").dataset.answer = "true";
		document.getElementById("slot2").textContent = (askYear) ? keys[ballot1] : answer1;
		document.getElementById("slot3").textContent = (askYear) ? keys[ballot2] : answer2;
		document.getElementById("slot4").textContent = (askYear) ? keys[ballot3] : answer3;
	}
	if(lugar == 2){
		document.getElementById("slot2").textContent = (askYear) ? keys[ballot] : question;
		document.getElementById("slot2").dataset.answer = "true";
		document.getElementById("slot1").textContent = (askYear) ? keys[ballot1] : answer1;
		document.getElementById("slot3").textContent = (askYear) ? keys[ballot2] : answer2;
		document.getElementById("slot4").textContent = (askYear) ? keys[ballot3] : answer3;
	}
	if(lugar == 3){
		document.getElementById("slot3").textContent = (askYear) ? keys[ballot] : question;
		document.getElementById("slot3").dataset.answer = "true";
		document.getElementById("slot2").textContent = (askYear) ? keys[ballot1] : answer1;
		document.getElementById("slot1").textContent = (askYear) ? keys[ballot2] : answer2;
		document.getElementById("slot4").textContent = (askYear) ? keys[ballot3] : answer3;
	}
	if(lugar == 4){
		document.getElementById("slot4").textContent = (askYear) ? keys[ballot] : question;
		document.getElementById("slot4").dataset.answer = "true";
		document.getElementById("slot2").textContent = (askYear) ? keys[ballot1] : answer1;
		document.getElementById("slot3").textContent = (askYear) ? keys[ballot2] : answer2;
		document.getElementById("slot1").textContent = (askYear) ? keys[ballot3] : answer3;
	}
	
}

for(var i=0;i<selections.length;i++){
	var xhr = new XMLHttpRequest();
	xhr.open("GET","../quiz/"+selections[i]);
	xhr.addEventListener("load",function(evt){
		var json = JSON.parse(evt.target.responseText);
		for(var question in json){
			data[question] = json[question];
		}
		loaded++;
		if(loaded == selections.length){
			document.getElementById("loading").style.display="none";
			hud = setInterval(updateHUD,1000);
			doQuestion();
		}
	});
	xhr.send();
}

document.getElementById("slot1").addEventListener("click",checkAnswer);
document.getElementById("slot2").addEventListener("click",checkAnswer);
document.getElementById("slot3").addEventListener("click",checkAnswer);
document.getElementById("slot4").addEventListener("click",checkAnswer);
document.getElementById("retry").addEventListener("click",function(){
	if(AdMob) AdMob.showInterstitial();
	window.location.href = "../index.html";
});

document.addEventListener("deviceready",function(){
	/* Google AdMob */
	var bannerIdAndroid = "ca-app-pub-6944504853839360/9481857538";
	var bannerIdWindows = "ca-app-pub-6944504853839360/7725922730";
	var intersticialAd = "ca-app-pub-6944504853839360/7307120337";
	var testBannerId = "ca-app-pub-3940256099942544/6300978111";
	var testIntersticialAd = "ca-app-pub-3940256099942544/1033173712";
	var bannerId;
	if( /(android)/i.test(navigator.userAgent) ) { 
		bannerId = bannerIdAndroid;
		if(AdMob) AdMob.prepareInterstitial( {adId: intersticialAd, autoShow:false} );
	} else {
		bannerId = bannerIdWindows;
	}
	if (AdMob) {
			AdMob.createBanner({
				adId : bannerId,
				position : AdMob.AD_POSITION.BOTTOM_CENTER,
				autoShow : true
			});
	}
});


