var xhr = new XMLHttpRequest();
xhr.open("GET","../quiz/sets.json");
xhr.addEventListener("load",function(){
	var setsDiv = document.getElementById("sets");
	var sets = JSON.parse(xhr.responseText);
	for(var i=0;i<sets.length;i++){
		var div = document.createElement("div");
		div.className = "ck-button";
		var label = document.createElement("label");
		var input = document.createElement("input");
		input.type = "checkbox";
		input.dataset.url = sets[i].url;
		input.className = "setSelection";
		var span = document.createElement("span");
		span.textContent = sets[i].name;
		
		label.appendChild(input);
		label.appendChild(span);
		div.appendChild(label);
		setsDiv.appendChild(div);
	}
});
xhr.send();

document.getElementById("ok").addEventListener("click",function(){
	var setSelectionsHTML = document.getElementsByClassName("setSelection");
	var setSelections = Array.prototype.slice.call( setSelectionsHTML )
	var selections = setSelections.filter(function(sel){
		return sel.checked;
	}).map(function(sel){
		return sel.dataset.url;
	});
	if(selections.length > 0){
		var str = JSON.stringify(selections);
		sessionStorage.selections = str;
		window.location.href = "game.html";
	}
});

