var Krossware = {};
Krossware.MCC = {};


	appURL ='https://marketplace.firefox.com/feed/shelf/telenor-bn';
	facebookShareURL = 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(appURL);
	twitterShareURL = 'https://twitter.com/intent/tweet?url=' + encodeURIComponent(appURL);
	plusShareURL = 'https://plus.google.com/share?url=' + encodeURIComponent(appURL);


	var checkbox_buy = document.getElementById('buy');
	var checkbox_sell = document.getElementById('sell');
	var selection_currency = document.getElementById('currency-selection');
	var textbox_amount = document.getElementById('selection');
	var submit_button = document.getElementById('submit');
	var first_page = document.getElementById('first');
	var second_page = document.getElementById('second');
	var result_amount = document.getElementById('amount');
	var asked_currency = document.getElementById('asked_currency');
	var result_rate = document.getElementById('rate');
	var result_action_type = document.getElementById('current-price');
	var back_button = document.getElementById('back-button');
	var refresh_button = document.getElementById('refresh');
	var share_button = document.getElementById('share-button');
	var facebook_button = document.getElementById('facebook-button');
	var twitter_button = document.getElementById('twitter-button');
	var plus_button = document.getElementById('plus-button');

Krossware.MCC.CurrencyConverter = {

	convert: function(action_type, currency, amount, callback) {

		var req = new XMLHttpRequest({mozSystem:true});
		req.open("post", "http://asholei.com/html5/currencyconverter/ConvertCurrency.php", true);
		req.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		req.send("cur="+currency+"&amount="+amount);
		req.addEventListener('load', function() {
			callback(this.responseText);
		});
	}
};

Krossware.MCC.CurrencyConverter.ui = {
	setupUi: function() {
		checkbox_buy.addEventListener ('click', this.checkbox_click_buy);
		checkbox_sell.addEventListener('click', this.checkbox_click_sell);
		submit_button.addEventListener('click', this.submit_click);
		back_button.addEventListener  ('click', function() {
			Krossware.MCC.CurrencyConverter.ui.showpage(first_page);
		});
		facebook_button.addEventListener('click', this.share_facebook);
		twitter_button.addEventListener('click', this.share_twitter);
		plus_button.addEventListener('click', this.share_plus);
	},
	checkbox_click_sell: function() {
		checkbox_sell.checked = true;
		checkbox_buy.checked = false;
	},
	checkbox_click_buy: function() {
		checkbox_sell.checked = false;
		checkbox_buy.checked = true;
	},
	submit_click: function() {
		var amount = encodeURIComponent(parseFloat(textbox_amount.value));
		var currency = encodeURIComponent(selection_currency.value);
		var action_type = "buy";
		if(checkbox_sell.checked) action_type = "sell";
		refresh_button.classList.add("spin");
		Krossware.MCC.CurrencyConverter.convert(action_type, currency, amount, function(response) {
			result_action_type.textContent = "Current Price: " + action_type;
			asked_currency.textContent = Number(amount).toFixed(2) + " " + currency;
			var rate = parseFloat(response) / parseFloat(amount);
			result_rate.textContent = Number(rate).toFixed(2) + " BDT";
			result_amount.textContent = Number(response).toFixed(2) + " BDT";
			Krossware.MCC.CurrencyConverter.ui.showpage(second_page);
			refresh_button.classList.remove("spin");
		});
	},
	share_facebook: function() {
		var openURL = new MozActivity({
		    name: "view",
		    data: {
		        type: "url", // Possibly text/html in future versions
		        url: facebookShareURL
		    }
		});
	},
	share_twitter: function() {
		var openURL = new MozActivity({
		    name: "view",
		    data: {
		        type: "url", // Possibly text/html in future versions
		        url: twitterShareURL
		    }
		});
	},
	share_plus: function() {
		var openURL = new MozActivity({
		    name: "view",
		    data: {
		        type: "url", // Possibly text/html in future versions
		        url: plusShareURL
		    }
		});
	},
	showpage: function(page) {
		if(page == first_page) {
			first_page.style.zIndex = 1000;
			first_page.style.visibility = "visible";
			second_page.style.zIndex = -1000;
			second_page.style.visibility = "hidden";
		} else {
			first_page.style.zIndex = -1000;
			first_page.style.visibility = "hidden";
			second_page.style.zIndex = 1000;
			second_page.style.visibility = "visible";
		}
	}
};

document.addEventListener('DOMContentLoaded', function() {
	Krossware.MCC.CurrencyConverter.ui.setupUi();
	document.getElementById('refresh').addEventListener('click', function() textbox_amount.value = "");
});
