﻿const MAX_CURRENCIES = 15;

function onCurrencyChange(event)
{
	var elem = document.getElementById('currencySelector');
	var currency = elem.options[elem.selectedIndex].value;  

	var currencies = getCurrencies();
	
	add(currencies.length, currency);
	
	currencies.push(currency);
	localStorage.setItem('currencies', JSON.stringify(currencies));

	update(currencies.length - 1);		
	updateUI();

	elem.selectedIndex = -1;
}

function onValueChange(event)
{	
	update(event.target.name);
}

function onKeyPress(event)
{	
	return ((event.keyCode > 47 && event.keyCode < 58) || event.keyCode == 44 || event.keyCode == 46);
}

function onPaste(event)
{
	var value = event.clipboardData.getData('Text');
	value = value.replace(/[^0-9.,]/g, ''); 
	event.returnValue = false;
	
	event.target.value = value;
}

function onTouchStart(event)
{
	document.getElementById('add').setAttribute('style', 'background-color: #008aaa;');
}

function onTouchEnd(event)
{
	document.getElementById('add').removeAttribute('style');
}

function add(id, currency)
{	
	var divCurrency = document.createElement('div');
	divCurrency.setAttribute('class', 'currency');
	divCurrency.id = "currency" + id;
	
	var divCurrencyDescription = document.createElement('div');
	divCurrencyDescription.setAttribute('class', 'currency_description');
	
	var divCurrencyTitle = document.createElement('div');
	divCurrencyTitle.setAttribute('class', 'currency_title');
	divCurrencyTitle.innerHTML = currency;
	
	var divCurrencySubtitle = document.createElement('div');
	divCurrencySubtitle.setAttribute('class', 'currency_subtitle');
	divCurrencySubtitle.innerHTML = currenciesJSON[currency].name;
	
	var divCurrencyInput = document.createElement('div');
	divCurrencyInput.setAttribute('class', 'currency_input');
	
	var input_value = document.createElement('input');
	input_value.type = 'text';
	input_value.id = 'value' + id;
	input_value.name = id;
	input_value.value = '1';
	input_value.setAttribute('maxlength', 12);
	input_value.addEventListener('keyup', onValueChange, false);
	input_value.addEventListener('paste', onPaste, false);
	input_value.addEventListener('keypress', onKeyPress, false);
	
	divCurrencyDescription.appendChild(divCurrencyTitle);
	divCurrencyDescription.appendChild(divCurrencySubtitle);
	divCurrencyInput.appendChild(input_value);
	divCurrency.appendChild(divCurrencyDescription);
	divCurrency.appendChild(divCurrencyInput);
	
	document.getElementById('currencies').appendChild(divCurrency);
}

function remove()
{	
	var currencies = getCurrencies();
	
	if(currencies.length <= 0)
		return;
		
	var id = currencies.length - 1;
		
	var container = document.getElementById('currencies');	
	container.removeChild(document.getElementById('currency' + id));

	currencies.splice(id, 1);
	localStorage.setItem('currencies', JSON.stringify(currencies));
	
	var last_id = localStorage.getItem('last_id');
	
	if(last_id = id)
	{
		var value = document.getElementById('value0').value;
	
		localStorage.setItem('last_id', 0);
		localStorage.setItem('last_value', value);
	}
	
	updateUI();
}

function updateUI()
{
	var currencies = getCurrencies();

	document.getElementById('add').disabled = currencies.length >= MAX_CURRENCIES;
	document.getElementById('currencySelector').disabled = currencies.length >= MAX_CURRENCIES;
	document.getElementById('remove').disabled = currencies.length <= 0;

	if(currencies.length == 0)
	{
		document.getElementById('currenciesEmpty').removeAttribute('style');
		document.getElementById('currencies').setAttribute('style','visibility:hidden; display:none;');
	}
	else
	{
		document.getElementById('currenciesEmpty').setAttribute('style','visibility:hidden; display:none;');
		document.getElementById('currencies').removeAttribute('style');
	}
}

function update(id)
{
	var value = document.getElementById('value' + id).value;
	value = value.replace(',', '.');
	
	if(isNaN(value))
		return;

	var currencies = getCurrencies();
		
	localStorage.setItem('last_id', id);
	localStorage.setItem('last_value', value);
	
	var from = currencies[id];

	for (i = 0; i < currencies.length; i++)
	{
		if(id == i)
			continue;
	
		var to = currencies[i];
		var current_element = document.getElementById('value' + i);

		if(from == to || value == '')
			current_element.value = value;	
		else
			convert(current_element, value, from, to);
	}
}

function convert(element, value, from, to)
{
	element.value = 'loading...'
	
	convertValue(
				value,
				from, 
				to,
				function(response)
				{
					if(response.status == 'error')
						element.value = 'timeout';
					else
						element.value = response.value;
				});
}

function refresh()
{
	document.getElementById('refresh').disabled = true;
	refreshRate(function(){
		document.getElementById('refresh').disabled = false;

		var lastUpdate = localStorage.getItem('lastUpdate');
	
		if(lastUpdate != null)
		{
			var date = new Date(lastUpdate);
			
			var month=new Array();
			month[0]="Jan";
			month[1]="Feb";
			month[2]="Mar";
			month[3]="Apr";
			month[4]="May";
			month[5]="Jun";
			month[6]="Jul";
			month[7]="Aug";
			month[8]="Sep";
			month[9]="Oct";
			month[10]="Nov";
			month[11]="Dec";
			
			var hours = date.getHours();
			var minutes = date.getMinutes();
			var ampm = hours >= 12 ? 'PM' : 'AM';
			hours = hours % 12;
			hours = hours ? hours : 12;
			minutes = minutes < 10 ? '0' + minutes : minutes;
			
			var display = '<i>Last update:</i>';
			display += '&nbsp;&nbsp;&nbsp;' + hours + ':' + minutes + ' ' + ampm;
			display += '&nbsp;&nbsp;' + date.getDate() + ' ' + month[date.getMonth()] + ' ' + date.getFullYear();
			
			document.getElementById('lastUpdate').innerHTML = display;
		}
		
	});
}

function getCurrencies()
{
	var currencies = JSON.parse(localStorage.getItem('currencies'));
	
	if(currencies == null)
		currencies = [];
		
	return currencies;
}

document.addEventListener('DOMContentLoaded', function () 
{
	//populate select
	var select_currency = document.getElementById('currencySelector');
	
	for (var currency in currenciesJSON)
	{
		var option = document.createElement('option');
		option.value = currency;
		option.text = currenciesJSON[currency].name;
		select_currency.appendChild(option);
	}
	
	select_currency.selectedIndex = -1;

	refresh();
	
	//init
	var currencies = getCurrencies();
	
	for (var i = 0; i < currencies.length; i++)
	{
		var currency = currencies[i];
		
		if(currency == undefined) 
			break;
		
		add(i, currency);
	}
			
	updateUI();
	
	var id = 0;
	var value = 1;
	
	var last_id = localStorage.getItem('last_id');
	var last_value = localStorage.getItem('last_value');
	
	if(last_id != null && last_value != null)
	{
		id = last_id;
		value = last_value;
	}
	
	var first_value = document.getElementById('value' + id);
	
	if(first_value != null)
	{
		first_value.value = value;
		first_value.select();
		first_value.focus();
		
		update(id);
	}

	document.getElementById('currencySelector').addEventListener('change', onCurrencyChange);
	document.getElementById('currencySelector').addEventListener('touchstart', onTouchStart);
	document.getElementById('currencySelector').addEventListener('touchend', onTouchEnd);
	document.getElementById('remove').addEventListener('click', remove);
	document.getElementById('refresh').addEventListener('click', refresh);
});