﻿function round(value, decimal)
{
    var rounded = value * Math.pow(10, decimal);
    rounded = Math.round(rounded);
    return rounded / Math.pow(10, decimal);
}

function refreshRate(callback)
{
	var cache = { 'USD' : '1', 'KYD' : '0.82000' };
	
	var timer = null;
	var milliseconds = new Date().getTime();
	var	xmlhttp = new XMLHttpRequest({mozSystem: true});
	xmlhttp.open('GET', 'http://finance.yahoo.com/webservice/v1/symbols/allcurrencies/quote?format=json&random=' + milliseconds, true);
	xmlhttp.onload = 
	function()
	{
		clearTimeout(timer);
		var t = JSON.parse(xmlhttp.responseText);
		
		for(var i = 0; i < t.list.resources.length; i++)
		{
			try
			{
				var resource = t.list.resources[i].resource;
				var key = resource.fields.symbol.replace("=X", "");
				cache[key] = resource.fields.price;			
			}
			catch(err){ continue; }
		}
		
		localStorage.setItem('lastUpdate', new Date());
		localStorage.setItem('cache', JSON.stringify(cache));
		
		callback();
	}

	xmlhttp.send(null);
	
	timer = setTimeout(function()
						{ 
							xmlhttp.abort(); 
							timeout = true;
							callback();		
						}, 10000);
}

function convertValue(value, from, to, callback)
{	
	var temp = localStorage.getItem('cache');	
	var cache = JSON.parse(temp);
	
	if(cache == null)
		return;

	var timer = setTimeout(function(){ callback({status: 'error'}); }, 10000);	
	convertValueRecursive(cache, timer, value, from, to, callback);
}

function convertValueRecursive(cache, timer, value, from, to, callback)
{	
	var fromRate = cache[from];
	var toRate = cache[to];
	
	if(fromRate == undefined || toRate == undefined)
	{
		setTimeout(function(){ convertValueRecursive(value, from, to, callback); }, 500);
		return;
	}
	
	clearTimeout(timer);
	var converted = round((value / fromRate) * toRate, 4);
	callback({status: 'success', value: converted});
}