		var currentScreen = "ScreenOverview";
		var lastScreen = "";
		var prefLang = null;


		if( /(android)/i.test(navigator.userAgent) ) { 
		    admobid = { // for Android
			banner: 'ca-app-pub-9384806652080929/6990735251',
			interstitial: 'ca-app-pub-9384806652080929/4233268454'
		    };
		} else if(/(ipod|iphone|ipad)/i.test(navigator.userAgent)) {
		    admobid = { // for iOS
			banner: 'ca-app-pub-9384806652080929/5788976057',
			interstitial: ''
		    };
		} else if (/(wp|windows)/i.test(navigator.userAgent)) {
		    admobid = { // for Windows Phone
			banner: 'ca-app-pub-9384806652080929/7265709253',
			interstitial: ''
		    };
		} else {
		    admobid = { // for the rest
			banner: 'ca-app-pub-9384806652080929/9425270055',
			interstitial: ''
		    };
		}

		function exitApp(){
			if(navigator.app){
				navigator.app.exitApp();
			} else if(navigator.device){
				navigator.device.exitApp();
			}
		}

		var isNavigationVisible = false;
		function toggleNavigation(){
			resizeTopBar();
			if ($("#Navigation").css("display") == "none"){
				$("#Navigation").slideDown(300);
				showLockedScreen();
				isNavigationVisible = true;
			} else {
				hideNavigation();
				isNavigationVisible = false;
			}
			
		}
		function hideNavigation(){
			if ($("#Navigation").css("display") != "none"){
				$("#Navigation").slideUp(300);
				hideLockedScreen();
				isNavigationVisible = false;
			}
		}

		function gotoEventByElementId(id){
			var eventId = $("#"+id).attr("rel");
			if (eventId && eventId != ""){
				return gotoEvent(eventId);
			}
			return false;
		}
		
		function gotoEvent(id){
			loaderStart();
			hideNavigation();
			clearScreenDetail();
			if (testmode){
				var result = TestData.getDetail();
				if (ServerResponse.withErrorMessage(result)){
					ServerResponse.handleErrorMessage(result);
				} else {
					updateDetailData(result);
					showScreen("Detail");
				}
				loaderStop();
			} else {
				$.post(strings.baseUrl+"rest/event-info/2.0/?id="+id,
						ServerRequest.createRequestHeader(), function(result){
					if (ServerResponse.withErrorMessage(result)){
						ServerResponse.handleErrorMessage(result);
					} else {
						updateDetailData(result);
						showScreen("Detail");
					}
				}, "json").fail(function() {
					Tools.showErrorMessage(strings.errorTitle, strings.errorLoadEventDetails);
				}).always(function() {;
					loaderStop();
				});
			}
		}
		function loadURL(id){
			var url = $("#"+id).attr("rel");
			if (isIos()) {
				window.open(url, '_system');
			} else if (navigator.app && navigator.app.loadUrl) {
		        	navigator.app.loadUrl(url, { openExternal: true });
		    	} else {
		        	window.open(url, "_system", "location=yes");
		    	}
			return false;
		} 
		function gotoOverview(id){
			loaderStart();
			var dateVal = $("#"+id).attr("dateVal");
			hideNavigation();
			showScreen("Overview");
			console.log(strings.baseUrl+"rest/event-overview/2.0/?date="+dateVal);
			$.post(strings.baseUrl+"rest/event-overview/2.0/?date="+dateVal, 
					ServerRequest.createRequestHeader(), function(result){
				if (ServerResponse.withErrorMessage(result)){
					ServerResponse.handleErrorMessage(result);
				} else {
					var data = (result.response || null);
					updateOverviewData(data);
				}
			}, "json").fail(function() {
				Tools.showErrorMessage(strings.errorTitle, strings.errorLoadDateEvents);
			}).always(function() {
				loaderStop();
			});
		}
		
		

		function showScreen(screenId){
			screenId = "Screen"+screenId;
			hideNavigation();
			$("#"+currentScreen).hide();
			$("#"+screenId).show();
			lastScreen = currentScreen;
			currentScreen = screenId;
			window.scrollTo(0,0);
		}


		
		function showLockedScreen(){
			$("#LockedScreen").fadeIn();
		}
		function hideLockedScreen(){
			$("#LockedScreen").fadeOut();
		}
		
		
		function loaderStart(){
			$("#Loader").fadeIn();
		}
		function loaderStop(){
			$("#Loader").fadeOut();
		}

		function fireBackButton(){
			if (isNavigationVisible){
				toggleNavigation();
			} else {
				
				if (currentScreen == "ScreenHolidaysDetail") {
					showScreen("Holidays");
					return false;
				} else if (currentScreen == "ScreenCategory" &&
						lastScreen == "ScreenDetail") {
					showScreen("Detail");
					return false;
				} else if (currentScreen != "ScreenOverview"){
					showScreen("Overview");
					return false;	
				} else {
					exitApp();
					return true;
				}
			}
		}
		function resizeTopBar(){
			var height = $("#TopNavigation").height();
			$("#Container").css("padding-top", height+"px");
		}

 	    
	    function overviewSwipeLeft(){
		gotoOverview("OverviewTomorrow");
	    }

	   
	    function overviewSwipeRight(){
		gotoOverview("OverviewYesterday");
	    }

	function registerAdEvents() {
		document.addEventListener('onReceiveAd', function(){});
		document.addEventListener('onFailedToReceiveAd', function(data){});
		document.addEventListener('onPresentAd', function(){});
		document.addEventListener('onDismissAd', function(){ });
		document.addEventListener('onLeaveToAd', function(){ });
		document.addEventListener('onReceiveInterstitialAd', function(){ });
		document.addEventListener('onPresentInterstitialAd', function(){ });
		document.addEventListener('onDismissInterstitialAd', function(){ });
	}

	function loadOverviewData(){
		/*if (navigator.connection != null && Connection != null && navigator.connection.type == Connection.NONE){
			Tools.showErrorMessage(strings.errorNoNetwork);		
		} else {
		if (!navigator.onLine){
			Tools.showErrorMessage(strings.errorTitle, strings.errorNoNetwork);
		} else {*/

			loaderStart();
			clearScreenOverview();
			
			var key = "overview-"+lang;
			if (RequestCache.exists(key, 600)){
				var data = RequestCache.get(key);
				updateOverviewData(data);
				loaderStop();
				if (AdMob && admobid.banner != "" && Settings.getSystemFlag("hideAds") == false && hideAds == false) {
					AdMob.createBanner({
						adId : admobid.banner,
						position : AdMob.AD_POSITION.BOTTOM_CENTER,
						autoShow : true,
						adSize   : 'SMART_BANNER',
						overlap  : false,
					});
				}
			} else if (testmode){
				
				var result = TestData.getOverview();

				if (result == null){
					Tools.showErrorMessage(strings.errorTitle, strings.errorCorruptedData);
				} else {
					if (ServerResponse.withErrorMessage(result)){
						ServerResponse.handleErrorMessage(result);
					} else {
						var data = (result.response || null);
						if (data != null){
							updateOverviewData(data);
							RequestCache.set(key, data);
						} else {
							clearScreenOverview();
							// TODO What is this for a situation?
						}
					}
					ServerResponse.checkAndShowNotifications(result);
					ServerResponse.checkSystemFlags(result);
				}
				loaderStop();
			} else {
				$.post(strings.baseUrl+"rest/event-overview/2.0/", 
						ServerRequest.createRequestHeader(), function(result){
					if (result == null){
						Tools.showErrorMessage(strings.errorTitle, strings.errorCorruptedData);
					} else {
						if (ServerResponse.withErrorMessage(result)){
							ServerResponse.handleErrorMessage(result);
						} else {
							var data = (result.response || null);
							updateOverviewData(data);
							RequestCache.set(key, data);
						}
						ServerResponse.checkAndShowNotifications(result);
						ServerResponse.checkSystemFlags(result);
					}
				}, "json").done(function() {
					//((console.log( "second success" );
				}).fail(function() {
					//console.log( "Error: Can't load overview data for current day." );
					Tools.showErrorMessage(strings.errorTitle, strings.errorLoadCurrentEvents);
					$("#EventReloader").fadeIn();
				}).always(function() {
					//console.log( "complete" );
					loaderStop();
					if (AdMob && admobid.banner != "" && Settings.getSystemFlag("hideAds") == false && hideAds == false) {
						AdMob.createBanner({
							adId : admobid.banner,
							position : AdMob.AD_POSITION.BOTTOM_CENTER,
							autoShow : true,
							adSize   : 'SMART_BANNER',
							overlap  : false,
						});
					}
				});
			}
		/*}*/
	}
	       
	    
	    
	    function clearScreenDetail(){
	    	$("#DetailTitle").empty();
	    	$("#DetailText").empty();
	    	$("#DetailImageContainer").hide();
	    	$("#DetailImage").attr("rel", "");
	    	$("#DetailMoreButton").hide();
	    }
	    
	    function updateDetailData(result){
		if (result != null && (result.response || null) != null){
		    	var data = result.response;
		    	$("#DetailTitle").empty().append(data.title);
		    	$("#DetailText").empty().append(data.text);
		    	if (data.moreLink != null && data.moreLink != ''){
		    		$("#DetailMoreButton").show();
		    		$("#DetailMoreButton").attr("rel", data.moreLink);
		    	} else {
		    		$("#DetailMoreButton").hide();
		    	}
			if ((data.category || null) != null){
				$("#DetailCategoryButton").show();
				$("#DetailCategoryButton").text(
					strings.category + ": " + data.category.title
				);
				$("#DetailCategoryButton").attr("rel", data.category.id);
			} else {
				$("#DetailCategoryButton").hide();
			}
		    	if (data.image.url != null && data.image.url != ''){
		    		$("#DetailImageContainer").show();
		    		$("#DetailImage").attr("src", data.image.url);
				if (data.image.caption != null){
					$("#DetailImageCaption").empty().append(data.image.caption);
				} else {
					$("#DetailImageCaption").empty();
				}
				if (data.image.copyright != null){
					$("#DetailImageCopyright").empty().append(data.image.copyright);
				} else {
					$("#DetailImageCopyright").empty();
				}
				if (data.subtitle != null){
					$("#DetailSubtitle").empty().append(data.subtitle);
					$("#DetailSubtitle").show();
				} else {
					$("#DetailSubtitle").empty();
					$("#DetailSubtitle").hide();
				}

				$("#DetailTextContainer").removeClass("medium-12 large-12");
				$("#DetailTextContainer").addClass("medium-6 large-6");
				$("#DetailTextContainer").addClass("padding-right-30");

				$("#DetailImageContainer").removeClass("medium-12 large-12");
				$("#DetailImageContainer").addClass("medium-6 large-6");

		    	} else {
				$("#DetailTextContainer").removeClass("medium-6 large-6");
				$("#DetailTextContainer").addClass("medium-12 large-12");
				$("#DetailTextContainer").removeClass("padding-right-30");

		    		$("#DetailImageContainer").hide();
				$("#DetailImageContainer").removeClass("medium-6 large-6");
				$("#DetailImageContainer").addClass("medium-12 large-12");

		    	}
	    	}
	    }

	    function getPrevDay(current){
	    	var day   = current.getDate();
	    	var month = current.getMonth();
	    	var year  = current.getFullYear();
	    	
	    	day -= 1;
	    	
	    	return new Date(year, month, day);
	    }

	    
	    function getNextDay(current){
	    	var day   = current.getDate();
	    	var month = current.getMonth();
	    	var year  = current.getFullYear();
	    	
	    	day += 1;
	    	
	    	return new Date(year, month, day);
	    }

	    function clearScreenOverview(){
		$("#EventReloader").hide();
	    	$("#OverviewYesterday").attr("dateVal","");	
	    	$("#OverviewTomorrow").attr("dateVal","");
	    	$("#OverviewEventListEntries").empty().append( "<li class='tapEvent'>("+strings.noEventsAvailable+")</li>" );
	    	$("#OverviewImageContainer").hide();
		$("#OverviewImage").attr("src", "images/placeholder.png");
		$("#OverviewImage").attr("rel", "");
	    	$("#OverviewDayname").empty();
	    	var d = new Date();
		var datestring = Tools.twoDigit(d.getDate()) + "." + Tools.twoDigit((d.getMonth()+1)) + "." + d.getFullYear();
		if (lang == "en"){
			datestring = Tools.twoDigit((d.getMonth()+1)) + "/"+ Tools.twoDigit(d.getDate()) + "/" + d.getFullYear();
		}
	    	$("#OverviewDate").empty().append(
	    		datestring
	    	);
		$("#OverviewDayInfo").hide();
		$("#OverviewDayInfoContent").html("");
	    }	    
	    
	    function updateOverviewData(response){
		if (response != null){
			clearScreenOverview();
		    	var image = (response.image || null);
		    	if (image && image.url){
				$("#OverviewImage").attr("src", "images/placeholder.png");
				$("#OverviewImageContainer").show();
		    		$("#OverviewImage").attr("src", image.url);
				$("#OverviewImage").attr("rel", "");
				if (image.eventDetailsAvailable && image.eventDetailsAvailable == "1" && image.eventId){
					$("#OverviewImage").attr("rel", image.eventId);
				}
		    	} else {
		    		$("#OverviewImageContainer").hide();
		    	}
		    	
		    	var date = (response.date || null);
			if (date){
				var datestring = Tools.twoDigit(date.day) + "." + Tools.twoDigit(date.month) + "." + date.year;
				if (lang == "en"){
					datestring = Tools.twoDigit(date.month) + "/" + Tools.twoDigit(date.day) + "/" + date.year;
				}
			    	$("#OverviewDate").empty().append(
			    		datestring
			    	);
			    	$("#OverviewDayname").empty().append(date.dayname+", ");

				if (date.prev != null && date.prev.daycode != null){
			    		$("#OverviewYesterday").attr("dateVal",date.prev.daycode);
			    		// $("#OverviewYesterday").show();
					$("#OverviewYesterdayNavArrow").attr("src", "images/right.png");
			    	} else {
					$("#OverviewYesterday").attr("dateVal", "");
					//$("#OverviewYesterday").hide();
					$("#OverviewYesterdayNavArrow").attr("src", "images/empty-arrow.png");
			    	}

				if (date.next != null && date.next.daycode != null){
			    		$("#OverviewTomorrow").attr("dateVal",date.next.daycode);
			    		$("#OverviewYesterdayNavArrow").attr("src", "images/left.png");
			    	} else {
					$("#OverviewTomorrow").attr("dateVal","");
					$("#OverviewYesterdayNavArrow").attr("src", "images/empty-arrow.png");
			    	}
		    	}

		    	var events = (response.events || null);
			if (events){
			    	$("#OverviewEventListEntries").empty();
			    	$.each(events, function(i, field) {
			    		if (field.detailsAvailable != null && field.detailsAvailable == "1"){
			    			$("#OverviewEventListEntries").append( 
							"<li class='tapEvent moreArrow' onclick='gotoEvent("+field.id+")'>"+field.title+"</li>" );
			    		} else {
			    			$("#OverviewEventListEntries").append( "<li class='tapEvent' onclick=\"Tools.showMessage(null, '"+strings.noDetailInfo+"')\">"+field.title+"</li>" );
			    		}
			    	});
			}
		    	
			var dayinfo = Overview.getDayInfoAsHtml(response);
			if (dayinfo != null){
				$("#OverviewDayInfo").show();
				$("#OverviewDayInfoContent").html( dayinfo );
			}

		} 	
	    }


function OverviewClass(){
	
	this.getDayInfoAsHtml = function(response){
		var data = null;
		if (response){
			data = "";		

			if (response.date && response.info){
				data += '<div class="overviewEntry">';
				data += '<b>'+strings.infoAboutDay+'</b><br>';
				data += Tools.numeration(response.date.week)+' '+strings.infoCalendarWeek+'<br>';
				data += Tools.numeration(response.date.daynumber)+' '+strings.infoDayOfTheYear+'<br>';
				data += response.countdown.nextYear.days+' '+strings.infoDaysLeft+'<br>';
				data += strings.infoZodiacSign+': '+response.info.zodiac.label;
				data += '</div>';
			}
			if (response.calendar && response.calendar.islamic){
				data += '<div class="overviewEntry">';
				data += '<b>'+strings.infoIslamicCalendar+'</b><br>';
				data += Tools.dateAsString(
						response.calendar.islamic.year,
						response.calendar.islamic.monthname,
						response.calendar.islamic.day)+'</div>';
			}

			if (response.calendar && response.calendar.jewish){
				data += '<div class="overviewEntry">';
				data += '<b>'+strings.infoJewishCalendar+'</b><br>';
				data += Tools.dateAsString(
						response.calendar.jewish.year,
						response.calendar.jewish.monthname,
						response.calendar.jewish.day)+'</div>';
			}
			if (response.info && response.info.sun){
				var sun = response.info.sun[0]; 
				data += '<div class="overviewEntry">';
				data += '<b>'+strings.infoSunPath+'</b><br>';
				data += strings.infoSunrise+': '+Tools.timeAsString(sun.sunrise.hour, sun.sunrise.minute)+'<br>';
				data += strings.infoSunset+': '+Tools.timeAsString(sun.sunset.hour, sun.sunset.minute)+'<br>';
				data += strings.infoSunForPlace+' '+sun.place+' ('+sun.countrycode+')';
				data += '</div>';
			}
		}
		return data;
	}

}
var Overview = new OverviewClass;



function CategoryClass() {

	this.gotoByElementId = function(id){
		var objectId = $("#"+id).attr("rel");
		if (objectId && objectId != ""){
			return this.goto(objectId);
		}
		return false;
	}

	this.goto = function(id){
		loaderStart();
		hideNavigation();
		this.clearView();
		if (testmode){
			var result = TestData.getCategory();
			if (ServerResponse.withErrorMessage(result)){
				ServerResponse.handleErrorMessage(result);
			} else {
				this.updateView(result);
				showScreen("Category");
			}
			loaderStop();
		} else {
			$.post(strings.baseUrl+"rest/category-detail/1.0/?id="+id,
					ServerRequest.createRequestHeader(), function(result){
				if (ServerResponse.withErrorMessage(result)){
					ServerResponse.handleErrorMessage(result);
				} else {
					Category.updateView(result);
					showScreen("Category");
				}
			}, "json").fail(function() {
				Tools.showErrorMessage(strings.errorTitle, strings.errorLoadEventDetails);
			}).always(function() {;
				loaderStop();
			});
		}
	}

	this.clearView = function(){
		$("#CategoryTitle").text("");	
		$("#CategoryEventListEntries").empty().append( "<li class='tapEvent'>("+strings.noEventsAvailable+")</li>" );
		$("#CategoryImageContainer").hide();
		$("#CategoryImage").attr("src", "images/placeholder.png");
		$("#CategoryImage").attr("rel", "");
		$("#CategoryMoreButton").attr("rel","");
	}

	this.updateView = function(result){
		if (result != null && (result.response || null) != null){
		    	var data = result.response;
			$("#CategoryTitle").text(strings.category + ": "+ data.title);
			var events = (data.events || null);
			if (events){
			    	$("#CategoryEventListEntries").empty();
			    	$.each(events, function(i, field) {
					try {
					var date = field.date;
					var datestring = Tools.twoDigit(date.day) + "." + 
						Tools.twoDigit(date.month) + "." + 
						(""+date.year).substr(2,2);
					if (lang == "en"){
						datestring = Tools.twoDigit(date.month) + "/" + 
							Tools.twoDigit(date.day) + "/" + 
							(""+date.year).substr(2,2);
					}
					datestring = " &ndash; "+datestring+"";
			    		if (field.detailsAvailable != null && field.detailsAvailable == "1"){
			    			$("#CategoryEventListEntries").append( "<li class='tapEvent moreArrow' onclick='gotoEvent("+field.id+")'>"+field.title+datestring+"</li>" );
			    		} else {
			    			$("#CategoryEventListEntries").append( "<li class='tapEvent' onclick=\"Tools.showMessage(null, '"+strings.noDetailInfo+"')\">"+field.title+datestring+"</li>" );
			    		}
				       } catch (err){
					alertErr(err);
				       }
			    	});
			}
			if (data.moreLink != null && data.moreLink != ''){
		    		$("#CategoryMoreButton").show();
		    		$("#CategoryMoreButton").attr("rel", data.moreLink);
		    	} else {
		    		$("#CategoryMoreButton").hide();
		    	}
		}
	}

}
var Category = new CategoryClass;


function HolidayDetailClass(){
	
	this.gotoByElementId = function(id){
		var objectId = $("#"+id).attr("rel");
		if (objectId && objectId != ""){
			return this.goto(objectId);
		}
		return false;
	}

	this.gotoByElementRef = function(ref){
		var objectId = ref.getAttribute("rel");
		if (objectId && objectId != ""){
			return this.goto(objectId);
		}
		return false;
	}

	this.goto = function(id){
		loaderStart();
		hideNavigation();
		this.clearView();
		if (testmode){
			var result = TestData.getHolidayDetail();
			if (ServerResponse.withErrorMessage(result)){
				ServerResponse.handleErrorMessage(result);
			} else {
				this.updateView(result);
				showScreen("HolidaysDetail");
			}
			loaderStop();
		} else {
			$.post(strings.baseUrl+"rest/holidays-detail/1.0/?id="+id, 
					ServerRequest.createRequestHeader(), function(result){
				if (ServerResponse.withErrorMessage(result)){
					ServerResponse.handleErrorMessage(result);
				} else {
					Category.updateView(result);
					showScreen("HolidaysDetail");
				}
			}, "json").fail(function() {
				Tools.showErrorMessage(strings.errorTitle, strings.errorLoadEventDetails);
			}).always(function() {;
				loaderStop();
			});
		}	
	}

	this.clearView = function(){
		$("#HolidaysDetailTitle").text("");	
		$("#HolidaysDetailSubtitleFederalHolidays").text("");
		$("#HolidaysDetailFederalHolidaysEventListEntries").empty().append( "<li class='tapEvent'>("+strings.noEventsAvailable+")</li>" );
		$("#HolidaysDetailSubtitleSchoolHolidays").text("");		
		$("#HolidaysDetailSchoolHolidaysEventListEntries").empty().append( "<li class='tapEvent'>("+strings.noEventsAvailable+")</li>" );
	}

	this.updateView = function(result){
		if (result != null && (result.response || null) != null){
			var data = result.response;
			var year = "";
			if (data.context && data.context.currentYear){
				year = data.context.currentYear;
			}
			$("#HolidaysDetailTitle").text(data.state+" "+year);
			if (data.federalHolidays){
				$("#HolidaysDetailSubtitleFederalHolidays").show();
				$("#HolidaysDetailSubtitleFederalHolidays").text(strings.federalHolidays);
				$("#HolidaysDetailFederalHolidaysEventList").show();
				var events = (data.federalHolidays || null);
				if (events){
				    	$("#HolidaysDetailFederalHolidaysEventListEntries").empty();
				    	$.each(events, function(i, field) {
						var date = field.date;
						var datestring = (date.day) + ". " + date.monthname;
						if (lang == "en"){
							datestring = date.monthname + " " + date.day;
						}
						$("#HolidaysDetailFederalHolidaysEventListEntries").
							append( "<li  class='overviewEntry font-size-touchlink tiny-font-size-touchlink' style='line-height:1.2;border-color:#8fadd5'><span style='font-size:15px'>"+datestring+"<br /></span>"+field.title+"</li>" );
				    	});
				}
			} else {
				$("#HolidaysDetailSubtitleFederalHolidays").hide();
				$("#HolidaysDetailFederalHolidaysEventList").hide();
			}
			if (data.schoolHolidays){
				try {
					$("#HolidaysDetailSubtitleSchoolHolidays").show();
					$("#HolidaysDetailSubtitleSchoolHolidays").text(strings.schoolHolidays);
					$("#HolidaysDetailSchoolHolidaysEventList").show();
					var events = (data.schoolHolidays || null);
					if (events){
					    	$("#HolidaysDetailSchoolHolidaysEventListEntries").empty();
					    	$.each(events, function(i, field) {
							try {
								var startDate = field.startDate;
								var endDate = field.endDate;
								var datestring = (startDate.day) + ". " + startDate.monthname;
								datestring += " &ndash; "+endDate.day+". "+endDate.monthname;
								if (startDate.year < endDate.year){
									datestring += " "+endDate.year;
								}
								if (lang == "en"){
									datestring  = startDate.monthname + " " + startDate.day + " &ndash; ";
									datestring += endDate.monthname + " "+endDate.day;
									if (startDate.year < endDate.year){
										datestring += ", "+endDate.year;
									}
								}
								$("#HolidaysDetailSchoolHolidaysEventListEntries").
									append( "<li  class='overviewEntry font-size-touchlink tiny-font-size-touchlink' style='line-height:1.2;border-color:#8fadd5'><span style='font-size:15px'>"+datestring+"<br /></span>"+field.title+"</li>" );
							} catch (err){ alertErr(err); }					    	
						});
					}
				} catch (err){ alertErr(err); }
			} else {
				$("#HolidaysDetailSubtitleSchoolHolidays").hide();
				$("#HolidaysDetailFederalSchoolEventList").hide();
			}
		}
	}

}
var HolidayDetail = new HolidayDetailClass;



/* CACHE */
/* ------------------------------------------------------------------*/

function RequestCacheClass() {

	this.createEntryKey = function(key){
		return "centry-"+encodeURIComponent(key);
	}
	this.createDateKey = function(key){
		return "cdate-"+encodeURIComponent(key);
	}
	this.createIdKey = function(key){
		return encodeURIComponent(key);
	}
	this.exists = function(id, lifetime){
		var entryKey = this.createEntryKey(id);
		var dateKey = this.createDateKey(id);

		var d = new Date();
		var ts = Math.round(d.getTime() / 1000);
		var cdate = localStorage.getItem(dateKey);

		if (cdate > 0 && Math.abs(ts - cdate) < lifetime){
			if (localStorage.getItem(entryKey)){
				return true;
			}
		}
		return false;
	}

	this.set = function(id, value){
		var entryKey = this.createEntryKey(id);
		var dateKey = this.createDateKey(id);
		var idKey = this.createIdKey(id);
		
		var entryValue = JSON.stringify(value);
		var d = new Date();
		var dateValue = Math.round(d.getTime() / 1000);

		localStorage.setItem(entryKey, entryValue);
		localStorage.setItem(dateKey, dateValue);

		var createNewListEntry = true;
		var clistRaw = localStorage.getItem("clist");
		if (clistRaw){
			var clist = JSON.parse(clistRaw);
			if (!clist){
				clist = {};
			} else {
				for (key in clist){
					if (key == idKey){
						createNewListEntry = false;
						break;
					}
				}
			}
		} else {
			var clist = {};
		}
		if (createNewListEntry){
			clist[idKey] = 1;
			localStorage.setItem("clist", JSON.stringify(clist));
		}
	}

	this.get = function(key){
		key = this.createEntryKey(key);
		var cachedData = localStorage.getItem(key);
		if (cachedData){
			var data = JSON.parse(cachedData);
			return data;
		}
		return null;
	}

	this.optimize = function(){
		var clistRaw = localStorage.getItem("clist");
		if (clistRaw){
			var clist = JSON.parse(clistRaw);
			if (!clist){
				createNewListEntry = true;
				clist = {};
			} else {
				var id = null;
				var cacheTs = null;
				var d = new Date();
				var ts = Math.round(d.getTime() / 1000);
				var newClist = {};
				for (key in clist){
					id = key;
					cacheTs = localStorage.getItem("cdate-"+id);
					// Max lifetime are 10 days
					if (Math.abs(ts - cacheTs) > 864000){
						localStorage.removeItem("centry-"+id);
						localStorage.removeItem("cdate-"+id);
					} else {
						newClist[key] = 1;
					}
				}
				localStorage.setItem("clist", JSON.stringify(newClist));
			}
		}
	}
}
var RequestCache = new RequestCacheClass;


/* SERVER REQUEST */
/* ------------------------------------------------------------------*/

function ServerRequestClass() {

	this.createRequestHeader = function(){
		if (window.device != null){
			var uuidRaw  = 	window.device.uuid;
			var hash1 = CryptoJS.MD5(uuidRaw + "sugar");
			var hash2 = CryptoJS.MD5(uuidRaw + "pepper");
			if (hash2){
				hash2 = (hash2+"").substr(0,4);
			}
			var uuidHash = hash1 + hash2 + "";
			var pwdPre = "";
			var pwdPost = "";
			if (uuidHash && uuidHash.length > 5){
				pwdPre = uuidHash.slice(-4);
				pwdPost = uuidHash.substr(0,4);
			}

			startCount = (Counter.getStartCount() || 0 );

			var payload = {
				authentication: {
					user: "Guest001",
					password: (pwdPre + "3qRsgfhyZx" + pwdPost),
				},
				device: {
					uuid: uuidHash,
					platform: window.device.platform,
					version: window.device.version,
					model: window.device.model,
				},
				app: {
					version: appInfo.version,
					id: appInfo.id,
					starts: startCount,
				},
				screen: {
					width: window.screen.width,
					height: window.screen.height,
					availWidth: window.screen.availWidth,
					availHeight: window.screen.availHeight,
					colorDepth: window.screen.colorDepth,
					pixelDepth: screen.pixelDepth,
					orientation: window.orientation,
				},
				language: {
					current: lang,
					prefered: prefLang,
				},
			};
			var requestMsgRaw = JSON.stringify(payload);
			return {
				request: requestMsgRaw
			};
		}
		return { };
	}
}
var ServerRequest = new ServerRequestClass;


/* SERVER RESPONSE */
/* ------------------------------------------------------------------*/

function ServerResponseClass() {

	this.handleErrorMessage = function(result){
		if (result != null && (result.header || null) != null){
			var error = (result.header.error || null);
			if (error != null && error.title && error.text){
				Tools.showErrorMessage(error.title, error.text);
			}
		}
	}

	this.withErrorMessage = function(result){
		if (result != null && (result.header || null) != null){
			var error = (result.header.error || null);
			if (error != null && error.title){
				return true;
			}
		}
		return false;
	}

	this.checkSystemFlags = function(response){
		var flags = null;
		if (response != null && (response.header || null) != null){
			flags = (response.header.flags || null); 
		}
		if (flags != null){
			if (flags.hideAds){
				Settings.setSystemFlag("hideAds", flags.hideAds);
			}
		}
	}

	this.checkAndShowNotifications = function(response){
		var notification = null;
		if (response != null && (response.header || null) != null){
			notification = (response.header.notification || null);
		}
		if (notification != null){
			var id = (notification.id || null);
			var text = (notification.text || null);
			var title = (notification.title || null);
			if (id != null && text != null){
		  		var key = "msg"+id;
				if (localStorage.getItem(key) == null || localStorage.getItem(key) === undefined){
					localStorage.setItem(key, 1);
					localStorage.setItem("lastNotification", id);
					Tools.showMessage(title, text);
				}
			}
		}
	}
}
var ServerResponse = new ServerResponseClass;

/* DATE PICKER */
/* ------------------------------------------------------------------*/

function DatePickerClass() {

	this.show = function(){
		$("#LockedScreen").show();
		$("#DatePicker").show();
	}

	this.hide = function(){
		$("#LockedScreen").hide();
		$("#DatePicker").hide();
	}

}
var DatePicker = new DatePickerClass;


/* SETTINGS */
/* ------------------------------------------------------------------*/

function SettingsClass() {

	this.getSystemFlag = function(key){
		var value = localStorage.getItem(key);
		if (value && value == 1){
			return true;
		}
		return false;
	}

	this.setSystemFlag = function(key, value){
		if (value == "1"){
			localStorage.setItem(key, 1);
		} else if (value == "2"){
			localStorage.setItem(key, null);
			localStorage.removeItem(key);
		}
	}

}
var Settings = new SettingsClass;


/* TOOLS */
/* ------------------------------------------------------------------*/

function ToolsClass() {

	this.showErrorMessage = function(title, message){
		if (!title){
			title = strings.errorTitle;
		}
		this.showMessage(title, message);
	}

	this.showMessage = function(title, text){
		if (!title){
			title = strings.noticeTitle;
		}
		if (navigator.notification){
			navigator.notification.alert(
				text,      // message
				null,      // callback
				title,     // title
				"OK"       // buttonName
			);
		} else {
			if (title != null && title != ""){
				text = title+"\n"+text;
			}
			alert(text);
		}
	}

	this.twoDigit = function(num){
		if (num >= 0 && num < 10){
			if ((""+num).length != 2){
				return "0"+num;
			}
		}
		return num;
	}

	this.numeration = function(num){
		var value = num+".";
		if (lang == "en"){
			value = num+"th ";
			if (num % 10 == 1){
				value = num+"st";
			}
			if (num % 10 == 2){
				value = num+"nd";
			}
			if (num % 10 == 3){
				value = num+"rd";
			}
		}
		return value;
	}

	this.timeAsString = function(hour, minute){
		var value = Tools.twoDigit(hour)+":"+Tools.twoDigit(minute)+" "+strings.wordOClock;
		if (lang == "en"){
			value = Tools.twoDigit(hour)+":"+Tools.twoDigit(minute);
		}
		return value;
	}

	this.dateAsString = function(year, monthname, day){
		var value = Tools.numeration(day)+" "+monthname+" "+year;
		if (lang == "en"){
			value = monthname+" "+day+", "+year;
		}
		return value;
	}
}
var Tools = new ToolsClass;




