var mode;
var MODE_NORMAL = '1';
var MODE_HIGH = '2';
var MODE_LOW = '3';
var sounds;

function init() {
    mode = MODE_NORMAL;
    document.getElementById('option-normal').setAttribute('class', 'on');
    var keys = document.getElementsByTagName('td');
    for (var i = 0; i < keys.length; i++) {
        keys[i].addEventListener('touchstart', touchstart, false);
        keys[i].addEventListener('touchend', touchend, false);
    }
    sounds = {
        beat: document.getElementById('beat'),
        WorkIt1: document.getElementById('WorkIt1'),
        MakeIt1: document.getElementById('MakeIt1'),
        DoIt1: document.getElementById('DoIt1'),
        MakesUs1: document.getElementById('MakesUs1'),
        Harder1: document.getElementById('Harder1'),
        Better1: document.getElementById('Better1'),
        Faster1: document.getElementById('Faster1'),
        Stronger1: document.getElementById('Stronger1'),
        MoreThan1: document.getElementById('MoreThan1'),
        Hour1: document.getElementById('Hour1'),
        Our1: document.getElementById('Our1'),
        Never1: document.getElementById('Never1'),
        Ever1: document.getElementById('Ever1'),
        After1: document.getElementById('After1'),
        WorkIs1: document.getElementById('WorkIs1'),
        Over1: document.getElementById('Over1'),
        WorkIt2: document.getElementById('WorkIt2'),
        MakeIt2: document.getElementById('MakeIt2'),
        DoIt2: document.getElementById('DoIt2'),
        MakesUs2: document.getElementById('MakesUs2'),
        Harder2: document.getElementById('Harder2'),
        Better2: document.getElementById('Better2'),
        Faster2: document.getElementById('Faster2'),
        Stronger2: document.getElementById('Stronger2'),
        MoreThan2: document.getElementById('MoreThan2'),
        Hour2: document.getElementById('Hour2'),
        Our2: document.getElementById('Our2'),
        Never2: document.getElementById('Never2'),
        Ever2: document.getElementById('Ever2'),
        After2: document.getElementById('After2'),
        WorkIs2: document.getElementById('WorkIs2'),
        Over2: document.getElementById('Over2'),
        MoreThan3: document.getElementById('MoreThan3'),
        Hour3: document.getElementById('Hour3'),
        Our3: document.getElementById('Our3'),
        Never3: document.getElementById('Never3'),
        Ever3: document.getElementById('Ever3'),
        After3: document.getElementById('After3'),
        WorkIs3: document.getElementById('WorkIs3'),
        Over3: document.getElementById('Over3'),
    }
    sounds['beat'].addEventListener('ended', beatEnded, false);
}

function touchstart(event) {
    var items, i;
    if (event.target.id.split('-')[0] == 'option') {//options
        switch(event.target.id) {
            case 'option-play':
                if (event.target.getAttribute('class') == '') {
                    sounds['beat'].play();
                    event.target.setAttribute('class', 'on');
                }
                break;
            case 'option-normal':
                if (mode != MODE_NORMAL) {
                    mode = MODE_NORMAL;
                    document.getElementById('option-normal').setAttribute('class', 'on');
                    document.getElementById('option-high').setAttribute('class', '');
                    document.getElementById('option-low').setAttribute('class', '');
                    items = document.querySelectorAll('tr.keyboard > td:not([data-haslow])');
                    for (i = 0; i < items.length; ++i) {
                        items[i].setAttribute('class', '');
                    }
                }
                break;
            case 'option-high':
                if (mode != MODE_HIGH) {
                    mode = MODE_HIGH;
                    document.getElementById('option-normal').setAttribute('class', '');
                    document.getElementById('option-high').setAttribute('class', 'on');
                    document.getElementById('option-low').setAttribute('class', '');
                    items = document.querySelectorAll('tr.keyboard > td:not([data-haslow])');
                    for (i = 0; i < items.length; ++i) {
                        items[i].setAttribute('class', '');
                    }
                }
                break;
            case 'option-low':
                if (mode != MODE_LOW) {
                    mode = MODE_LOW;
                    document.getElementById('option-normal').setAttribute('class', '');
                    document.getElementById('option-high').setAttribute('class', '');
                    document.getElementById('option-low').setAttribute('class', 'on');
                    items = document.querySelectorAll('tr.keyboard > td:not([data-haslow])');
                    for (i = 0; i < items.length; ++i) {
                        items[i].setAttribute('class', 'disabled');
                    }
                }
                break;
        }
    } else {//keyboard
        if (mode != MODE_LOW || event.target.hasAttribute('data-haslow')) {
            event.target.setAttribute('class', 'on');
            sounds[event.target.id + mode].play();
        }
    }
}

function touchend(event) {
    if (event.target.id.split('-')[0] != 'option' && event.target.getAttribute('class') != 'disabled') {//keyboard
        event.target.setAttribute('class', '');
    }
}

function beatEnded() {
    document.getElementById('option-play').setAttribute('class', '');
}