function LoginCtrl($scope, $http, $location) {

  $scope.username = "";
  $scope.password = "";

  $scope.registerEmail = "";
  $scope.registerPassword = "";
  $scope.registerRepeatPassword = "";
  $scope.registerUsername = "";

  $scope.errorsArr = new Array();

  
  $scope.goLogin = function(){
    
  	if ( navigator.onLine ){
      //aquí tengo un objeto
      var hash = CryptoJS.SHA512( $scope.password ) ;
      //con toString se aplana
      var pass = hash.toString(CryptoJS.enc.Hex);

      $.ajax({
          type: 'POST',
          url: 'http://dailes.w.pw/dailies_login',
          timeout: 10000,
          data: {username : $scope.username, password :  pass },
          dataType: 'json',
          beforeSend: function(){
            setLoader('#wrapper');
          },
          success: function(resp) {
            if(resp != '2' && resp != '3' && resp != '4' && (parseInt(resp.validateEmail) > 0 || resp.validateEmail == 'validated') ){
              if( resp.validateEmail != 'validated' ){
                //programar alarma
                var days = resp.validateEmail;
                alarmValidateEmail(days);
              }
              localStorage.userLogin = 1;
              localStorage.userToken = resp['token'];
              localStorage.allDailies = JSON.stringify( resp['allDailies'] );
              localStorage.activeDailies = JSON.stringify( resp['activesDailies'] );
              localStorage.points = JSON.stringify( new Object() );
              localStorage.btnAnswerStatus = 0;
              localStorage.btnDailyStatus = 0;
              localStorage.counterReviewAlarm = 0;
              randomMomentTomorrow();
              window.location.href = '#/home';
            }else{
              localStorage.userLogin = 0;
              if(resp == '2'){
                openPopUp2('Error', 'The user or email is incorrect. Review it.');
              }
              else if( resp == '3' ){
                openPopUp2('Error', 'Password error');
              }
              else if( resp == '4' || resp.validateEmail == '0' ){
                openPopUp2('Error', 'Your email isn\'t validate. We have sent you an email to validate it.');
              }
            }
          },
          error: function(resp) { openPopUp2('Error', 'Error on server. Try again later.'); },
          complete: function(){stopLoader();}
        });
      }
      else{
        openPopUp2('Error', 'You don\'t have internet conexion. Turn it on to login.');
      }

  }	


  $scope.countUsername = 0;
  $scope.validateUsername = function(){

  	if($scope.countUsername >= 3)validationUsername( $scope.username, $('#userLogin') );
  	$scope.countUsername++;
  }


  $scope.validateRegister = function(){
    var errors = new Array();

    if( !validationUsername( $scope.registerUsername, $('#usernameRegister') ) ) 
        errors.push( validationUsername( $scope.registerUsername, $('#usernameRegister') ) );
  	if( !validationEmail( $scope.registerEmail, $('#emailRegister') ) ) 
        errors.push( validationEmail( $scope.registerEmail, $('#emailRegister') ) );
  	if( !validationPassword( $scope.registerPassword, $('#passwordRegister') ) ) 
        errors.push( validationPassword( $scope.registerPassword, $('#passwordRegister') ) );
  	if( !validationRepeatPassword( $scope.registerPassword, $scope.registerRepeatPassword, $('#passwordRepeatRegister') ) ) 
        errors.push( validationRepeatPassword( $scope.registerPassword, $scope.registerRepeatPassword, $('#passwordRepeatRegister') ) );
    
    if( errors.length <= 0 ){
      $('#usernameRegister').removeClass('errorInput');
      $('#emailRegister').removeClass('errorInput');
      $scope.goRegister();
    }
  
  }

  $scope.goRegister = function(){
    
    if ( navigator.onLine ){
    	//aquí tengo un objeto
    	var hash = CryptoJS.SHA512( $scope.registerPassword ) ;
    	//con toString se aplana
    	var pass = hash.toString(CryptoJS.enc.Hex);

    	$.ajax({
          type: 'POST',
          url: 'http://dailes.w.pw/dailies_register',
          timeout: 10000,
          data: { username : $scope.registerUsername, password :  pass, email : $scope.registerEmail },
          dataType: 'json',
          beforeSend: function(){
            setLoader('#wrapper');
          },
          success: function(resp) {
            $scope.errorsArr = new Array();
            var error = false;
            //exist error
          	if(resp.username == 1){
              $scope.errorsArr.push( 'Username already exist' );
              $('#usernameRegister').addClass('errorInput');
              error = true;
            }
            if(resp.email == 1){
              $scope.errorsArr.push( 'Email already exist' );
              $('#emailRegister').addClass('errorInput');
              error = true;
            }
             
            if(error){ 
              $scope.$apply();
              openPopUp2('Error', 'There are some errors. The email or user already exist.');
            }
            else {
              //programar alarma validar Email 7días
              alarmValidateEmail( 7 );
              localStorage.userLogin = 1;
              localStorage.userToken = resp['token'];
              localStorage.allDailies = JSON.stringify( resp['allDailies'] );
              localStorage.activeDailies = JSON.stringify( new Array() );
              localStorage.points = JSON.stringify( new Object() );
              localStorage.btnAnswerStatus = 0;
              localStorage.btnDailyStatus = 0;
              localStorage.counterReviewAlarm = 0;
              window.location.href = '#/tutorial';
               
            }
          },
          error: function(resp) { openPopUp2('Error', 'Error on server. Try again later.');},
          complete: function(){stopLoader();}
        });
    }
    else{
      openPopUp2('Error', 'You don\'t have internet conexion. Turn it on to register.');
    }
  }	

   $scope.openPopUp = function(title, text){
    openPopUp2(title, text);
   }

   $scope.time = moment().format('h:mm');
   $scope.seconds = moment().format('ss');

    setInterval(
      function(){
        $scope.time = moment().format('h:mm');
        $scope.seconds = moment().format('ss');
        $scope.$apply();
      }, 1000
    );


  $scope.openAreaRegister = function() {
    openRegisterLogin();
  }
}

 