
var TITLE = "Daily Bread";
var RSS = "http://manna.christianchannel.us/feed/";
var entries = [];
var selectedEntry = "";
$('#splash').on('pageshow', function(){
       var hideSplash = function() {
           $.mobile.changePage($("#home"));
       };
      setTimeout(hideSplash, 2000);
  });
//listen for detail links
$(".contentLink").live("click", function() {
	selectedEntry = $(this).data("entryid");
});

function renderEntries(entries) {
    var s = '';
    $.each(entries, function(i, v) {
        s += '<li><a href="#contentPage" class="contentLink" data-entryid="'+i+'" style="font-size: 12px;"><img src="img/manna.png" style="margin-top: 5px;">' + v.title + '</a></li>';
        
    });
    $("#linksList").html(s);
    $("#linksList").listview("refresh");
}

function initialize() {
	console.log('ready to use google');
	var feed = new google.feeds.Feed(RSS);
	feed.setNumEntries(20);
	$.mobile.showPageLoadingMsg();
	feed.load(function(result) {
		$.mobile.hidePageLoadingMsg();
		if(!result.error) {
			entries = result.feed.entries;
			localStorage["entries"] = JSON.stringify(entries);
			renderEntries(entries);
		} else {
			console.log("Error - "+result.error.message);
			if(localStorage["entries"]) {
				$("#status").html("Using cached version...");
				entries = JSON.parse(localStorage["entries"]);
				renderEntries(entries);
			} else {
				$("#status").html("Sorry, we are unable to get the RSS and there is no cache.");
			}
		}
	});
}

$("#mainPage").live("pageinit", function() {

	$("h1", this).text(TITLE);
	
	google.load("feeds", "1",{callback:initialize});
});

$("#mainPage").live("pagebeforeshow", function(event,data) {
	if(data.prevPage.length) {
		$("h1", data.prevPage).text("");
		$("#entryText", data.prevPage).html("");
	};
});

//Listen for the content page to load
$("#contentPage").live("pageshow", function(prepage) {
	//Set the title
	$("h1", this).text(entries[selectedEntry].title);
	var contentHTML = "";
	contentHTML += entries[selectedEntry].content;
	$("#entryText",this).html(contentHTML);
	$("#entryText .fullLink",this).button();

});
	
$(window).on("touchstart", ".fullLink", function(e) {
	window.plugins.childBrowser.showWebPage($(this).attr("href"));
});

