// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function() {
  // We'll ask the browser to use strict code to help us catch errors earlier.
  // https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
  'use strict';

  var iframe, device;

  device = new MobileDetect(window.navigator.userAgent);
  if (!device.mobile()) {
    window.location.href = 'http://www.dailymotion.com';
  }
  else {
    iframe = document.createElement('iframe');
    iframe.src = 'http://www.dailymotion.com';
    iframe.setAttribute('remote', '');
    // @see The 'browser' permission
    // https://developer.mozilla.org/en-US/docs/Web/API/Using_the_Browser_API
    iframe.setAttribute('mozbrowser', '');

    document.getElementById('dmwebapp').appendChild(iframe);
  }

});
