
var server = {};
var data = {};


function Request(function_name, opt_argv) {
    if (!opt_argv)
        opt_argv = new Array();
    
    var callback = null;
    var len = opt_argv.length;
    if (len > 0 && typeof opt_argv[len-1] == 'function') {
        callback = opt_argv[len-1];
        opt_argv.length--;
    }
    var async = (callback != null);

    var query = 'action=' + encodeURIComponent(function_name);
    for (var i = 0; i < opt_argv.length; i++) {
        var key = 'arg' + i;
        var val = JSON.stringify(opt_argv[i]);
        query += '&' + key + '=' + encodeURIComponent(val);
    }
    query += '&time=' + new Date().getTime();
    
    var req = new XMLHttpRequest({mozSystem:true});
    req.open('GET', 'http://congifr.appspot.com/verb?' + query, async);
    //console.log("sending request");
    if (async) {
        //console.log("getting response");
        req.onreadystatechange = function() {
        if(req.readyState == 4 && req.status == 200) {
            //console.log("getting results");
            var response = null;
            try {
                response = JSON.parse(req.responseText);
            } catch (e) {
                response = req.responseText;
            }
            callback(response);
        }
        }
    }

    req.send();
}

function InstallFunction(obj, functionName) {
    obj[functionName] = function() { Request(functionName, arguments); }
}

InstallFunction(server, 'Search');


function onSuccess(response) {
    switch(response['action']){
        case 'search':
            if(response['state']==1){
                addContent(response['data']);
                $('#messagebox').hide();
                $('#resultbox').show();
                
                }
            if(response['state']==0){
                $('#messagebox').show();
                $('#resultbox').hide();
                $('#messagebox').html('<p>'+response['data']+'</p>');
                }
    }
}
$(document).ready(function()
                  {
                   console.log("click event handler init");
                  $('#searchVerbbtn').click( function()
                                            {
                                            $('#messagebox').hide();
                                            $('#resultbox').hide();
                                            $('#messagebox').html('');
                                            var verb = $('#query').val();
                                            //console.log("search verb clicked");
                                            server.Search(verb, onSuccess);
                                            }
                                            );
                  });
/*
function searchVerb(){
    $('#messagebox').hide();
    $('#resultbox').hide();
    $('#messagebox').html('');
    var verb = $('#query').val();
    console.log("search verb clicked");
    server.Search(verb, onSuccess);
}
*/

function addContent(data){
    var idindex=new Array("present", "presentPerfect","simplePast","pastPerfect","imperfect","pluperfect","future","pastFuture","subPresent","subPast","subImperfect","subPluperfect","conPresent","con1Past","con2Past","impPresent","impPast","infPresent","infPast","partPresent","partPast");
    for( var i=0; i < idindex.length; i++){
        $("#"+idindex[i]).html('<p>'+data[idindex[i]]+'</p>');
    }
}
