

$('#form-search').submit(function(event){
    $('#loading').fadeIn('fast');
    event.stopPropagation();
	var busca = $('#q').val();
    $.ajax({
        type: "GET",
        url: domain,
        crossDomain: true,
        data: { busca: busca},
        dataType: 'jsonp',
        jsonpCallback: 'results',
        jsonp: 'callback'    
    }).done(function( msg ) {
        $('#loading').fadeOut('fast');
    });
    return false;
});



function results(data){
    //console.log(data.artistas);
    $('#content').html('<ul class="list" id="results"></ul>');
    if(data.artistas.length>0)$('#results').append('<li class="list-divider">Artistas</li>');
    $.each(data.artistas, function(k, item){        
        $('#results').append('<li class="list-item-single-line"><em class="counter">'+item.n+'</em> <a href="busca.html?a='+item.url+'&n='+encodeURIComponent(item.title_clean)+'"><i class="icon icon-user"></i> <span>' + item.title + '</span></a></li>');
    });
    if(data.musicas.length>0)$('#results').append('<li class="list-divider">M&uacute;sicas</li>');
    $.each(data.musicas, function(k, item){        
        $('#results').append('<li class="list-item-single-line"><a href="cifra.html?u='+item.url+'"><i class="icon icon-music"></i> ' + item.title + '</a></li>');
    });
    //$('#results').append('<li>'+data.results+' resultados encontrados</li>');
    if(!data.results)$('#results').append('<li class="no-results"><span>Nenhum resultado encontrado.</span></li>');
}

function loadArtist(a){ 
    //var uri=$(a).data('url');
    $('#loading').fadeIn('fast');
    //event.stopPropagation();
    $.ajax({
        type: "GET",
        url: domain,
        crossDomain: true,
        data: { u: a},
        dataType: 'jsonp',
        jsonpCallback: 'artist',
        jsonp: 'callback' 
    }).done(function( msg ) {
        $('#loading').fadeOut('fast');
    });
    return false;
}
function artist(data){
        $('#content').html('<ul class="list" id="results"></ul>');
        //$('#results').append('<li class="list-divider"><i class="icon icon-user"></i> '+n+'</li>');
        $.each(data.musicas, function(k, item){  
            $('#results').append('<li class="list-item-single-line"><a href="cifra.html?u='+item.url+'"><i class="icon icon-music"></i> ' + item.title + '</a></li>');
        });
}

$(document).ready(function(){

    var uri=$.getUrlVar('a');
    var q=($.getUrlVar('q'));
    n=decodeURIComponent($.getUrlVar('n'));
    if(uri){
        loadArtist(uri, n);
        $('#q').val(n);
    }else if(q){
        $('#q').val(unescape(q));
        $('#form-search').submit();
    }
});

