angular.module('decisionmakerapp.controllers', [])

.controller('DecisionMakerCtrl', function ($scope, $timeout) {

    var angle = 0,
        animationInProgress = false;

    function getRandom() {
        return 720 + Math.floor(Math.random() * 3000);
    }

    $scope.startDecision = function () {

        if (animationInProgress) {
            return;
        }

        animationInProgress = true;

        var circle = document.getElementById('circle');

        angle += getRandom();

        circle.style.transform = "rotate(" + angle + "deg)";
        circle.style.webkitTransform = "rotate(" + angle + "deg)";

        $scope.result = " ";

        $timeout(function () {
            animationInProgress = false;
            $scope.result = angle % 360 > 180 ? "YES" : "NO";
        }, 3000);
    }


});