/*global angular */
require.config({
  shim: {
    'angular': {
      exports: 'angular'
    }
  },
  paths: {
    app: 'js/app',
    angular: './components/angular/angular'
  },
  baseUrl: '/'
});

(function() {
  console.time('requirejs');
  require([
    // application
    'app',
    'js/jquery-2.0.2.min.js',
    'js/mobile-nav.js',
    // 'js/sprintf.min.js',
    'js/globals.js',
    // 'js/bxslider.js',


    // dependencies
    'angular',
    'components/angular-sanitize/angular-sanitize',
    'components/moment/min/moment.min',
    'components/angular-moment/angular-moment',    


    // services
    'js/services/database.js',
    'js/services/dates.js',
    'js/services/http-cache.js',
    // 'js/services/localization.js',
    'js/services/md5.js',
    'js/services/Auth.js',
    'js/services/CheckRetina.js',
    'js/services/angular-xml.js',


    // controllers
    'js/controllers/News.js',
    'js/controllers/SingleCtrl.js',
    'js/controllers/CategoryCtrl.js',
    'js/controllers/RestCtrl.js',
    'js/controllers/StoreCtrl.js',
    'js/controllers/DescCtrl.js',
    'js/controllers/SalesCtrl.js',
    'js/controllers/AboutCtrl.js',
    'js/controllers/MapCtrl.js'
  ], function() {
    console.timeEnd('requirejs');

    angular.bootstrap(document, ['app']);
  });

})();
