'use strict';
(function (angular)
{
    var module = angular.module('engine.services');
    module.service('gameSessionService', function ()
    {
        var dummySessionId = "000000000000000000000000";

        this.createSession = function (data, callback)
        {
            var returnSession = function (gameSession)
            {
                callback({
                    gameSessionId: gameSession,
                    mappingTable: {
                        mappingTablePrefix: "/staticmax/",
                        mappingTableURL: "mapping_table.json",
                        assetPrefix: "/missing/"
                    },
                    ok: true,
                    status: 200
                });
            };

            returnSession(dummySessionId);
        };
        this.destroySession = function (data, callback)
        {
            callback();
        };
    });

    module.run(['gameSessionService', 'bridgeServices', function (gameSessionService, bridgeServices)
    {
        bridgeServices.registerService('gamesession.create', gameSessionService.createSession, gameSessionService);
        bridgeServices.registerService('gamesession.destroy', gameSessionService.destroySession, gameSessionService);
    }]);
})(window.angular);
