'use strict';
(function (angular, _)
{
    var module = angular.module('game.host');

    // For local people
    module.service('localStorage', function ($q, $rootScope, $window)
    {
        this.initialise = function ()
        {
            var that = this;
            var data = {};
            if ($window.localStorage.data)
            {
                data = JSON.parse($window.localStorage.data);
            }
            delete data.initialise;
            _.extend(this, data);
            $rootScope.$watch(function ()
            {
                return that;
            }, function ()
            {
                $window.localStorage.data = JSON.stringify(that);
            }, true);

            return $q.when();
        };
    });
})(window.angular, window._);
