'use strict';
(function (angular)
{
    var module = angular.module('engine.services');

    module.service('userDataService', function (bridgeServices)
    {
        this.getKeys = function userDataServiceGetKeysFn(unused, callback)
        {
            callback({
                status: 200,
                data: bridgeServices.getItemList()
            });
        };

        this.exists = function userDataServiceExistsFn(request, callback)
        {
            var key = /\/(\w*)\/?$/.exec(request.url)[1];
            callback({
                status: 200,
                data: !!bridgeServices.getItem(key)
            });
        };

        this.get = function userDataServiceGetFn(request, callback)
        {
            var key = /\/(\w*)\/?$/.exec(request.url)[1];
            var data = bridgeServices.getItem(key);
            if (data)
            {
                callback({
                    status: 200,
                    value: data
                });
            }
            else
            {
                callback({
                    status: 404,
                    value: {}
                });
            }
        };

        this.set = function userDataServiceSetFn(request, callback)
        {
            var key = /\/(\w*)\/?$/.exec(request.url)[1];
            bridgeServices.setItem(key, request.data.value);
            callback({status: 200});
        };

        this.remove = function userDataServiceRemoveFn(request, callback)
        {
            var key = /\/(\w*)\/?$/.exec(request.url)[1];
            bridgeServices.removeItem(key);
            callback({status: 200});
        };

        this.removeAll = function userDataServiceRemoveAllFn(unused, callback)
        {
            bridgeServices.removeAllItems();
            callback({status: 200});
        };
    });

    module.run(['userDataService', 'bridgeServices', function (userDataService, bridgeServices)
    {
        bridgeServices.registerService('userdata.getkeys', userDataService.getKeys, userDataService);
        bridgeServices.registerService('userdata.exists', userDataService.exists, userDataService);
        bridgeServices.registerService('userdata.get', userDataService.get, userDataService);
        bridgeServices.registerService('userdata.set', userDataService.set, userDataService);
        bridgeServices.registerService('userdata.remove', userDataService.remove, userDataService);
        bridgeServices.registerService('userdata.removeall', userDataService.removeAll, userDataService);
    }]);

})(window.angular);
