BasicGame = {};

BasicGame.Boot = function (game) {
	this.game = game;
};

BasicGame.Boot.prototype = {

	preload: function () {
            this.load.spritesheet('enemyOne', 'assets/sprites/metalslug_mummy37x45.png', 37, 45, 18);         // Enemigos 1
            this.load.spritesheet('enemyTwo', 'assets/sprites/metalslug_monster39x40.png', 39, 40, 16);       // Enemigos 2
            this.load.spritesheet('blood', 'assets/sprites/blood40X40.png', 20, 20);                          // Sangre

            this.load.image('background1', 'assets/background1.jpg');  
            this.load.image('mummyBackground_blur', 'assets/images/background1_blur.jpg');
            this.load.image('desert', 'assets/images/desert.png');
            this.load.image('madness', 'assets/images/madness.png');
            this.load.image('score', 'assets/images/score.png');
            this.load.image('health', 'assets/images/health.png');
            this.load.image('maxscore', 'assets/images/maxscore.png');
            this.load.image('gameover', 'assets/images/gameover.png');
            this.load.image('sharescore', 'assets/images/sharescore.png');
            this.load.image('accuracy', 'assets/images/accuracy.png');

            this.load.image('target', 'assets/sprites/point.png');                                            // Punto de Mira

            this.load.image('button', 'assets/buttons/start.png');
            this.load.image('twitterButton', 'assets/images/twitter_mini.png');
        
            this.load.bitmapFont('desyrel', 'assets/fonts/desyrel.png', 'assets/fonts/desyrel.xml');
            
            // AUDIO
            this.load.audio('shot', ['assets/audio/shot.mp3']);
            this.load.audio('splat', ['assets/audio/splat.mp3']);
            this.load.audio('shotsplat', ['assets/audio/shotsplat.mp3']);
            this.load.audio('click', ['assets/audio/click.mp3']);
            this.load.audio('momia1', ['assets/audio/momia1.mp3']);
            this.load.audio('momia2', ['assets/audio/momia2.mp3']);
            this.load.audio('momia3', ['assets/audio/momia3.mp3']);
            this.load.audio('momia4', ['assets/audio/momia4.mp3']);
            this.load.audio('momia5', ['assets/audio/momia5.mp3']);
            this.load.audio('momia6', ['assets/audio/momia6.mp3']);


// Inicializa el timer del contador	
       //this.time = setInterval(function(){();},1000);
        this.timeEnemyOne = setInterval(function(){myTimerEnemyOne();},500);
        //this.timeEnemyTwo = setInterval(function(){myTimerEnemyTwo();},1500);
           
		//	Here we load the assets required for our preloader (in this case a background and a loading bar)
		/*this.load.image('preloaderBackground', 'images/preloader_background.jpg');
		this.load.image('preloaderBar', 'images/preloadr_bar.png'); */

	},

	create: function () {

            // Ajustar al tamaño de ventana        
              this.game.stage.scaleMode = Phaser.StageScaleMode.SHOW_ALL; 
              this.game.stage.scale.setShowAll();
              this.game.stage.scale.refresh();

        

		//	Unless you specifically know your game needs to support multi-touch I would recommend setting this to 1
		this.game.input.maxPointers = 1;

		//	Phaser will automatically pause if the browser tab the game is in loses focus. You can disable that here:
		this.game.stage.disableVisibilityChange = true;

	    if (this.game.device.desktop){
			//	If you have any desktop specific settings, they can go in here
		    this.game.stage.scale.pageAlignHorizontally = true;
	    }else{
			//	Same goes for mobile settings.
			//	In this case we're saying "scale the game, no lower than 480x260 and no higher than 1024x768"
		    this.game.stage.scaleMode = Phaser.StageScaleMode.SHOW_ALL;
		    //this.game.stage.scale.minWidth = 240;
		    //this.game.stage.scale.minHeight = 130;
		    //this.game.stage.scale.maxWidth = 512;
		    //this.game.stage.scale.maxHeight = 384;
		    this.game.stage.scale.forceLandscape = true;
		    this.game.stage.scale.pageAlignHorizontally = true;
		    this.game.stage.scale.setScreenSize(true);
	    }

	    //	By this point the preloader assets have loaded to the cache, we've set the game settings
	    //	So now let's start the real preloader going
		this.game.state.start('Preloader');
	}

};
