var app = angular.module('app', ['ngRoute', 'ngResource', 'ngAnimate', 'ngSanitize']);
	
	app.factory('Model', ['$resource', function($resource) {
		return $resource(
			'http://www.designwolf.com.br/servidor/usuarios/:id.json',
			 {
				id: '@id'
			 },
			 {
				update: {
					method: 'PUT'
				}
			}
		)
	}])

	app.config(function($routeProvider){
	
		$routeProvider
		.when('/', {
			templateUrl: 'inicio.html',
			controller: 'listagemPost'
			
		})	
		
		.when('/sobre',{
			templateUrl: 'sobre.html'
			
		})
		
		.when('/post/:id',{
			templateUrl: 'post.html',
			controller: 'mostrarPost'
		})
	
	});
	

	

	
	app.controller('mostrarPost', function($scope, $routeParams, Model){
		
		$scope.i = Model.get(
			{id:$routeParams.id}
		);

        $('.progress').css('display','block');
            
        $('.loader').ready(function(){
            setTimeout(function(){
               $('.progress').css('display','none');
               $('.loader').css('display','block');
            }, 600);
        })
        
        
	});