function debugObj(obj) {
var output = 'debug:<br />';
	for(var index in obj) {
		var value = obj[index];
		output = output + index + '=' + value+'<br />';
	}
	return output;
}
function printBool(bool) {
	return (bool) ? 'true' : 'false';
}

function isTouchSupported() {
	return ('ontouchstart' in window);
}

function getOrientationScreen() {
	var orientation = screen.mozOrientation;
	return orientation;
}

function isCanvasSupported(){
  var elem = document.createElement('canvas');
  return !!(elem.getContext && elem.getContext('2d'));
}

function isWebGLSupported(){
  return window.WebGLRenderingContext ? true : false;
}

function updateOnlineStatus() {
	$('#isOnline').html(navigator.onLine);
}

function isLocalStorage() {
	return window.localStorage ? true: false;
}

$(document).ready(function() {
	$('#viewPort').css({ scale: '1.2', opacity: 0});
	//initiate app
	
	var trans = new translateObj({
		'defaultLang':'en',
		'autoDetect': true,
		'onTranslateEnd' : function() {
			$('#viewPort').transition({ scale: '1.2', opacity: 0}).transition({ scale: '1', opacity: 1});
		}
	});
	trans.initTranslate();
	advertisement.init();

	//$('#output').html(debugObj(navigator));
	
	//screen info detect
	
	$('#screenInfo').append('<li>' + trans.echo('width') + ': <span class="textGray">' + trans.echo('pixels',[screen.width])  + '</span></li>');
	$('#screenInfo').append('<li>' + trans.echo('height') + ': <span class="textGray">' + trans.echo('pixels',[screen.height])  + '</span></li>');
	$('#screenInfo').append('<li>' + trans.echo('color_depth') + ': <span class="textGray">' +  trans.echo('bits',[screen.colorDepth]) + '</span></li>');
	$('#screenInfo').append('<li>' + trans.echo('pixel_ratio') + ': <span class="textGray">' + trans.echo('dpi',[window.devicePixelRatio,window.devicePixelRatio * 96]) + '</span></li>');
	$('#screenInfo').append('<li>' + trans.echo('touch_screen') + ': <span class="textGray">' +  trans.echo(printBool(isTouchSupported())) + '</span></li>');
	$('#screenInfo').append('<li>' + trans.echo('orientation_screen') + ': <span id="orientationScreen" class="textGray">' + getOrientationScreen() + '</span></li>');
	

	$('#softInfo').append('<li>' + trans.echo('user_agent') + ': <span class="textGray">' + navigator.userAgent + '</span></li>');
	$('#softInfo').append('<li>' + trans.echo('language') + ': <span class="textGray">' + navigator.language + '</span></li>');
	$('#softInfo').append('<li>' + trans.echo('engine_render') + ': <span class="textGray">' + navigator.product + '</span></li>');
	$('#softInfo').append('<li>' + trans.echo('cookie_flag') + ': <span class="textGray">' +  trans.echo(printBool(navigator.cookieEnabled)) + '</span></li>');
	$('#softInfo').append('<li>' + trans.echo('local_storage') + ': <span class="textGray">' +  trans.echo(printBool(isLocalStorage())) + '</span></li>');

	$('#netInfo').append('<li>' + trans.echo('online_flag') +  ': <span id="isOnline" class="textGray">' + trans.echo(printBool(navigator.onLine)) + '</span></li>');
	
	var testVideo = document.createElement( "video" );
	isMPEG4VideoSupported = "" !== testVideo.canPlayType('video/mp4; codecs="avc1.4D401E, mp4a.40.2"');
	isH264VideoSupported = "" !== (testVideo.canPlayType('video/mp4; codecs="avc1.42E01E"') || testVideo.canPlayType( 'video/mp4; codecs="avc1.42E01E, mp4a.40.2"'));
	isOGGVideoSupported = "" !== testVideo.canPlayType('video/ogg; codecs="theora"');
	isWEBMVideoSupported = "" !== testVideo.canPlayType('video/webm; codecs="vp8, vorbis"')
	
	$('#videoInfo').append('<li>' + trans.echo('videomp4') + ': <span class="textGray">' +  trans.echo(printBool(isMPEG4VideoSupported)) + '</span></li>');
	$('#videoInfo').append('<li>' + trans.echo('videomp4_2') + ': <span class="textGray">' +  trans.echo(printBool(isH264VideoSupported)) + '</span></li>');
	$('#videoInfo').append('<li>' + trans.echo('videoogg') + ': <span class="textGray">' +  trans.echo(printBool(isOGGVideoSupported)) + '</span></li>');
	$('#videoInfo').append('<li>' + trans.echo('videowebm') + ': <span class="textGray">' +  trans.echo(printBool(isWEBMVideoSupported)) + '</span></li>');

	var testAudio = document.createElement( "audio" );
	isMP3AudioSupported = "" !== testAudio.canPlayType('audio/mpeg;');
	isMP4AudioSupported = "" !== testAudio.canPlayType('audio/mp4;');
	isAACAudioSupported = "" !== testAudio.canPlayType('audio/aac; codecs="mpeg 4, aac"');
	isOGGVorbisAudioSupported = "" !== testAudio.canPlayType('audio/ogg; codecs="vorbis"');
	isOGGOpusAudioSupported = "" !== testAudio.canPlayType('audio/ogg; codecs="opus"');
	isWEBMAudioSupported = "" !== testAudio.canPlayType('audio/webm; codecs="vorbis"');
	isWaveAudioSupported = "" !== testAudio.canPlayType('audio/wave; codecs="wave, pcm"');
	
	$('#audioInfo').append('<li>' + trans.echo('audiomp3') + ': <span class="textGray">' +  trans.echo(printBool(isMP3AudioSupported)) + '</span></li>');
	$('#audioInfo').append('<li>' + trans.echo('audiomp4') + ': <span class="textGray">' +  trans.echo(printBool(isMP4AudioSupported)) + '</span></li>');
	$('#audioInfo').append('<li>' + trans.echo('audioacc') + ': <span class="textGray">' +  trans.echo(printBool(isAACAudioSupported)) + '</span></li>');
	$('#audioInfo').append('<li>' + trans.echo('audiowebm') + ': <span class="textGray">' +  trans.echo(printBool(isWEBMAudioSupported)) + '</span></li>');	
	$('#audioInfo').append('<li>' + trans.echo('audioogg') + ': <span class="textGray">' +  trans.echo(printBool(isOGGVorbisAudioSupported)) + '</span></li>');
	//$('#audioInfo').append('<li>audio/ogg Opus: <span class="textGray">' + isOGGOpusAudioSupported + '</span></li>');
	$('#audioInfo').append('<li>' + trans.echo('audiowav') + ': <span class="textGray">' +  trans.echo(printBool(isWaveAudioSupported)) + '</span></li>');	
	
	//render engines
	$('#renderInfo').append('<li>' + trans.echo('2d_engine') + ': <span class="textGray">' +  trans.echo(printBool(isCanvasSupported())) + '</span></li>');
	$('#renderInfo').append('<li>' + trans.echo('3d_engine') + ': <span class="textGray">' +  trans.echo(printBool(isWebGLSupported())) + '</span></li>');
	
	//locale information
	var currentDate = new Date()
	
	$('#localeInfo').append('<li>' + trans.echo('date_time') + ': <span class="textGray">' + currentDate.toUTCString() + '</span></li>');
	$('#localeInfo').append('<li>' + trans.echo('time_zone_dif') + ': <span class="textGray">' + (currentDate.getTimezoneOffset() / 60) * -1 + 'h</span></li>');
	$('#localeInfo').append('<li>' + trans.echo('total_mil') + ': <span class="textGray">' + currentDate.getTime() + '</span></li>');
	
	//Battery
	var battery = navigator.battery || navigator.mozBattery || navigator.webkitBattery;
	$('#batteryInfo').append('<li>' + trans.echo('battery_level') + ': <span class="textGray">' + (battery.level * 100) + '%</span></li>');
	$('#batteryInfo').append('<li>' + trans.echo('battery_status') + ': <span class="textGray">' +  trans.echo(printBool(battery.charging)) + '</span></li>');
	
	
/*App Menu options*/
	$('#btnHelp').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'help.html';
		});
	});
	
	$('#btnAbout').click(function(e) {
		e.preventDefault();
		$('#viewPort').transition({ scale: '0.75', opacity: 0}).delay(30).queue(function(){
			location.href = 'about.html';
		});
	});

	$('#btnExit').click(function(e) {
		e.preventDefault();
		window.close();
	});

	//listeners
	screen.addEventListener("mozorientationchange", function () {
		$('#orientationScreen').html(getOrientationScreen());
	});

	window.addEventListener('online',  updateOnlineStatus);
	window.addEventListener('offline', updateOnlineStatus);
	
});

(function($) {
	$(document).ready(function() {
		$.slidebars();
	});
}) (jQuery);

