var buttons = require('sdk/ui/button/action');
var tabs = require("sdk/tabs");
var data = require("sdk/self").data;
var selection = require("sdk/selection");
var self = require("sdk/self");
var {
	Hotkey
} = require("sdk/hotkeys");
var contextMenu = require("sdk/context-menu");

var showHotKey = Hotkey({
	combo: "ctrl-shift-z",
	onPress: function() {
		tabs.activeTab.attach({
			contentScriptFile: [data.url("jquery.js"),data.url("call-number-hotkey.js")]
		});
	}
});

var showHotKey = Hotkey({
	combo: "ctrl-y",
	onPress: function() {
		tabs.activeTab.attach({
			contentScriptFile: [data.url("jquery.js"), data.url("check-number-hotkey.js")]
		});
	}
});

var button = buttons.ActionButton({
	id: "moom-vn-link",
	label: "Visit MooM.vn",
	icon: {
		"16": "./moom_ico.png",
		"32": "./moom_ico.png",
		"64": "./moom_ico.png"
	},
	onClick: handleClick
});

function handleClick(state) {
	tabs.open("http://www.moom.vn/");
}

var checkItem = contextMenu.Item({
	label: "Kiểm Tra Chính Chủ    Ctrl+Shift+Z",
	contentScriptFile: [data.url("check-number.js"), data.url("jquery.js"), data.url("process.js")]
});

var callItem = contextMenu.Item({
	label: "Gọi Đến Số        Ctrl+Y",
	contentScriptFile: [data.url("call-number.js"), data.url("jquery.js"), data.url("process.js")]
});

var menuItem = contextMenu.Menu({
	label: "Dịch vụ MooM.vn",
	context: contextMenu.SelectionContext(),
	image: self.data.url("moom_ico.png"),
	items: [checkItem, callItem],
	onMessage: function(selectionText) {
		console.log(selectionText);
	}
});