(function () {
    /*
        WebActivities:

            configure
            costcontrol/balance
            costcontrol/data_usage
            costcontrol/telephony
            dial
            new (type: "websms/sms", "webcontacts/contact") (add-contact, compose-mail?)
            open
            pick (type: "image/png" etc)
            record (capture?)
            save-bookmark
            share
            test
            view (type: "url" etc. "text/html"?)
    */

    // WebActivities
    var pickImage = document.querySelector("#pick-image");
    if (pickImage) { 
        pickImage.onclick = function () {
            var pick = new MozActivity({
                name: "pick",
                data: {
                    type: ["image/png", "image/jpg", "image/jpeg"]
                 }
            });

            pick.onsuccess = function () { 
                var img = document.createElement("img");
                img.src = window.URL.createObjectURL(this.result.blob);
                var imagePresenter = document.querySelector("#image-presenter");
                imagePresenter.appendChild(img);
                imagePresenter.style.display = "block";
            };

            pick.onerror = function () { 
                alert("Can't view the image!");
            };
        }
    }

    var pickAnything = document.querySelector("#pick-anything");
    if (pickAnything) { 
        pickAnything.onclick = function () {
             var pickAny = new MozActivity({
                 name: "pick"
             });

            pickAny.onsuccess = function () { 
                var img = document.createElement("img");
                if (this.result.blob.type.indexOf("image") != -1) {
                    img.src = window.URL.createObjectURL(this.result.blob);
                    document.querySelector("#image-presenter").appendChild(img);
                }
            };

            pickAny.onerror = function () { 
                console.log("An error occurred");
            };
        }
    }

    var record = document.querySelector("#record");
    if (record) { 
        record.onclick = function () {
            var rec = new MozActivity({
                name: "record" // Possibly capture in future versions
            });

            rec.onsuccess = function () { 
                var img = document.createElement("img");
                img.src = window.URL.createObjectURL(this.result.blob);
                var imagePresenter = document.querySelector("#image-presenter");
                imagePresenter.appendChild(img);
                imagePresenter.style.display = "block";
            };

            rec.onerror = function () { 
                alert("No taken picture returned");
            };
        }
    }

  

    var addContact = document.querySelector("#add-contact");
    if (addContact) { 
        addContact.onclick = function () {
            var newContact = new MozActivity({
                name: "new", // Possibly add-contact in future versions
                data: {
                    type: "webcontacts/contact",
                    params: { // Will possibly move to be direct properties under "data"
                        givenName: "Ernesto",
                        lastName: "Bringas",
                        tel: "+524921026959",
                        email: "bringaz_ernesto@hotmail.com",
                        address: "Mexico",
                        note: "This is a note",
                        company: "SODETI"
                    }
                }
            });
        }
    }

    var share = document.querySelector("#share");
    if (share) { 
        share.onclick = function () {
            var sharing = new MozActivity({
                name: "share",
                data: {
                    //type: "url", // Possibly text/html in future versions,
                    number: 1,
                    url:  "http://sodetigroup.com/dieta-y-salud/"
                }
            });
        }
    }

    var shareImage = document.querySelector("#share-image"),
        imgToShare = document.querySelector("#image-to-share");
    if (shareImage && imgToShare) {
        shareImage.onclick = function () {
            if(imgToShare.naturalWidth > 0) {
                // Create dummy canvas
                var blobCanvas = document.createElement("canvas");
                blobCanvas.width = imgToShare.width;
                blobCanvas.height = imgToShare.height;

                // Get context and draw image
                var blobCanvasContext = blobCanvas.getContext("2d");            
                blobCanvasContext.drawImage(imgToShare, 0, 0);

                // Export to blob and share through a Web Activitiy
                blobCanvas.toBlob(function (blob) {
                    var sharingImage = new MozActivity({
                        name: "share",
                        data: {
                            type: "image/*",
                            number: 1,
                            blobs: [blob]
                        }
                    });
                });
            }
            else {
                alert("Image failed to load, can't be shared");
            }
        }
    }

    var viewURL = document.querySelector("#view-url");
    if (viewURL) { 
        viewURL.onclick = function () {
            var openURL = new MozActivity({
                name: "view",
                data: {
                    type: "url", // Possibly text/html in future versions
                    url: "http://sodetigroup/dieta-y-salud/"
                }
            });
        }
    }

    var composeEmail = document.querySelector("#compose-email");
    if (composeEmail) { 
        composeEmail.onclick = function () {
            var createEmail = new MozActivity({
                name: "new", // Possibly compose-mail in future versions
                data: {
                    type : "mail",
                    url: "mailto:bringaz_ernesto@hotmail.com"
                }
            });
        }
    }

    var saveBookmark = document.querySelector("#save-bookmark");
    if (saveBookmark) { 
        saveBookmark.onclick = function () {
            var savingBookmark = new MozActivity({
                name: "save-bookmark",
                data: {
                    type: "url",
                    url: "http://sodetigroup.com",
                    name: "Ernesto Bringas",
                    icon: "http://sodetigroup.com/favicon.ico"
                 }
            });
        }
    }

    // Notifications
    var addNotification = document.querySelector("#add-notification");
    if (addNotification) {
        addNotification.onclick = function () {
            var notification = navigator.mozNotification.createNotification(
                "See this", 
                "This is a notification"
            );
             notification.show();
        };
    }
    
    // deviceStorage, pictures
    var deviceStoragePictures = document.querySelector("#device-storage-pictures"),
        deviceStoragePicturesDisplay = document.querySelector("#device-storage-pictures-display");
    if (deviceStoragePictures && deviceStoragePicturesDisplay) {
        deviceStoragePictures.onclick = function () {
            var deviceStorage = navigator.getDeviceStorage("pictures"),
                cursor = deviceStorage.enumerate(); 

            deviceStoragePicturesDisplay.innerHTML = "<h4>Result from deviceStorage - pictures</h4>";
             
              cursor.onsuccess = function() { 
                if (!cursor.result)  {
                    deviceStoragePicturesDisplay.innerHTML = "No files";
                }
                
                var file = cursor.result,
                    filePresentation; 

                filePresentation = "<strong>" + file.name + ":</strong> " + parseInt(file.size / 1024, 10) + "kb<br>";
                filePresentation += "<p><img src='" + window.URL.createObjectURL(file) + "' alt=''></p>";
                deviceStoragePicturesDisplay.innerHTML += filePresentation;

                deviceStoragePicturesDisplay.style.display = "block";
             };

              cursor.onerror = function () {
                console.log("Error");
                deviceStoragePicturesDisplay.innerHTML = "<h4>Result from deviceStorage - pictures</h4><p>deviceStorage failed</p>";
                deviceStoragePicturesDisplay.style.display = "block";
            };
        };
    }
})(); 
