var Controller;
(function (Controller) {
    var BuscaAlimentos = (function () {
        function BuscaAlimentos($scope, $location, Cache) {
            $scope.Alimentos = Cache.get('alimentos');
            $scope.Termo = Cache.get('termo');
            $scope.Buscar = function () {
                $scope.Alimentos = new Array();
                var proxy = new Util.Proxy("Alimento", "BuscarAlimentos", JSON.stringify({
                    "alimento": $scope.Termo
                }));
                proxy.Post(function (alimentos) {
                    var len = alimentos.BuscarAlimentosResult.length;
                    for(var i = 0; i < len; i++) {
                        var alimento = alimentos.BuscarAlimentosResult[i];
                        $scope.Alimentos.push(alimento);
                    }
                    Cache.put('alimentos', $scope.Alimentos);
                    Cache.put('termo', $scope.Termo);
                    if($scope.Alimentos.length == 0) {
                        Cache.remove('termo');
                    }
                }, this, false);
            };
            $scope.Detalhes = function (codigo) {
                $location.path("/detalhes/" + codigo);
            };
            $scope.HabilitaBusca = function () {
                return !angular.isUndefined($scope.Termo) && $scope.Termo.length >= 3;
            };
        }
        return BuscaAlimentos;
    })();
    Controller.BuscaAlimentos = BuscaAlimentos;    
    var Alimento = (function () {
        function Alimento($scope, $routeParams) {
            var _this = this;
            $scope.Alimento = new Model.Alimento();
            var codigo = $routeParams.codigo;
            if(codigo) {
                $scope.Alimento.Detalhes(parseInt(codigo));
            }
            var len = $scope.Alimento.Medidas.length;
            for(var i = 0; i < len; i++) {
                if($scope.Alimento.Medidas[i].CodMedida == $scope.Alimento.MedidaPadrao.CodMedida) {
                    $scope.Alimento.MedidaPadrao = $scope.Alimento.Medidas[i];
                    $scope.QtdInformada = $scope.Alimento.MedidaPadrao.Quantidade;
                    i = len;
                }
            }
            $scope.CalculaQuantidades = function () {
                var qtdPadrao = $scope.Alimento.MedidaPadrao.Quantidade;
                var MedidaPadrao = $scope.Alimento.MedidaPadrao;
                $scope.Alimento.MedidaPadrao.Calorias = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.Calorias);
                $scope.Alimento.MedidaPadrao.Carboidratos = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.Carboidratos);
                $scope.Alimento.MedidaPadrao.FibrasAlimentares = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.FibrasAlimentares);
                $scope.Alimento.MedidaPadrao.GordurasSaturadas = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.GordurasSaturadas);
                $scope.Alimento.MedidaPadrao.GordurasTotais = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.GordurasTotais);
                $scope.Alimento.MedidaPadrao.Gramas = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.Gramas);
                $scope.Alimento.MedidaPadrao.Pontos = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.Pontos);
                $scope.Alimento.MedidaPadrao.Proteinas = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.Proteinas);
                $scope.Alimento.MedidaPadrao.Quantidade = $scope.QtdInformada;
                $scope.Alimento.MedidaPadrao.Sodio = _this.CalculaQtdtem(qtdPadrao, $scope.QtdInformada, MedidaPadrao.Sodio);
            };
            $scope.MostraQtdPadrao = function () {
                $scope.QtdInformada = $scope.Alimento.MedidaPadrao.Quantidade;
            };
        }
        Alimento.prototype.CalculaQtdtem = function (qtdPadrao, qtdInformada, valor) {
            return (qtdInformada * valor) / qtdPadrao;
        };
        return Alimento;
    })();
    Controller.Alimento = Alimento;    
    var Avaliacao = (function () {
        function Avaliacao($scope, $location) {
            $scope.Usuario = new Model.Usuario();
            if($scope.Usuario.Existe()) {
                $scope.Metas = $scope.Usuario.CarregarMetas();
            }
            $scope.Salvar = function () {
                $scope.Usuario.Salvar();
                $location.path('/menu');
            };
            $scope.CarregarMetas = function () {
                $scope.Usuario.PesoMeta = undefined;
                $scope.Metas = $scope.Usuario.CarregarMetas();
            };
            $scope.ValidaDataNascimento = function () {
                $scope.ok = $scope.Usuario.DataNascimento.length != 10;
            };
        }
        return Avaliacao;
    })();
    Controller.Avaliacao = Avaliacao;    
    var Menu = (function () {
        function Menu($scope, $location) {
            $scope.Usuario = new Model.Usuario();
            $scope.RefazAvaliacao = function () {
                //$scope.Usuario.Excluir();
                $location.path("/avaliacao");
            };
        }
        return Menu;
    })();
    Controller.Menu = Menu;    
    var Evolucao = (function () {
        function Evolucao($scope) {
            $scope.Usuario = new Model.Usuario();
            $scope.HistoricoPeso = $scope.Usuario.CarregarHistoricoPeso();
            $scope.DiaPesagem = $scope.Usuario.HabilitaPesagem();
            $scope.Evolucao = new Model.Evolucao($scope.Usuario.PesoAtual, $scope.DiaPesagem);
            $scope.Salvar = function () {
                if($scope.DiaPesagem) {
                    $scope.Usuario.PesoAtual = $scope.Evolucao.Peso.Peso;
                    $scope.HistoricoPeso = $scope.Usuario.AtualizarPeso();
                    $scope.DiaPesagem = false;
                } else {
                    $scope.Usuario.AtualizaHistorico($scope.Evolucao.Peso);
                    $scope.HistoricoPeso = $scope.Usuario.CarregarHistoricoPeso();
                }
                $scope.Evolucao.HabilitaAtualizacao = false;
            };
            $scope.MostrarBalanca = function (peso) {
                $scope.Evolucao.HabilitaAtualizacao = true;
                $scope.Evolucao.Peso = peso;
                $scope.Evolucao.Texto = peso.Data;
            };
            $scope.ToDate = function (peso) {
                return new Date(peso.Data);
            };
        }
        return Evolucao;
    })();
    Controller.Evolucao = Evolucao;    
})(Controller || (Controller = {}));
//@ sourceMappingURL=Controller.js.map
