﻿/// <reference path="Repository.ts" />
/// <reference path="Util.ts" />
var Model;
(function (Model) {
    var Usuario = (function () {
        function Usuario() {
            this.Optin = true;
            this._repositorio = new Repository.Usuario(this);
            this._repositorio.Carregar();
        }
        Usuario.prototype.EfetuaCalculos = function () {
            this.IMCInicial = this.CalcularIMCInicial();
            this.IMCMeta = this.CalcularIMCMeta();
            this.KilosAPerder = this.CalcularKilosAPerder();
            this.MesesDieta = this.CalcularMesesDieta();
            this.PontosDieta = this.CalcularPontosDieta();
        };
        Usuario.prototype.CalcularIMCInicial = function () {
            if(this.PesoAtual && this.Altura) {
                var resultado = this.PesoAtual / (this.Altura * this.Altura);
                return parseInt(resultado.toString());
            }
        };
        Usuario.prototype.CalcularIMCMeta = function () {
            if(this.PesoMeta && this.Altura) {
                var resultado = this.PesoMeta / (this.Altura * this.Altura);
                return parseInt(resultado.toString());
            }
        };
        Usuario.prototype.CalcularKilosAPerder = function () {
            if(this.PesoAtual && this.PesoMeta) {
                var resultado = this.PesoAtual - this.PesoMeta;
                return parseInt(resultado.toString());
            }
        };
        Usuario.prototype.CalcularMesesDieta = function () {
            if(this.KilosAPerder) {
                var resultado = (this.KilosAPerder * 7) % 30 == 0 ? (this.KilosAPerder * 7) / 30 : ((this.KilosAPerder * 7) / 30) + 1;
                return parseInt(resultado.toString());
            }
        };
        Usuario.prototype.CalcularPontosDieta = function () {
            switch(this.Sexo) {
                case "F":
                    if(this.PesoAtual < 75) {
                        return 30;
                    }
                    if(this.PesoAtual >= 75 && this.PesoAtual < 91) {
                        return 35;
                    }
                    if(this.PesoAtual >= 91 && this.PesoAtual < 111) {
                        return 40;
                    }
                    if(this.PesoAtual >= 111 && this.PesoAtual < 131) {
                        return 45;
                    }
                    if(this.PesoAtual >= 131) {
                        return 50;
                    }
                    break;
                default:
                    if(this.PesoAtual < 68) {
                        return 30;
                    }
                    if(this.PesoAtual >= 68 && this.PesoAtual < 81) {
                        return 35;
                    }
                    if(this.PesoAtual >= 81 && this.PesoAtual < 96) {
                        return 40;
                    }
                    if(this.PesoAtual >= 96 && this.PesoAtual < 111) {
                        return 45;
                    }
                    if(this.PesoAtual >= 111) {
                        return 50;
                    }
            }
        };
        Usuario.prototype.CarregarMetas = function () {
            if(!(this.AlturaCm && this.AlturaMt)) {
                return;
            }
            var altura = parseFloat(this.AlturaMt + "." + this.AlturaCm);
            this.Altura = altura;
            if(!this.Peso) {
                return;
            }
            var metas = new Array();
            if(this.Altura <= 2.5 && this.Peso <= 300) {
                var pesoMinimo = this.Altura * this.Altura * 18.5;
                pesoMinimo = pesoMinimo > pesoMinimo ? pesoMinimo + 1 : pesoMinimo;
                var pesoMaximo = this.Altura * this.Altura * 24.9;
                pesoMaximo = this.Peso > pesoMaximo ? this.Peso - 1 : pesoMaximo;
                if(this.Altura > 0) {
                    for(var i = pesoMinimo; i <= pesoMaximo; i++) {
                        metas.push(parseInt(i.toString()));
                    }
                }
            }
            return metas;
        };
        Usuario.prototype.HabilitaPesagem = function () {
            var today = Util.Data.Today();
            this.ProximaPesagem.setHours(0, 0, 0, 0);
            return this.ProximaPesagem <= today;
        };
        Usuario.prototype.Salvar = function () {
            this.PesoAtual = this.Peso;
            this.EfetuaCalculos();
            this.ProximaPesagem = Util.Data.DiaPesagem();
            this._repositorio.Salvar();
        };
        Usuario.prototype.AtualizarPeso = function () {
            this.EfetuaCalculos();
            this.ProximaPesagem = Util.Data.DiaPesagem();
            return this._repositorio.AtualizarPeso();
        };
        Usuario.prototype.CarregarHistoricoPeso = function () {
            return this._repositorio.ObtemHistoricoPeso();
        };
        Usuario.prototype.Excluir = function () {
            this._repositorio.Excluir();
        };
        Usuario.prototype.Existe = function () {
            return this._repositorio.Existe();
        };
        Usuario.prototype.AtualizaHistorico = function (peso) {
            this._repositorio.AtualizarHistorico(peso);
        };
        Usuario.prototype.AtualizaUsuario = function (response) {
            var usuario = response.SalvarResult;
            if(usuario != null) {
                this.CadastroId = usuario.CadastroId;
                this.IMCInicial = usuario.ImcAtual;
                this.IMCMeta = usuario.ImcIdeal;
                this.PontosDieta = usuario.Pontos;
                this.MesesDieta = usuario.Tempo;
            }
            this.Salvar();
        };
        Usuario.prototype.ObtemUsuarioApi = function () {
            var usuarioApi = {
                cadastroId: this.CadastroId ? this.CadastroId : "",
                nome: this.Nome,
                email: this.Email,
                peso: this.Peso,
                pesoMeta: this.PesoMeta,
                altura: this.Altura,
                sexo: this.Sexo,
                dataNascimento: this.DataNascimento,
                optin: this.Optin
            };
            var retorno = JSON.stringify(usuarioApi);
            return retorno;
        };
        return Usuario;
    })();
    Model.Usuario = Usuario;    
    var Alimento = (function () {
        function Alimento() { }
        Alimento.prototype.Detalhes = function (codigo) {
            var repository = new Repository.Alimento(this);
            repository.PesquisaAlimento(codigo);
        };
        return Alimento;
    })();
    Model.Alimento = Alimento;    
    var Medida = (function () {
        function Medida() { }
        return Medida;
    })();
    Model.Medida = Medida;    
    var Peso = (function () {
        function Peso(peso) {
            this.Peso = peso;
        }
        return Peso;
    })();
    Model.Peso = Peso;    
    var Evolucao = (function () {
        function Evolucao(peso, habilita) {
            this.Peso = new Peso(peso);
            this.HabilitaAtualizacao = habilita;
            this.Texto = habilita ? "Hoje é dia de atualizar seu peso!" : "";
        }
        return Evolucao;
    })();
    Model.Evolucao = Evolucao;    
})(Model || (Model = {}));
//@ sourceMappingURL=Model.js.map
