﻿/// <reference path="Util.ts" />
/// <reference path="Model.ts" />
var Repository;
(function (Repository) {
    var Alimento = (function () {
        function Alimento(alimento) {
            this._alimento = alimento;
        }
        Alimento.prototype.PesquisaAlimento = function (codigo) {
            var proxy = new Util.Proxy("Alimento", "BuscarAlimento", JSON.stringify({
                codAlimento: codigo
            }));
            proxy.Post(this.CarregaAlimento, this, false);
        };
        Alimento.prototype.CarregaAlimento = function (json) {
            var alimento = json.BuscarAlimentoResult;
            if(alimento != null) {
                this._alimento.CodAlimento = alimento.CodAlimento;
                this._alimento.CodMedidaPadrao = alimento.CodMedidaPadrao;
                this._alimento.Descricao = alimento.Descricao;
                this._alimento.MedidaPadrao = alimento.MedidaPadrao;
                this._alimento.Medidas = alimento.Medidas;
                this._alimento.Pontos = alimento.Pontos;
                this._alimento.QtdPadrao = alimento.QtdPadrao;
                this._alimento.Tipo = alimento.Tipo;
            }
        };
        return Alimento;
    })();
    Repository.Alimento = Alimento;    
    var Usuario = (function () {
        function Usuario(usuario) {
            this._usuario = usuario;
        }
        Usuario.prototype.Salvar = function () {
            var proxy = new Util.Proxy("Avaliacao", "Salvar", this.ObtemUsuarioApi());
            proxy.Post(this.AtualizaUsuario, this, false);
            var historico = [
                {
                    'Peso': this._usuario.PesoAtual,
                    'Data': Util.Data.Today()
                }
            ];
            this.ArmazenaHistoricoPeso(historico);
            this.ArmazenaUsuario();
        };
        Usuario.prototype.AtualizaUsuario = function (result) {
            var usuario = result.SalvarResult;
            if(usuario != null) {
                this._usuario.CadastroId = usuario.CadastroId;
                this._usuario.IMCInicial = usuario.ImcAtual;
                this._usuario.IMCMeta = usuario.ImcIdeal;
                this._usuario.PontosDieta = usuario.Pontos;
                this._usuario.MesesDieta = usuario.Tempo;
            }
        };
        Usuario.prototype.ArmazenaUsuario = function () {
            var usuario = this.ObtemUsuarioStorage();
            localStorage.setItem("usuario", usuario);
            console.log('Salvei');
        };
        Usuario.prototype.Excluir = function () {
            localStorage.removeItem("usuario");
            localStorage.removeItem("historico");
            console.log('Excluir');
        };
        Usuario.prototype.AtualizarPeso = function () {
            this.AtualizarPesoApi(Util.Data.TodayToString(), this._usuario.PesoAtual);
            var historico = this.ObtemHistoricoPeso();
            historico.push({
                'Peso': this._usuario.PesoAtual,
                'Data': Util.Data.Today()
            });
            this.ArmazenaHistoricoPeso(historico);
            this.ArmazenaUsuario();
            return historico;
        };
        Usuario.prototype.AtualizarHistorico = function (peso) {
            this.AtualizarPesoApi(Util.Data.FormataData(peso.Data), peso.Peso);
            var historico = this.ObtemHistoricoPeso();
            for(var i = 0, len = historico.length; i < len; i++) {
                var data = new Date(historico[i].Data);
                if(data = peso.Data) {
                    historico[i].Peso = peso.Peso;
                    if(i == 0) {
                        this._usuario.PesoAtual = peso.Peso;
                        this.ArmazenaUsuario();
                    }
                    i = len;
                }
            }
            this.ArmazenaHistoricoPeso(historico);
        };
        Usuario.prototype.AtualizarPesoApi = function (data, peso) {
            var json = {
                'cadastroId': this._usuario.CadastroId,
                'data': data,
                'peso': peso
            };
            var proxy = new Util.Proxy("Avaliacao", "Salvar", JSON.stringify(json));
            proxy.Post(this.AtualizaUsuario, this, false);
        };
        Usuario.prototype.ArmazenaHistoricoPeso = function (historico) {
            localStorage.setItem('historico', JSON.stringify(historico));
        };
        Usuario.prototype.ObtemHistoricoPeso = function () {
            var json = localStorage.getItem('historico');
            return JSON.parse(json);
        };
        Usuario.prototype.Carregar = function () {
            if(this.Existe()) {
                var json = localStorage.getItem("usuario");
                var usuario = JSON.parse(json);
                this._usuario.CadastroId = usuario.CadastroId;
                this._usuario.Nome = usuario.Nome;
                this._usuario.Email = usuario.Email;
                this._usuario.Sexo = usuario.Sexo;
                this._usuario.Altura = usuario.Altura;
                this._usuario.AlturaMt = usuario.AlturaMt;
                this._usuario.AlturaCm = usuario.AlturaCm;
                this._usuario.DataNascimento = usuario.DataNascimento;
                this._usuario.Peso = usuario.PesoInicial;
                this._usuario.PesoAtual = usuario.PesoAtual;
                this._usuario.MesesDieta = usuario.MesesDieta;
                this._usuario.PontosDieta = usuario.PontosDieta;
                this._usuario.PesoMeta = usuario.PesoMeta;
                this._usuario.ProximaPesagem = new Date(usuario.ProximaPesagem);
            }
        };
        Usuario.prototype.Existe = function () {
            var json = localStorage.getItem("usuario");
            if(json) {
                console.log('Existe');
                return true;
            }
            console.log('Não Existe');
            return false;
        };
        Usuario.prototype.ObtemUsuarioApi = function () {
            var usuarioApi = {
                cadastroId: this._usuario.CadastroId ? this._usuario.CadastroId : "",
                nome: this._usuario.Nome,
                email: this._usuario.Email,
                peso: this._usuario.PesoAtual,
                pesoMeta: this._usuario.PesoMeta,
                altura: this._usuario.Altura,
                sexo: this._usuario.Sexo,
                dataNascimento: this._usuario.DataNascimento,
                optin: this._usuario.Optin
            };
            var retorno = JSON.stringify(usuarioApi);
            return retorno;
        };
        Usuario.prototype.ObtemUsuarioStorage = function () {
            var usuario = {
                CadastroId: this._usuario.CadastroId,
                Nome: this._usuario.Nome,
                Email: this._usuario.Email,
                Sexo: this._usuario.Sexo,
                Altura: this._usuario.Altura,
                AlturaMt: this._usuario.AlturaMt,
                AlturaCm: this._usuario.AlturaCm,
                DataNascimento: this._usuario.DataNascimento,
                PesoInicial: this._usuario.Peso,
                PesoAtual: this._usuario.PesoAtual,
                PesoMeta: this._usuario.PesoMeta,
                IMCInicial: this._usuario.IMCInicial,
                PontosDieta: this._usuario.PontosDieta,
                MesesDieta: this._usuario.MesesDieta,
                ProximaPesagem: this._usuario.ProximaPesagem
            };
            var retorno = JSON.stringify(usuario);
            return retorno;
        };
        return Usuario;
    })();
    Repository.Usuario = Usuario;    
})(Repository || (Repository = {}));
//@ sourceMappingURL=Repository.js.map
