/// <reference path="../Lib/JQuery.d.ts" />
var Util;
(function (Util) {
    var Proxy = (function () {
        function Proxy(Servico, Metodo, Json) {
            this.Servico = Servico;
            this.Metodo = Metodo;
            this.Json = Json;
            this.Url = "http://mobile.dietaesaude.com.br/firefoxos/api/proxy";
        }
        Proxy.prototype.Post = function (callback, context, async) {
            if (typeof async === "undefined") { async = true; }
            if(navigator.onLine) {
                try  {
                    var data = this.ObtemPostData();
                    $.ajax({
                        url: this.Url,
                        context: context,
                        type: "POST",
                        dataType: "json",
                        data: data,
                        success: callback,
                        beforeSend: this.ExibeLoad,
                        complete: this.RemoveLoad,
                        async: async
                    });
                } catch (e) {
                    console.log(navigator.onLine);
                }
            }
        };
        Proxy.prototype.RemoveLoad = function () {
            $('.loader').hide();
        };
        Proxy.prototype.ExibeLoad = function () {
            $('.loader').show();
        };
        Proxy.prototype.ObtemPostData = function () {
            return {
                Servico: this.Servico,
                Metodo: this.Metodo,
                Json: this.Json
            };
        };
        return Proxy;
    })();
    Util.Proxy = Proxy;    
    var Data = (function () {
        function Data() { }
        Data.Today = function Today() {
            var now = new Date();
            now.setHours(0, 0, 0, 0);
            return now;
        };
        Data.TodayToString = function TodayToString() {
            var date = new Date();
            var today = date.getDate() + '/' + (date.getMonth() + 1) + '/' + date.getFullYear();
            return today;
        };
        Data.FormataData = function FormataData(data) {
            var date = new Date(data);
            return date.getDate() + '/' + (date.getMonth() + 1) + '/' + date.getFullYear();
        };
        Data.DiaPesagem = function DiaPesagem() {
            var data = new Date();
            var dia = data.getDate();
            var diaSemana = data.getDay() + 1;
            var adicionar = (11 - diaSemana) + dia;
            data.setDate(adicionar);
            return data;
        };
        Data.Idade = function Idade(data) {
            var dt = null;
            var nascimento = null;
            if(data.indexOf('-') === -1) {
                dt = data.split('/');
                nascimento = parseInt(dt[2] + dt[1] + dt[0]);
            } else {
                dt = data.split('-');
                nascimento = parseInt(dt[0] + dt[1] + dt[2]);
            }
            var now = new Date();
            var diaAtual = now.getDate().toString();
            var mesAtual = (now.getMonth() + 1).toString();
            if(diaAtual.length < 2) {
                diaAtual = "0" + diaAtual;
            }
            if(mesAtual.length < 2) {
                mesAtual = "0" + mesAtual;
            }
            var dataAtual = parseInt(now.getFullYear() + "" + mesAtual + diaAtual);
            var idade = dataAtual - nascimento;
            return parseInt(idade.toString().replace(/\d{4}$/, ""));
        };
        return Data;
    })();
    Util.Data = Data;    
})(Util || (Util = {}));
//@ sourceMappingURL=Util.js.map
