
// Rotas
var appModule = angular.module('app', []);

appModule.config(['$routeProvider', function ($routeProvider, $locationProvider) {
    $routeProvider.when('/intro', { templateUrl: 'Views/intro.html' });
    $routeProvider.when('/avaliacao', { templateUrl: 'Views/avaliacao.html', controller: 'Controller.Avaliacao' });
    $routeProvider.when('/menu', { templateUrl: 'Views/menu.html', controller: 'Controller.Menu' });
    $routeProvider.when('/busca', { templateUrl: 'Views/busca_alimentos.html', controller: 'Controller.BuscaAlimentos' });
    $routeProvider.when('/evolucao', { templateUrl: 'Views/evolucao.html', controller: 'Controller.Evolucao' });
    $routeProvider.when('/detalhes/:codigo', { templateUrl: 'Views/detalhe_alimento.html', controller: 'Controller.Alimento' });
    $routeProvider.otherwise({ redirectTo: '/avaliacao' });
}]);

appModule.factory('Cache', ['$cacheFactory', function ($cacheFactory) {
    return $cacheFactory('Cache');
}]);

appModule.directive('validaNascimento', function () {
    return {
        require: 'ngModel',
        link: function (scope, elm, attrs, ctrl) {
            elm.on('blur', function () {
                scope.$apply(function () {
                    var idade = Util.Data.Idade(elm.val());
                    ctrl.$setValidity('idade', idade >= 18);
                });
            });
        }
    };
});

var usuario = new Model.Usuario();
if (usuario.Existe()) {
    window.location.href = "#/menu";
} else {
    window.location.href = "#/intro";
}
//