cordova.define("com.digipea.mobile.plugin.facebook.FacebookPluginImpl", function(require, exports, module) { 
var modulemapper = require('cordova/modulemapper');

var origWindowOpen = modulemapper.getOriginalSymbol(window, 'window.open');

//PROPERTIES - patched by hook 031
var APP_ID = "336913953085460"; 
var APP_NAME = "digipea"; 
var REDIRECT_URI = "https://www.facebook.com/connect/login_success.html";
var SHARE_ACTION_URL = "me/digipea:likein";


var GET_METHOD = "GET";
var POST_METHOD = "POST";
var DELETE_METHOD = "DELETE";

var READ_PERMISSIONS = "email,user_birthday";
var WRITE_PERMISSIONS = "email,user_birthday,publish_actions";

var FB_REGISTER_TYPE = 0;
var FB_SHARE_TYPE = 1;
var FB_SHARE_REMOVE_TYPE = 2;
var FB_GET_FRIENDS_TYPE = 3;
var FB_INVITE_FRIEND_TYPE = 4;


var authWindow;
var messageListener;
var closeTimer;

var requestType;
var authResponse;
var userResponse;

// REQUESTS ENGINE
function getAccessUri(appId, redirectUri, permissions) {
	return "https://m.facebook.com/v2.2/dialog/oauth?client_id=" + appId + "&response_type=token&scope=" + permissions + "&redirect_uri=" + redirectUri;
}

function sendFacebookRequest(method, url, onSuccess, onError) {
	console.log("sendFacebookRequest...");
	var xhr = new XMLHttpRequest({mozSystem: true});
	console.log("xhr open");
	xhr.open(method, url, true);
	xhr.onreadystatechange = function () {
		console.log("xhr state changed: status=" + xhr.status + ", state=" + xhr.readyState);
		if (xhr.status === 200 && xhr.readyState === 4) {
			console.log("status = 200, ready state = DONE. response is:" + xhr.response);
			onSuccess(xhr.response);
		} else if (xhr.readyState === 4) {
			console.log("status=" + xhr.status + ", ready state = DONE. response is:" + xhr.response);
			onError(xhr.response);
		}
	};
	xhr.onerror = function () {
		console.log("error sending facebook request.");
		onError("error sending facebook request.");
	};
	console.log("xhr send");
	xhr.send();
}




function getUserRequest(accessToken, onSuccess, onError) {
	console.log("getUser");
	sendFacebookRequest(GET_METHOD, "https://graph.facebook.com/v2.2/me?access_token=" + accessToken, onSuccess, onError);
}

function shareRequest(url, accessToken, onSuccess, onError) {
	console.log("likein url: " + url);
	sendFacebookRequest(POST_METHOD, "https://graph.facebook.com/v2.2/" + SHARE_ACTION_URL + "?location=" + url + "&fb:explicitly_shared=true&access_token=" + accessToken, onSuccess, onError);
}

function shareRemoveRequest(postId, accessToken, onSuccess, onError) {
	console.log("postId: " + postId);
	sendFacebookRequest(DELETE_METHOD, "https://graph.facebook.com/v2.2/" + postId + "?access_token=" + accessToken, onSuccess, onError);
}





function setCloseTimer(authWindow, onError) {
	console.log("set close timer...");
	closeTimer = setInterval(
		function() {		
			console.log("check auth window...");	
			//console.dir(authWindow);
		    if (authWindow.closed) {
				console.log("auth window has been closed!");	
		    	clearInterval(closeTimer);
		    	if (messageListener) {
		    		window.removeEventListener('message', messageListener, false);
		    		messageListener = null;
		    	}
				onError("authentication window has been closed!");
		    }
		}, 500);
}

function openSession(permissions, onSuccess, onError) {
	console.log("opening session...");
	//clear();
	var accessUri = getAccessUri(APP_ID, REDIRECT_URI, permissions);
	
	console.log("opening auth window..." + accessUri);
	authWindow = origWindowOpen(accessUri);
	
	console.log("setting auth window close timer...");
	setCloseTimer(authWindow, onError);
	
	if (messageListener) {
		console.log("resetting messagelistener");
		window.removeEventListener('message', messageListener, false);
		messageListener = null;
	}
	
	messageListener = function(evt) {
		console.log("----> message received!");
		console.dir(evt);
		var accessToken = evt.data.access_token;
		var expiresIn = evt.data.expires_in;
		console.log("access token received:" + accessToken);
		console.log("expires in:" + expiresIn);
		if (closeTimer) {
			clearInterval(closeTimer);
		}
		window.removeEventListener('message', messageListener, false);
		getUserRequest(accessToken, 
				function(response) {
					console.log("getUser success!");
					//console.dir(response);
					var receivedUser = JSON.parse(response);
					var auth = {};
					auth.accessToken = accessToken;
					auth.expiresIn = expiresIn;
					auth.sessionKey = true;
					auth.userId = receivedUser.id;
					var user = {};
					user.birthday = receivedUser.birthday;
					user.email = receivedUser.email;
					user.username = receivedUser.username;
					user.id = receivedUser.id;
					user.firstname = receivedUser.first_name;
					user.middlename = receivedUser.middle_name;
					user.lastname = receivedUser.last_name;
					user.gender = receivedUser.gender;
					user.locale = receivedUser.locale.substring(0,1);
					user.pictureUrl = "http://graph.facebook.com/" + receivedUser.id + "/picture?type=large"
					
					var openSessionResult = {};
					openSessionResult.auth = auth;
					openSessionResult.user = user;
					console.log("open session result is:");
					console.dir(openSessionResult);
					//authWindow.close();
					onSuccess(openSessionResult);
				},
				function(error) {
					console.log("getUser error!");
					console.dir(error);
					onError("error retrieving connected user!");
				});
	};
	console.log("adding message listener...");
	window.addEventListener('message', messageListener, false);
	console.log("waiting for message...");
}





// IMPLEMENTATIONS
function register(onSuccess, onError) {
	console.log("starting facebook register/login...");
	openSession(
			READ_PERMISSIONS, 
			function(openSessionResult) {
				console.log("open session success. result is:")
				console.dir(openSessionResult);
				var registerResponse = {};
				registerResponse.authResponse = openSessionResult.auth;
				registerResponse.user = openSessionResult.user;
				onSuccess(JSON.stringify(registerResponse));
			}, 
			function(errorMessage) {
				onError(errorMessage);
			}
	);
}

function share(onSuccess, onError, args) {
	console.log("starting facebook share...");
	var url = args[0];
	var isEmulationEnabled = args[1];
	console.log("url=" + url + ", isEmulationEnabled=" + isEmulationEnabled);
	openSession(
			WRITE_PERMISSIONS, 
			function(openSessionResult) {
				console.log("open session success. result is:")
				console.dir(openSessionResult);
				var shareResponse = {};
				shareResponse.authResponse = openSessionResult.auth;
				shareResponse.userId = openSessionResult.user.id;
				if (isEmulationEnabled) {
					console.log("emulation enabled");
					shareResponse.postId = new Date().getTime();
					onSuccess(JSON.stringify(shareResponse));
				} else {
					console.log("do real share");
					shareRequest(
						url, 
						shareResponse.authResponse.accessToken, 
						function(response) {
							console.log("likein shared. response is=" + response);
							shareResponse.postId = JSON.parse(response).id;
							onSuccess(JSON.stringify(shareResponse));
						}, 
						function(error) {
							onError("error sharing open grapy story! error=" + error);
						}
					);
				}
			}, 
			function(errorMessage) {
				console.log("error sharing place: " + errorMessage);
				onError("error sharing place: " + errorMessage);
			}
	);
}

function shareRemove(onSuccess, onError, args) {
	console.log("starting facebook share remove...");
	var postIds = args[0];
	var isEmulationEnabled = args[1];
	console.log("postIds.length=" + postIds.length + ", isEmulationEnabled=" + isEmulationEnabled);
	console.log("posts to remove:");
	console.log(postIds);
	openSession(
			WRITE_PERMISSIONS, 
			function(openSessionResult) {
				console.log("open session success. result is:")
				console.dir(openSessionResult);
				if (isEmulationEnabled) {
					console.log("emulation enabled");
					onSuccess("true");
				} else {
					console.log("remove shares");
					if (postIds && postIds.length > 0) {
						for (i=0; i<postIds.length; i++) {
							console.log("remove share. postId=" + postIds[i] + ", accessToken=" + openSessionResult.auth.accessToken);
							shareRemoveRequest(
									postIds[i], 
									openSessionResult.auth.accessToken, 
									function(response) {
										console.log("post successfully removed");
									}, 
									function(error) {
										onError("error removing open grapy story! error=" + error);
									}
							);	
						}
						onSuccess("true");
					} else {
						onSuccess("true");
					}
				}
			}, 
			function(errorMessage) {
				console.log("error sharing place: " + errorMessage);
				onError("error sharing place: " + errorMessage);
			}
	);
}

function getFriends(onSuccess, onError, args) {
	console.log("starting facebook getFriends...");
	var key = args[0];
	onError("Developing...");
}

function inviteFriends(onSuccess, onError, args) {
	console.log("starting facebook invite friends...");
	var title = args[0];
	var message = args[1];
	var invitedUserId = args[2];
	var isEmulationEnabled = args[3];
	onError("Developing...");
}




var facebook = {
	    
		FBLoadingShow: function (onSuccess, onError, args) {
			onSuccess("");
	    },

		FBLoadingDismiss: function(onSuccess, onError, args) {
			onSuccess("");
		},
		
		FBRegister: function(onSuccess, onError, args) {
			register(onSuccess, onError);
		},
		
		FBShare: function(onSuccess, onError, args) {
			// TIMEOUT IS A WORKAROUND THAT ALLOW AUTH WINDOW TO OPEN AFTER SHARE CONFIRM DIALOG (WITHOUT THE TIMEOUT THE AUTH WINDOW IS NOT OPENING)
			setTimeout(function() {share(onSuccess, onError, args);}, 500);
		},

		FBShareRemove: function(onSuccess, onError, args) {
			// TIMEOUT IS A WORKAROUND THAT ALLOW AUTH WINDOW TO OPEN AFTER SHARE CONFIRM DIALOG (WITHOUT THE TIMEOUT THE AUTH WINDOW IS NOT OPENING)
			setTimeout(function() {shareRemove(onSuccess, onError, args);}, 500);
		},

		FBGetFriends: function(onSuccess, onError, args) {
			getFriends(onSuccess, onError, args);
		},

		FBInviteFriends: function(onSuccess, onError, args) {
			inviteFriends(onSuccess, onError, args);
		}

};

module.exports = facebook;
require('cordova/exec/proxy').add('FacebookPlugin', module.exports);


});
