cordova.define("org.apache.cordova.camera.CameraProxy", function(require, exports, module) { /*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

function takePicture(success, error, opts) {
	// ignore options, retrieve base64 data format image, with 0.75 jpeg compression  
	//console.dir(opts);
	//var quality = opts[0]/100;
	//console.log(quality);
	
    var pick = new MozActivity({
        name: "pick",
        data: {
            type: ["image/*"],
            nocrop: true
        }
    });

    pick.onerror = error || function() {};

    pick.onsuccess = function() {
    	console.log("pick image success..");
    	var img = new Image();
    	//console.log("loading base64 image");
        img.onload = function () {	
            var canvas = document.createElement("canvas");
            canvas.width =this.width;
            canvas.height =this.height;
            var ctx = canvas.getContext("2d");
            //ctx.drawImage(this, 0, 0, 100, 100 * this.height / this.width) // if RESIZE IS NEEDED
            ctx.drawImage(this, 0, 0);
            var dataURL = canvas.toDataURL("image/jpeg", 0.75);
            console.log("image loaded, data: ");
            console.log(dataURL);
            return success(dataURL.replace(/^data:image\/(jpeg);base64,/, ""));
        }
        img.src = window.URL.createObjectURL(this.result.blob);

    	/*
    	//THIS IS THE CURRENT PLUGIN VERSION: COMMENTED TO PERFORM BASE64 DATA RETRIEVAL OF IMAGE
    	// image is returned as Blob in this.result.blob
        // we need to call success with url or base64 encoded image
        if (opts && opts.destinationType == 0) {
            // TODO: base64
            return;
        }
        if (!opts || !opts.destinationType || opts.destinationType > 0) {
            // url
        	alert("loading url image");
            return success(window.URL.createObjectURL(this.result.blob));
        }
        */
    };
}

module.exports = {
    takePicture: takePicture,
    cleanup: function(){}
};

require("cordova/exec/proxy").add("Camera", module.exports);

});
