"use strict";angular.module("dinoplayerApp",["ui.bootstrap","pascalprecht.translate","angular-gestures"]).config(["$routeProvider",function(a){a.when("/",{templateUrl:"views/main.html",controller:"MainCtrl"}).when("/about",{templateUrl:"views/about.html",controller:"AboutCtrl"}).when("/howto",{templateUrl:"views/howto.html",controller:"HowtoCtrl"}).otherwise({redirectTo:"/"})}]).config(["$translateProvider",function(a){a.translations("en-US",{MENU:"Menu",PLAYLIST:"Playlist",ABOUT:"About",HOWTO:"How-to",SETTINGS:"Settings",SAVE:"Save",WARNING:"Warning!",WARNING_MSG:"If you haven't prepared your music folder yet, setup ",WARNING_MSG2:"!",MEDIAURL:"Media URL",SERVICE_SELECT:"Select your cloud storage: ",SERVICE_OTHER:"Other web storage",MEDIA_SELECT:"Add a music folder: ",HELP:"Help",HELP_PLAYPAUSE:"Play or pause current track",HELP_NEXTTRACK:"Change to next track",HELP_PREVIOUSTRACK:"Change to previous track",VERSION:"Version",INFORMATION:"Information",CREATEDBY:"Created by",CHANGELOG:"Changelog",LICENCE:"Licence",READMORE:"Read more",INSTRUCTION1:"Copy music into a public available folder (eg. Dropbox's Public folder)!",INSTRUCTION2:"Install DinoPlayer Helper!",INSTRUCTION3:"Select your music storage service in Settings! (Dropbox / Other service)",INSTRUCTION4:"Add your music folder (see examples below)!",INSTRUCTION5:"Save settings & enjoy the music!",EXAMPLE_DROPBOX:"If you use Dropbox to store your mp3 files you can use this option to set your music folder. You have to type only the music folder's ID and its path, these you can get from the folder's Public link. Example:",EXAMPLE_SERVICE_OTHER:"Set the public available link of your music folder where you store mp3 files and installed DinoPlayer Helper. Example:",MUSICFOLDER_EXAMPLES:"Music folder examples",ERROR_PLAYLIST_NOT_LOADED:"Playlist has not been loaded!",ERROR_BROWSER_NOT_SUPPORTED:"Browser not supported!",ERROR_CAN_NOT_CONNECT:"Error while connecting!",ERROR_PARSING_SETTINGS:"Error while parssing settings!",ERROR_NO_MEDIAURL:"Please add a music folder first!"});var b={MENU:"Menü",PLAYLIST:"Lejátszólista",ABOUT:"Információ",HOWTO:"How-to",SETTINGS:"Beállítások",SAVE:"Mentés",WARNING:"Figyelem!",WARNING_MSG:"Ha még nem készítetted elő a zenemappád, telepítsd a ",WARNING_MSG2:"-t!",MEDIAURL:"Média URL",SERVICE_SELECT:"Válaszd ki a tárhely szolgáltatód: ",SERVICE_OTHER:"Más webes tárhely",MEDIA_SELECT:"Add meg a mappa elérési útját: ",HELP:"Segítség",HELP_PLAYPAUSE:"Aktuális szám lejátszása vagy megállítása",HELP_NEXTTRACK:"Következő szám",HELP_PREVIOUSTRACK:"Előző szám",VERSION:"Verzió",INFORMATION:"Információ",CREATEDBY:"Készítette",CHANGELOG:"Changelog",LICENCE:"Licensz",READMORE:"Tudj meg többet",INSTRUCTION1:"Másolj zenét egy publikusan elérhető mappába (például Dropbox Publikus mappája)!",INSTRUCTION2:"Telepítsd a DinoPlayer Helper-t",INSTRUCTION3:"Válaszd ki a tárhely szolgáltatód a beállításokban (Dropbox / Más webes tárhely)!",INSTRUCTION4:"Add meg a mappa elérési útját (lásd a lenti példákat)!",INSTRUCTION5:"Mentsd el a beállításokat és élvezd a zenét!",EXAMPLE_DROPBOX:"Ha Dropbox-ot használsz zenéid tárolására, akkor válaszd ezt az opciót. Ebben az esetben csak a mappa Dropbox-os azonosítóját és az elérési útját kell megadni, amit a publikus linkből lehet megszerezni. Példa:",EXAMPLE_SERVICE_OTHER:"Ebben az esetben a publikusan elérhető zene mappa linkjét kell megadni, ahová a DinoPlayer-t is telepítetted. Példa:",MUSICFOLDER_EXAMPLES:"Zene mappa elérési út példák",ERROR_PLAYLIST_NOT_LOADED:"A lejátszólista még nem töltődött be!",ERROR_BROWSER_NOT_SUPPORTED:"Böngésző nem támogatott!",ERROR_CAN_NOT_CONNECT:"Hiba történt a csatlakozás során!",ERROR_PARSING_SETTINGS:"Hiba történt a beállítások olvasásánál!",ERROR_NO_MEDIAURL:"Kérlek adj hozzá először egy zenemappát!"};a.translations("hu",b),a.translations("hu-HU",b),a.preferredLanguage("hu-HU")}]);var utils=this.utils||{};utils.status=function(){function a(){null!==j&&(window.clearTimeout(j),j=null)}function b(b,c){if(a(),i.innerHTML="","string"==typeof b)i.textContent=b;else try{i.appendChild(b)}catch(e){console.error("DOMException: "+e.message)}h.classList.remove("hidden"),h.classList.add("onviewport"),j=window.setTimeout(d,c||k)}function c(b){var c="status-showed";"hide"===b.animationName&&(a(),h.classList.add("hidden"),c="status-hidden"),window.dispatchEvent(new CustomEvent(c))}function d(){h.classList.remove("onviewport")}function e(){h.removeEventListener("animationend",c),document.body.removeChild(h),a(),h=i=null}function f(){h=document.createElement("section"),h.setAttribute("role","status"),h.classList.add("hidden"),i=document.createElement("p"),h.appendChild(i),document.body.appendChild(h),h.addEventListener("animationend",c)}function g(){h||f()}var h,i,j,k=2e3;return"complete"===document.readyState?g():document.addEventListener("DOMContentLoaded",function l(){document.removeEventListener("DOMContentLoaded",l),g()}),{init:g,show:b,hide:d,destroy:e,setDuration:function(a){k=a||k}}}(),angular.module("dinoplayerApp").controller("MainCtrl",["$scope","$timeout","$rootScope","$translate","$http","$location",function(a,b,c,d,e,f){a.isSettingsVisible=!1,a.settingsOptions={backdropFade:!0,dialogFade:!0},c.goToPage=function(a){c.currentPage=a},c.$watch("currentPage",function(){f.path(c.currentPage).search("")},!0),a.init=function(){var b=window.navigator.userLanguage||window.navigator.language;try{d.uses(b)}catch(e){d.uses("en-US")}void 0===c.isPlaying&&(c.isPlaying=!1,c.$broadcast("controlchanged"));var f=function(){return Math.random().toString(36).substr(2)},g=function(){return f()+f()+f()+f()};void 0!==typeof Storage?(void 0===localStorage.dinoPlayerHash||null===localStorage.dinoPlayerHash)&&(localStorage.dinoPlayerHash=g()):utils.status.show(d("ERROR_BROWSER_NOT_SUPPORTED")),void 0===c.authHash&&(c.authHash=localStorage.dinoPlayerHash),void 0===c.requestCounter&&(c.requestCounter=0),void 0===c.repeatTrack&&(c.repeatTrack=!1),void 0===c.settings&&(c.settings=void 0!==localStorage.dinoPlayerSettings?JSON.parse(localStorage.dinoPlayerSettings):{mediaurl:""}),void 0!==localStorage.dinoPlayerPlaylist&&(c.playlist=JSON.parse(localStorage.dinoPlayerPlaylist),c.isLoaded=!0),c.isLoaded||void 0===c.settings.mediaurl||null===c.settings.mediaurl||a.getPlaylist()},a.initPlayer=function(){c.trackSwitchedTo>-1&&(a.playTrack(c.trackSwitchedTo),c.trackSwitchedTo=-1,c.isControlVisible=0)},a.$on("nosuchvalue",function(){b(a.detailsLoaded,4e3).then(null)}),a.getPlaylist=function(){c.requestCounter++;var b={serviceurl:c.settings.serviceurl,mediaurl:c.settings.mediaurl},f="http://dinoplayer.herokuapp.com/getTrackList?callback=JSON_CALLBACK&"+$.param(b);e.jsonp(f).success(function(b){c.requestCounter--,c.playlist=new Array;for(var d=0;d<b.length;d++){var e={filename:b[d]};c.playlist.push(e)}c.trackCounter=0,c.detailsFetched=!1,a.getTrack(),c.isLoaded=!0}).error(function(){c.requestCounter--,utils.status.show(d("ERROR_CAN_NOT_CONNECT"))})},a.reloadPlaylist=function(){c.isPlaying&&c.playPause(),""===c.settings.mediaurl?utils.status.show(d("ERROR_NO_MEDIAURL")):a.getPlaylist()},c.playPause=function(){return c.isLoaded?(c.isPlaying?(c.audio.pause(),c.isPlaying=!1,c.$broadcast("controlchanged")):(a.getTrackIframe(c.playlist[c.trackCounter].filename),c.audio.play(),c.isPlaying=!0,c.$broadcast("controlchanged")),void 0):(utils.status.show(d("ERROR_PLAYLIST_NOT_LOADED")),void 0)},a.getTrack=function(){c.audio=new Audio,c.audio.setAttribute("src",c.settings.serviceurl+c.settings.mediaurl+c.playlist[c.trackCounter].filename),c.audio.setAttribute("preload","auto"),c.progressBar=[0,0],c.audio.addEventListener("timeupdate",function(){c.playlist[c.trackCounter].currentTime=c.audio.currentTime;var b=parseInt(100*(c.audio.currentTime/c.audio.duration));c.progressBar[0]=b;var d=c.progressBar[1];d+b>100&&(c.progressBar[1]=100-b),a.$apply()},!1),c.audio.addEventListener("loadedmetadata",function(){c.playlist[c.trackCounter].length=c.audio.duration,localStorage.dinoPlayerPlaylist=JSON.stringify(c.playlist),a.$apply()},!1),c.audio.addEventListener("progress",function(){var a=parseInt(100*(c.audio.buffered.end(c.audio.buffered.length-1)/c.audio.duration)),b=c.progressBar[0];a-b>100?a=100-b:a-=b,c.progressBar[1]=a},!1),c.audio.addEventListener("ended",function(){c.repeatTrack?a.playTrack(c.trackCounter):c.trackCounter==c.playlist.length-1?(c.audio.pause(),c.isPlaying=!1,c.$broadcast("controlchanged")):a.nextTrack()},!1)},a.getTrackIframe=function(a){var b=document.getElementById("detailsIframe");b.src=c.settings.serviceurl+c.settings.mediaurl+"index.html?type=track&hash="+c.authHash+"&name="+a},a.getTrackDetails=function(b){if(void 0!=b.errors&&b.errors.length>0&&!c.detailsFetched)a.$emit("nosuchvalue","error");else if(c.detailsFetched||c.playlist[c.trackCounter].filename!=b.filename)a.$emit("nosuchvalue","error");else{c.playlist[c.trackCounter].details=b,c.detailsFetched=!0,c.requestCounter++;var f={artist:c.playlist[c.trackCounter].details.artist,album:c.playlist[c.trackCounter].details.album},g="http://dinoplayer.herokuapp.com/getTrackCover?callback=JSON_CALLBACK&"+$.param(f);e.jsonp(g).success(function(b){c.requestCounter--,a.getCover(b)}).error(function(){c.requestCounter--,utils.status.show(d("ERROR_CAN_NOT_CONNECT"))})}},a.detailsLoaded=function(){if(c.isLoaded&&void 0!=c.isLoaded&&!c.detailsFetched){c.requestCounter++;var b={hash:c.authHash},f="http://dinoplayer.herokuapp.com/getTrackDetails?callback=JSON_CALLBACK&"+$.param(b);e.jsonp(f).success(function(b){c.requestCounter--,a.getTrackDetails(b)}).error(function(){c.requestCounter--,utils.status.show(d("ERROR_CAN_NOT_CONNECT"))})}},a.getCover=function(a){if(void 0!=a.album&&void 0!=a.album.image){var b=a.album.image[a.album.image.length-1];c.playlist[c.trackCounter].cover=b["#text"]}},a.backToPlayer=function(a){c.trackSwitchedTo=a},a.showControl=function(){"about"!=c.currentPage&&"howto"!=c.currentPage&&(void 0==c.isControlVisible||0==c.isControlVisible?(c.isControlVisible=1,$("#overlayController").fadeIn("fast"),a.timeoutId=b(function(){$("#overlayController").fadeOut("fast"),c.isControlVisible=0},4e3)):1==c.isControlVisible?($("#overlayController").fadeOut("fast"),c.isControlVisible=0):(b.cancel(a.timeoutId),c.isControlVisible=1,b(function(){$("#overlayController").fadeOut("fast"),c.isControlVisible=0},3e3)))},a.playTrack=function(b){var d=!1;c.isPlaying&&(c.audio.pause(),c.isPlaying=!1,c.$broadcast("controlchanged"),d=!0),c.trackCounter=b,void 0==c.playlist[c.trackCounter].details&&(c.detailsFetched=!1,a.getTrackIframe(c.playlist[c.trackCounter].filename),a.detailsLoaded()),a.getTrack(),d&&(c.audio.play(),c.isPlaying=!0,c.$broadcast("controlchanged"))},a.previousTrack=function(){c.trackCounter>0&&(c.trackCounter--,a.playTrack(c.trackCounter))},a.nextTrack=function(){c.trackCounter<c.playlist.length-1&&(c.trackCounter++,a.playTrack(c.trackCounter))},a.toggleRepeat=function(){c.repeatTrack=!c.repeatTrack},a.openSettings=function(){a.lastSettings=JSON.stringify(c.settings),void 0===localStorage.dinoPlayerSettings&&(localStorage.dinoPlayerSettings=JSON.stringify(c.settings));try{c.settings=JSON.parse(localStorage.dinoPlayerSettings)}catch(b){utils.status.show(d("ERROR_PARSING_SETTINGS"))}a.isSettingsVisible=!0},a.closeSettings=function(b){if(a.isSettingsVisible=!1,b)if(a.lastSettings!=JSON.stringify(c.settings))"/"!=c.settings.mediaurl[c.settings.mediaurl.length-1]&&(c.settings.mediaurl+="/"),localStorage.dinoPlayerSettings=JSON.stringify(c.settings),c.isLoaded=!1,a.getPlaylist();else try{c.settings=JSON.parse(a.lastSettings)}catch(e){utils.status.show(d("ERROR_PARSING_SETTINGS"))}},a.setService=function(a){switch(c.settings.service=a,c.settings.mediaurl="",a){case"dropbox":c.settings.serviceurl="https://dl.dropboxusercontent.com/u/";break;case"other":c.settings.serviceurl=""}}}]),angular.module("dinoplayerApp").filter("timeFilter",function(){return function(a){if(void 0==a||null==a)return"00:00";var b=parseInt(parseInt(a)/60%60),c=parseInt(parseInt(a)%60);return 10>b&&(b="0"+b),10>c&&(c="0"+c),b+":"+c}}),angular.module("dinoplayerApp").directive("myFrame",function(){return{link:function(a,b,c){b.bind("load",function(){a.$apply(c.myFrame)})}}}),angular.module("dinoplayerApp").directive("overlayController",["$timeout","$rootScope",function(a,b){return{restrict:"E",template:'<span class="overlay"><span class="overlaycontrol" ng-switch="isPlaying"><img ng-switch-when="true" src="images/pause.png" ng-click="playPause()"><img ng-switch-default src="images/play.png" ng-click="playPause()"></span></span>',link:function(a){a.$on("controlchanged",function(){a.isPlaying=b.isPlaying}),a.playPause=function(){b.isControlVisible=-1,b.playPause(),a.isPlaying=b.isPlaying}}}}]),angular.module("dinoplayerApp").directive("details",function(){return{scope:{track:"=track"},replace:!0,restrict:"E",template:'<div ng-switch="track.details"><span ng-switch-when="undefined"><strong>{{track.filename}}</strong></span><span ng-switch-default><p>{{track.details.artist | titleFilter}} - {{track.details.album | titleFilter}}</p><strong>{{track.details.title | titleFilter}}</strong></span></div>'}}),angular.module("dinoplayerApp").filter("titleFilter",function(){return function(a){return String.prototype.capitalize=function(){return this.replace(/(?:^|\s)\S/g,function(a){return a.toUpperCase()})},a.capitalize()}});