function calculatePercentage(value, percent) {
	return value * percent / 100;
}

function calculatePercentageForResultPanel() {
	var amountInput = $('#amount_input');
	var percentInput = $('#percent_input');
	var taxInput = $('#tax_input');
	var resultPanel = $('#result_panel');
	var includeTax = $('#checkbox_include_tax');

	var amount = amountInput.val();
	if(amount == null || amount == "") {
		amount = 0;
	}

	var percentOff = percentInput.val();
	if(percentOff == null || percentOff == "") {
		percentOff = 0;
	}

	var tax = taxInput.val();
	if(tax == null || tax == "") {
		tax = 0;
	}

	var amountOff = parseFloat(amount) * parseFloat(percentOff) / 100;
	var finalValue = parseFloat(amount) - amountOff;

	if(includeTax.is(':checked')) {
		finalValue = finalValue * (1 + parseFloat(tax)/100);
	}

	finalValue = finalValue.toFixed(2)
	resultPanel.html(finalValue);
}

function clearInputs() {
	$('#amount_input').val('');
	$('#percent_input').val('');
	$('#tax_input').val('');
	$('#result_panel').html('Result');
}

$(document).ready(function(){	
	$('#amount_input').keyup(function(){
		calculatePercentageForResultPanel();
	});

	$('#percent_input').keyup(function(){
		calculatePercentageForResultPanel();
	});

	$('#checkbox_include_tax').change(function(){
		calculatePercentageForResultPanel();
	});

	$('#tax_input').keyup(function(){
		calculatePercentageForResultPanel();
	});


	$('#action_clear').click(function(){
		clearInputs();
	});
});