/*
 * Google Maps documentation: http://code.google.com/apis/maps/documentation/javascript/basics.html
 * Geolocation documentation: http://dev.w3.org/geo/api/spec-source.html
 */
$(document).on("pageinit", "#map-page", function() {
    //var defaultLatLng = new google.maps.LatLng(23.7, 90.375);  // Default to Hollywood, CA when no geolocation support
    var loc = (localStorage.spotmap).split(",");
    var defaultLatLng = new google.maps.LatLng(loc[0], loc[1]);
    drawMap(defaultLatLng);

    function drawMap(latlng) {
        var myOptions = {
            zoom: 15,
            center: latlng,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        };
        var map = new google.maps.Map(document.getElementById("map-canvas"), myOptions);
        // Add an overlay to the map of current lat/lng
        var marker = new google.maps.Marker({
            position: latlng,
            map: map,
            title: localStorage.spotname
        });
    }
});