document.addEventListener('deviceready', initApp, false);

function initApp() {
    var myApp = new Framework7({
        smartSelectBackOnSelect: true
    });

    var $$ = Dom7;

    var mainView = myApp.addView('.view-main', {
        dynamicNavbar: true
    });

    var lang = 'en';

    var year = ['all'];
    var type = 'movie';
    var genre = 'all';
    var quality = 2;
    var point = 7;
    var country = 'all';

    var count = 0;

    navigator.globalization.getLocaleName(
        function (locale) {
            if (localStorage.lang) {
                if(typeof(Storage) !== "undefined") {
                    lang = localStorage.lang;
                }
            }else{
                locale = locale.value;
                if (locale == 'EN' || locale == 'en' || locale == 'en-US' || locale == 'en-GB' || locale == 'en-us' || locale == 'en-gb' || locale == 'en-au'|| locale == 'en-ca'|| locale == 'en-nz'|| locale == 'en-ie'|| locale == 'en-za'|| locale == 'en-jm'|| locale == 'en-bz'|| locale == 'en-tt' || locale == 'en-AU'|| locale == 'en-CA'|| locale == 'en-NZ'|| locale == 'en-IE'|| locale == 'en-ZA'|| locale == 'en-JM'|| locale == 'en-BZ'|| locale == 'en-TT'){
                    lang = 'en';
                }else if (locale == 'ru' || locale == 'RU' || locale == 'ru-RU' || locale == 'ru-ru' || locale == 'ru-mo'|| locale == 'ru-MO'){
                    lang = 'ru';
                }else if (locale == 'it' || locale == 'IT'|| locale == 'it-ch'|| locale == 'it-CH'){
                    lang = 'it';
                }else if (locale == 'fr' || locale == 'FR'|| locale == 'fr-be'|| locale == 'fr-fr'|| locale == 'fr-ch'|| locale == 'fr-lu'|| locale == 'fr-ca'|| locale == 'fr-BE'|| locale == 'fr-FR'|| locale == 'fr-CH'|| locale == 'fr-LU'|| locale == 'fr-CA'){
                    lang = 'fr';
                }else if (locale == 'da' || locale == 'DA' || locale == 'da-da' || locale == 'da-DA'){
                    lang = 'da';
                }else if (locale == 'de' || locale == 'DE'|| locale == 'de-ch'|| locale == 'de-CH'|| locale == 'de-LU'|| locale == 'de-lu'|| locale == 'de-at'|| locale == 'de-AT'|| locale == 'de-LI'|| locale == 'de-li'){
                    lang = 'de';
                }else if (locale == 'es' || locale == 'ES'|| locale == 'es-es' || locale == 'es-ES'|| locale == 'es-mx' || locale == 'es-MX'){
                    lang = 'es';
                }else if (locale == 'fil' || locale == 'FIL' || locale == 'phi' || locale == 'ph'){
                    lang = 'fil';
                }else if (locale == 'pt' || locale == 'PT' || locale == 'pt-br' || locale == 'pt-BR'){
                    lang = 'pt';
                }else if (locale == 'jp' || locale == 'JP' || locale == 'ja' || locale == 'JA' || locale == 'jp-jp' || locale == 'jp-JP' || locale == 'ja-jp' || locale == 'ja-JP'){
                    lang = 'jp';
                }else if (locale == 'tr' || locale == 'TR' || locale == 'tr-tr' || locale == 'tr-TR'){
                    lang = 'tr';
                } else {
                    lang = 'en';
                }

                if(typeof(Storage) !== "undefined") {
                    localStorage.setItem("lang", lang);
                }
            }
        },
        function () {
            lang = 'en';
        }
    );

    var index = myApp.onPageInit('index', function (page) {

        if(mainView.activePage.name == 'languages' || mainView.activePage.name == 'settings' ){
            AdMob.showBanner(AdMob.AD_POSITION.BOTTOM_CENTER);
        }else{
            AdMob.hideBanner();
        }

        if(typeof(Storage) !== "undefined") {
            if (localStorage.lang) {
                lang = localStorage.lang
            }
        }

        $$('.home-button').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/settings.html");
        });

        $$('.settings-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/settings.html");
        });

        $$('.languages-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/languages.html");
        });

    }).trigger();

    var languages = myApp.onPageInit('languages', function (page) {

        if(mainView.activePage.name == 'index' || mainView.activePage.name == 'discover' ){
            AdMob.hideBanner();
        }else{
            AdMob.showBanner(AdMob.AD_POSITION.BOTTOM_CENTER);
        }

        $$('.settings-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/settings.html");
        });

        $$('.languages-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/languages.html");
        });

        $$('.button-lang-save').on('click', function (e) {
            var formData = myApp.formToJSON('#lang-form');
            lang = formData.lang;

            if(typeof(Storage) !== "undefined") {
                localStorage.setItem("lang", lang);
            }

            mainView.router.loadPage('lang/'+ formData.lang + "/discover.html");
        });

    });

    var discover = myApp.onPageInit('discover', function (page) {

        if(mainView.activePage.name == 'languages' || mainView.activePage.name == 'settings' ){
            AdMob.showBanner(AdMob.AD_POSITION.BOTTOM_CENTER);
        }else{
            AdMob.hideBanner();
        }

        var checkAd = function () {
            if (count > 3) {
                if(AdMob && interstitialIsReady) AdMob.showInterstitial();
                count = 0;
            }
        };

        $$('.settings-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/settings.html");
        });

        $$('.languages-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/languages.html");
        });

        if ($$('.discover-title').length) {
        }else{
            $$.post('http://izlenilesi.com/api/v1/recommended-movie', {year:year,point:point,quality:quality,type:type,genre:genre,country:country}, function (data) {
                $$('.movie').html(data);
                count = count + 1;
                checkAd();
            });
        }

        var onShake = function () {
            $$('.movie').html(' <img src="img/loading-bubbles.svg"class="buble"/>');

            $$.post('http://izlenilesi.com/api/v1/recommended-movie', {year:year,point:point,quality:quality,type:type,genre:genre,country:country}, function (data) {
                setTimeout(function(){
                    $$('.movie').html(data);
                    count = count + 1;
                    checkAd();
                }, 500);
            });
        };

        shake.startWatch(onShake);

        $$(document).on('delete', '.swipeout', function () {
            $$('.movie').html(' <img src="img/loading-bubbles.svg"class="buble"/>');

            $$.post('http://izlenilesi.com/api/v1/recommended-movie', {year:year,point:point,quality:quality,type:type,genre:genre,country:country}, function (data) {
                $$('.movie').html(data);
                count = count + 1;
                checkAd();
            });
        });

        $$('.button-nope').on('click', function (e) {
            $$('.movie').html(' <img src="img/loading-bubbles.svg"class="buble"/>');
            $$.post('http://izlenilesi.com/api/v1/recommended-movie', {year:year,point:point,quality:quality,type:type,genre:genre,country:country}, function (data) {
                $$('.movie').html(data);
                count = count + 1;
                checkAd();
            });
        });
    });

    var settings = myApp.onPageInit('settings', function (page) {
        if(mainView.activePage.name == 'index' || mainView.activePage.name == 'discover' ){
            AdMob.hideBanner();
        }else{
            AdMob.showBanner(AdMob.AD_POSITION.BOTTOM_CENTER);
        }

        $$('.settings-link').on('click', function (e) {
            mainView.router.loadPage('lang/'+ lang + "/settings.html");
        });

        $$('.languages-link').on('click', function (e) {
            mainView.router.loadPage('lang/' + lang + "/languages.html");
        });

        $$('.button-save').on('click', function (e) {
            var formData = myApp.formToJSON('#my-form');
            year = formData.year;
            type = formData.type;
            genre = formData.genre;
            quality = formData.quality;
            point = formData.point;
            country = formData.country;
            mainView.router.loadPage('lang/'+ lang + "/discover.html");
        });
    });

    myApp.init();

    document.addEventListener("backbutton", function(e){
        if (mainView.activePage.name == 'index') {
            navigator.app.exitApp();
        } else{
            mainView.router.back();
        }
    }, false);
}