
function entityCollision(o,m) 
{
	if (!o.visible || m.dead || m.dying > 0 || o.dying > 0 || g.pausemode > 0) return;

	var ox = o.x;
	var oy = o.y;
	var ow = o.w; 
	var oh = o.h; 

	var mx = m.x;
	var my = m.y;
	var mw = m.w;
	var mh = m.h;

	var c1 = false, c2 = false, c3 = false, c4 = false;
	
	if (ox <= (mx+mw)  &&  oy <= (my+mh)  &&  ox >= (mx)  && oy >= my) c1 = true;
	if ((ox+ow) >= mx  &&  oy >= my  &&  (ox+ow) <= (mx+mw)  &&  oy <= (my+mh)) c2 = true;
	if (ox <= (mx+mw)  &&  (oy+oh) >= my  &&  ox >= mx  &&  (oy+oh) <= (my+mh)) c3 = true;
	if (((ox + ow) >= mx) && ((ox + ow) <= (mx + mw)) && ((oy + oh) >= my) && ((oy + oh) <= (my + mh))) c4 = true; 

	if (c1 === true || c2 === true || c3 === true || c4 === true)
	{
		switch(o.row) // Which entity ?
		{
			default:
				break;
		}
	}
};

function playerObstacleCollision(o,m) 
{
	if (!o.visible || m.dying > 0 || g.pausemode > 0 || NOCOLLISION|| m.retiring || g.towerfalling || o.distance < 35 || o.distance >= 44) return;

	var ox = o.x;
	var oy = o.y;
	var ow = o.w; 
	var oh = o.h; 

	var mx = m.x;
	var my = m.y;
	var mw = m.w;
	var mh = m.h;

	var t = 0; 

	var c1 = false, c2 = false, c3 = false, c4 = false;
	
	if (ox <= (mx+(mw-t))  &&  oy <= (my+(mh-t))  &&  ox >= (mx+t)  && oy >= (my+t)) c1 = true;
	if ((ox+ow) >= (mx+t)  &&  oy >= (my+t)  &&  (ox+ow) <= (mx+(mw-t))  &&  oy <= (my+(mh-t))) c2 = true;
	if (ox <= (mx+(mw-t))  &&  (oy+oh) >= (my+t)  &&  ox >= (mx+t)  &&  (oy+oh) <= (my+(mh-t))) c3 = true;
	if (((ox + ow) >= (mx+t)) && ((ox + ow) <= (mx + (mw-t))) && ((oy + oh) >= (my+t)) && ((oy + oh) <= (my + (mh-t)))) c4 = true; 

	if (c1 == true || c2 == true || c3 == true || c4 == true)
	{
		write(o.type + " = " + o.distance);
		playerDamage(1,o);
		kill(o);
	}
};

function missileTowerCollision(o) 
{
	try
	{
		if (!o.visible || g.pausemode > 0 || NOCOLLISION || !g.towerinrange || m.player.dying) return;

		var ox = o.x;
		var oy = o.y;
		var ow = o.w; 
		var oh = o.h; 

		if (o.y <= g.horizon && o.x > (g.textcentre - (g.towerwidth/2)) && o.x < (g.textcentre + (g.towerwidth/2)))
		{
			spawnTowerExplosion(o.x,o.y-8);
			kill(o);
			g.towerhp -= 1;
			g.towerpain = 2;
			checkTower();
		}
		
	}
	catch (e)
	{
		write("Missile tower collision: " + e.message);
	}
};

function checkTower()
{
	if (g.towerhp <= 0)
	{
		if (!g.towerfalling)
		{
			var dd = new Date();
			g.leveltime = Math.round((dd - g.leveltime) / 1000);
		}
		g.towerfalling = true;
		g.resetting = 0;
	}
};

function alienMissileCollision(o) 
{
	try
	{
		if (!o.visible || g.pausemode > 0 || NOCOLLISION) { return; }

		var ox = o.x;
		var oy = o.y;
		var ow = o.w; 
		var oh = o.h; 

		for (var z=0;z<m.aliens.length;z++)
		{
			var a = m.aliens[z];
			if (a.visible && o.distance < 25)
			{
				var mx = a.x;
				var my = a.y;
				var mw = a.w;
				var mh = a.h;

				var c1 = false, c2 = false, c3 = false, c4 = false;
				
				if (ox <= (mx+mw)  &&  oy <= (my+mh)  &&  ox >= (mx)  && oy >= my) c1 = true;
				if ((ox+ow) >= mx  &&  oy >= my  &&  (ox+ow) <= (mx+mw)  &&  oy <= (my+mh)) c2 = true;
				if (ox <= (mx+mw)  &&  (oy+oh) >= my  &&  ox >= mx  &&  (oy+oh) <= (my+mh)) c3 = true;
				if (((ox + ow) >= mx) && ((ox + ow) <= (mx + mw)) && ((oy + oh) >= my) && ((oy + oh) <= (my + mh))) c4 = true; 

				if (c1 === true || c2 === true || c3 === true || c4 === true)
				{
					a.hp -= o.damage;
					if (a.hp < 1)
					{
						alienKill(a);
						kill(a);
						//kill(a.shadow);
						m.player.targetscore += 25;
						spawnCoin(a,0);
					}
					kill(o);
				}
			}
		}
	}
	catch (e)
	{
		write("Alien missile collision: " + e.message);
	}
};

function saucerMissileCollision(o) 
{
	try
	{
		if (!o.visible || g.pausemode > 0 || NOCOLLISION) return;

		var ox = o.x;
		var oy = o.y;
		var ow = o.w; 
		var oh = o.h; 

		for (var z=0;z<m.saucers.length;z++)
		{
			var a = m.saucers[z];
			if (a.visible)
			{
				var mx = a.x;
				var my = a.y;
				var mw = a.w;
				var mh = a.h;

				var c1 = false, c2 = false, c3 = false, c4 = false;
				
				if (ox <= (mx+mw)  &&  oy <= (my+mh)  &&  ox >= (mx)  && oy >= my) c1 = true;
				if ((ox+ow) >= mx  &&  oy >= my  &&  (ox+ow) <= (mx+mw)  &&  oy <= (my+mh)) c2 = true;
				if (ox <= (mx+mw)  &&  (oy+oh) >= my  &&  ox >= mx  &&  (oy+oh) <= (my+mh)) c3 = true;
				if (((ox + ow) >= mx) && ((ox + ow) <= (mx + mw)) && ((oy + oh) >= my) && ((oy + oh) <= (my + mh))) c4 = true; 

				if (c1 === true || c2 === true || c3 === true || c4 === true)
				{
					a.hp -= o.damage;
					a.inpain = true;
					if (a.hp < 1)
					{
						alienKill(a);
						kill(a);
						m.player.targetscore += 50;
						m.player.targetcredits += Math.round(g.saucerBonus[a.row]);
						spawnTextSprite(a,g.saucerBonus[a.row] + "" + textdata[16]);
					}
					kill(o);
				}
			}
		}
	}
	catch (e)
	{
		write("Saucer missile collision: " + e.message);
	}
};

function probeMissileCollision(o) 
{
	try
	{
		if (!o.visible || g.pausemode > 0 || NOCOLLISION) return;

		var ox = o.x;
		var oy = o.y;
		var ow = o.w; 
		var oh = o.h; 

		for (var z=0;z<m.probes.length;z++)
		{
			var a = m.probes[z];
			if (a.visible)
			{
				var mx = a.x;
				var my = a.y;
				var mw = a.w;
				var mh = a.h;

				var c1 = false, c2 = false, c3 = false, c4 = false;
				
				if (ox <= (mx+mw)  &&  oy <= (my+mh)  &&  ox >= (mx)  && oy >= my) c1 = true;
				if ((ox+ow) >= mx  &&  oy >= my  &&  (ox+ow) <= (mx+mw)  &&  oy <= (my+mh)) c2 = true;
				if (ox <= (mx+mw)  &&  (oy+oh) >= my  &&  ox >= mx  &&  (oy+oh) <= (my+mh)) c3 = true;
				if (((ox + ow) >= mx) && ((ox + ow) <= (mx + mw)) && ((oy + oh) >= my) && ((oy + oh) <= (my + mh))) c4 = true; 

				if (c1 === true || c2 === true || c3 === true || c4 === true)
				{
					a.hp -= o.damage;
					a.inpain = true;
					if (a.hp < 1)
					{
						alienKill(a);
						kill(a);
						m.player.targetscore += 50;
						m.player.targetcredits += Math.round(10);
						spawnTextSprite(a,"10" + textdata[16]);
						spawnBombBlast(a,rnd(5) * (rnd(10) < 5 ? -1 : 1),g.towerinrange ? 4 : 3);
					}
					kill(o);
				}
			}
		}
	}
	catch (e)
	{
		write("Probe missile collision: " + e.message);
	}
};

function obstacleMissileCollision(o) 
{
	if (!o.visible || g.pausemode > 0 || NOCOLLISION) return;

	var ox = o.x;
	var oy = o.y;
	var ow = o.w; 
	var oh = o.h; 

	for (var z=0;z<m.obstacles.length;z++)
	{
		var a = m.obstacles[z];
		if (a.visible && a.distance > 20 && o.distance < 30)
		{
			var mx = a.x;
			var my = a.y;
			var mw = a.w;
			var mh = a.h;

			var c1 = false, c2 = false, c3 = false, c4 = false;
			
			if (ox <= (mx+mw)  &&  oy <= (my+mh)  &&  ox >= (mx)  && oy >= my) c1 = true;
			if ((ox+ow) >= mx  &&  oy >= my  &&  (ox+ow) <= (mx+mw)  &&  oy <= (my+mh)) c2 = true;
			if (ox <= (mx+mw)  &&  (oy+oh) >= my  &&  ox >= mx  &&  (oy+oh) <= (my+mh)) c3 = true;
			if (((ox + ow) >= mx) && ((ox + ow) <= (mx + mw)) && ((oy + oh) >= my) && ((oy + oh) <= (my + mh))) c4 = true; 

			if (c1 === true || c2 === true || c3 === true || c4 === true)
			{
				a.hp -= o.damage;
				a.inpain = true;
				if (a.hp < 1)
				{
					spawnObstacleExplosionXY(a.x,a.y-16,0,1,a);
					spawnObstacleExplosionXY(a.x,a.y+16,0,1,a);
					spawnObstacleExplosionXY(a.x,a.y+48,0,1,a);
					kill(a);
					g.energytowers --;
					if (g.energytowers < 1)
					{
						g.towerdefense = false;
					}
					m.player.targetscore += 50;
					m.player.turrets += 1;
				} else {
					spawnObstacleExplosionXY(a.x,a.y+16,0,1,a);
				}
				kill(o);
			}
		}
	}
};

function missileAlienBombCollision(o) 
{
	if (!o.visible || g.pausemode > 0 || NOCOLLISION || m.player.maxlasers != 3) return;

	var ox = o.x;
	var oy = o.y;
	var ow = o.w; 
	var oh = o.h; 

	for (var z=0;z<m.alienbomb.length;z++)
	{
		var a = m.alienbomb[z];
		if (a.visible)
		{
			var mx = a.x;
			var my = a.y;
			var mw = a.w;
			var mh = a.h;

			var c1 = false, c2 = false, c3 = false, c4 = false;
			
			if (ox <= (mx+mw)  &&  oy <= (my+mh)  &&  ox >= (mx)  && oy >= my) c1 = true;
			if ((ox+ow) >= mx  &&  oy >= my  &&  (ox+ow) <= (mx+mw)  &&  oy <= (my+mh)) c2 = true;
			if (ox <= (mx+mw)  &&  (oy+oh) >= my  &&  ox >= mx  &&  (oy+oh) <= (my+mh)) c3 = true;
			if (((ox + ow) >= mx) && ((ox + ow) <= (mx + mw)) && ((oy + oh) >= my) && ((oy + oh) <= (my + mh))) c4 = true; 

			if (c1 === true || c2 === true || c3 === true || c4 === true)
			{
				a.hp -= 1;
				if (a.hp < 1)
				{
					alienKill(a);
					kill(a);
				}
				kill(o);
			}
		}
	}
};

function alienBombCollision(o,m) 
{
	if (!o.visible || !m.visible || m.dead || m.dying > 0 || o.dying > 0|| m.retiring || g.pausemode > 0 || g.towerfalling) return;

	var ox = o.x;
	var oy = o.y;
	var ow = o.w; 
	var oh = o.h; 

	var mx = m.x;
	var my = m.y;
	var mw = m.w;
	var mh = m.h;

	var t = 8; // attempt to set a threshold a la manic shooter tiny boxes.

	var c1 = false, c2 = false, c3 = false, c4 = false;
	
	if (ox <= (mx+(mw-t))  &&  oy <= (my+(mh-t))  &&  ox >= (mx+t)  && oy >= (my+t)) c1 = true;
	if ((ox+ow) >= (mx+t)  &&  oy >= (my+t)  &&  (ox+ow) <= (mx+(mw-t))  &&  oy <= (my+(mh-t))) c2 = true;
	if (ox <= (mx+(mw-t))  &&  (oy+oh) >= (my+t)  &&  ox >= (mx+t)  &&  (oy+oh) <= (my+(mh-t))) c3 = true;
	if (((ox + ow) >= (mx+t)) && ((ox + ow) <= (mx + (mw-t))) && ((oy + oh) >= (my+t)) && ((oy + oh) <= (my + (mh-t)))) c4 = true; 

	if (c1 === true || c2 === true || c3 === true || c4 === true)
	{
		kill(o);
		playerDamage(1,o);
	}
};

function coinCollision(o,m) 
{
	if (!o.visible || !m.visible || m.dead || m.dying > 0 || o.dying > 0|| m.retiring || g.pausemode > 0 || g.towerfalling) return;

	var ox = o.x;
	var oy = o.y;
	var ow = o.w; 
	var oh = o.h; 

	var mx = m.x;
	var my = m.y;
	var mw = m.w;
	var mh = m.h;

	var t = 8; // attempt to set a threshold a la manic shooter tiny boxes.

	var c1 = false, c2 = false, c3 = false, c4 = false;
	
	if (ox <= (mx+(mw-t))  &&  oy <= (my+(mh-t))  &&  ox >= (mx+t)  && oy >= (my+t)) c1 = true;
	if ((ox+ow) >= (mx+t)  &&  oy >= (my+t)  &&  (ox+ow) <= (mx+(mw-t))  &&  oy <= (my+(mh-t))) c2 = true;
	if (ox <= (mx+(mw-t))  &&  (oy+oh) >= (my+t)  &&  ox >= (mx+t)  &&  (oy+oh) <= (my+(mh-t))) c3 = true;
	if (((ox + ow) >= (mx+t)) && ((ox + ow) <= (mx + (mw-t))) && ((oy + oh) >= (my+t)) && ((oy + oh) <= (my + (mh-t)))) c4 = true; 

	if (c1 === true || c2 === true || c3 === true || c4 === true)
	{
		kill(o);
		switch (o.row)
		{
			case 0:
			case 1:
			case 2:
				var r = Math.round((o.row + 1) * 5);
				m.targetcredits += r;
				spawnTextSprite(m,r + "" + textdata[16]);
				break;
			case 3:
				bombBlast();
				var r = Math.round(15);
				m.targetcredits += r;
				spawnTextSprite(m,r + "" + textdata[16]);
				break;
			case 4:
				if (g.towerinrange)
				{
					g.towerhp -= 10 * (g.planetstage + 1);
					g.towerpain = 4;
					checkTower();
				}
				var r = Math.round(15);
				m.targetcredits += r;
				spawnTextSprite(m,r + "" + textdata[16]);
				break;
		}
	}
};

function alienPlayerCollision(o,m) 
{
	try
	{
		if (!o.visible || !m.visible || m.dead || m.dying > 0 || o.dying > 0 || m.retiring || g.pausemode > 0) return;

		var ox = o.x;
		var oy = o.y;
		var ow = o.w; 
		var oh = o.h; 

		var mx = m.x;
		var my = m.y;
		var mw = m.w;
		var mh = m.h;

		var t = 8; // attempt to set a threshold a la manic shooter tiny boxes.

		var c1 = false, c2 = false, c3 = false, c4 = false;
		
		if (ox <= (mx+(mw-t))  &&  oy <= (my+(mh-t))  &&  ox >= (mx+t)  && oy >= (my+t)) c1 = true;
		if ((ox+ow) >= (mx+t)  &&  oy >= (my+t)  &&  (ox+ow) <= (mx+(mw-t))  &&  oy <= (my+(mh-t))) c2 = true;
		if (ox <= (mx+(mw-t))  &&  (oy+oh) >= (my+t)  &&  ox >= (mx+t)  &&  (oy+oh) <= (my+(mh-t))) c3 = true;
		if (((ox + ow) >= (mx+t)) && ((ox + ow) <= (mx + (mw-t))) && ((oy + oh) >= (my+t)) && ((oy + oh) <= (my + (mh-t)))) c4 = true; 

		if (c1 === true || c2 === true || c3 === true || c4 === true)
		{
			alienBonus(o);
			kill(o);
			alienKill(o);
			playerDamage(1,o);
		}
	}
	catch (e)
	{
		write("Alien player collision: " + e.message);
	}
};

function playerPowerupCollision(o,s,p) 
{
	try
	{
		if (!o.visible || !s.visible || g.pausemode > 0 || p.retiring) return;

		var ox = o.x;
		var oy = o.y;
		var ow = o.w; 
		var oh = o.h; 

		var mx = p.x;
		var my = p.y + 38;
		var mw = p.w;
		var mh = p.h;

		var t = 0; 

		var c1 = false, c2 = false, c3 = false, c4 = false;
		
		if (ox <= (mx+(mw-t))  &&  oy <= (my+(mh-t))  &&  ox >= (mx+t)  && oy >= (my+t)) c1 = true;
		if ((ox+ow) >= (mx+t)  &&  oy >= (my+t)  &&  (ox+ow) <= (mx+(mw-t))  &&  oy <= (my+(mh-t))) c2 = true;
		if (ox <= (mx+(mw-t))  &&  (oy+oh) >= (my+t)  &&  ox >= (mx+t)  &&  (oy+oh) <= (my+(mh-t))) c3 = true;
		if (((ox + ow) >= (mx+t)) && ((ox + ow) <= (mx + (mw-t))) && ((oy + oh) >= (my+t)) && ((oy + oh) <= (my + (mh-t)))) c4 = true; 

		if (c1 === true || c2 === true || c3 === true || c4 === true)
		{
			switch(o.row)
			{
				case 0:
					p.energy += 1;
					if (p.energy > p.energymax) p.energy = p.energymax;
					p.healing = 100;
					kill(o);
				break;
				case 1:
					playerDamage(1,o);
					kill(o);
				break;
			}
		}
	}
	catch (e)
	{
		write("Player powerup collision: " + e.message);
	}
};


