
function drawTextSprite(o)
{
	if (!o.visible) return;
	var text = new String(o.text);	
	g.ctx.save();
	g.ctx.font = "bold 14px '" + SCOREFONT + "'";
	g.ctx.textAlign = "left";
	g.ctx.fillStyle = "rgba(255,255,0," + (o.ticks * 0.01) + ")";//o.colour;
	//g.ctx.strokeStyle = g.colours[rnd(g.colours.length-1)];
	//g.ctx.strokeWidth = 1;
	g.ctx.fillText(text, o.x,o.y+8);
	//g.ctx.strokeText(text, o.x,o.y+8);
	g.ctx.restore();
};

function moveTextSprite(o)
{
	if (g.pausemode > 0) return;
	if (!o.visible) return;
	o.y -= o.speed;
	o.ticks -= 2;
	if (o.ticks < 0) kill(o);
};

function playerLives()
{
	var o = m.player;
	for (var a=0;a<m.player.lives;a++)
	{
		g.ctx.drawImage(g.characters, a * 48, 0, 48, 64, (g.canvaswidth-90)+(a * 26), 8, 24, 32);
	}
};

function drawStar(o)
{
	try
	{
		g.ctx.fillStyle = o.colour;
		g.ctx.fillRect(o.x,o.y,(g.mode == "intro" && o.starindex == 3 ? 6 : 2),o.size);
	}
	catch (e)
	{
		write(o.id);
	}
};

function moveStar(o)
{
	try
	{
		o.speed = o.basespeed;
		switch (o.direction)
		{
		case 0:
			o.y -= o.speed;
			break;			
		case 1:
			o.y -= (o.speed / 1.5);
			o.x += (o.speed / 1.5);
			break;			
		case 2:
			o.x += o.speed;
			break;			
		case 3:
			o.y += (o.speed / 1.5);
			o.x += (o.speed / 1.5);
			break;			
		case 4:
			o.y += o.speed;
			break;			
		case 5:
			o.y += (o.speed / 1.5);
			o.x -= (o.speed / 1.5);
			break;			
		case 6:
			o.x -= g.mode == "intro" && o.starindex == 3 ? o.speed * 3 : o.speed;
			break;			
		case 7:
			o.y -= (o.speed / 1.5);
			o.x -= (o.speed / 1.5);
			break;			
		}

		if ((o.x + o.size) < 0) o.x = g.canvaswidth;
		if (o.x > g.canvaswidth) o.x = (o.size * -1); 
		if ((o.y + o.size) < 0) o.y = g.canvasheight; 
		if (o.y > g.canvasheight) o.y = o.size * -1;
	}
	catch (e)
	{
		write("Move Star: " + e.message);
	}
};

function moveMothership(o)
{
	if (o.inposition) return;
	try
	{
		if (o.x < o.targetx) { o.x += o.speed; }
		if (o.x > o.targetx) { o.x -= o.speed; }
		if (o.y < o.targety) { o.y += o.speed; }
		if (o.y > o.targety) { o.y -= o.speed; }
		if (o.x == o.targetx && o.y == o.targety) { o.inposition = true; }
	}
	catch (e)
	{
		write("Move mothership: " + e.message);
	}
};

function drawMothership(o)
{
	try
	{
		if (o.inpain > 0) 
		{ 
			o.frame = o.spritesheet.painframe; 
			o.inpain --; 
		}
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw mothership: " + e.message);
	}
};

function movePlayer(o)
{
	try
	{
		if (g.mode == "pregame")
		{
			o.y -= 8;
			if (o.y < o.basey) { o.y = o.basey; }
			if (o.x < o.targetx) { o.x += o.speed; } 
			if (o.x > o.targetx) { o.x -= o.speed; }
		} else if (g.towerfalling)
		{
			if (o.x < g.textcentre - (o.w / 2))
			{
				o.x += 4;
			}
			if (o.x > g.textcentre - (o.w / 2))
			{
				o.x -= 4;
			}
		} else if (g.mode == "levelup")
		{
			o.x += 0.5;
			if (o.x > (g.textcentre - (o.w / 2))) o.x = g.textcentre - (o.w / 2);
			o.speed -= 1;
			if (o.speed < 1) o.speed = 1;
			o.y -= o.speed > 6 ? 4 : o.speed;
			o.w -= 2;
			o.h -= 1;
			
			if (o.w < 8) o.w = 8;
			if (o.h < 4) o.h = 4;
		} else if (g.mode == "game" && o.retiring)
		{
			o.y += 4;
		} else if (g.mode == "game" && g.pausemode < 1)
		{
			if (o.x < o.targetx) { o.x += o.speed; } 
			if (o.x > o.targetx) { o.x -= o.speed; }
		}
	}
	catch (e)
	{
		write("Move player: " + e.message);
	}
};

function drawPlayer(o)
{
	if (!o.visible) return;
	try
	{
		var s = m.playershadow;
		/*
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = o.startframe;
			}
		}
		*/
		o.frame = g.mode == "levelup" ? 1 : 0;
		if (o.inpain > 0) 
		{ 
			o.frame = o.spritesheet.painframe; 
			o.inpain --; 
			o.y -= 2;
			colourScreen(o.inpain * 20, "255,0,0");
		}

		if (o.healing > 0)
		{
			o.healing -= 10;
			colourScreen(o.healing, "0,255,0");
		}

		o.row = 3 - m.player.lives; //  Select the right star fighter to present
		if (o.row > 2) { o.row = 2; }

		g.ctx.save();
		var angle = 0;
		var sw = s.spritesheet.framewidth;
		var sx = o.x;
		var mid = (g.canvaswidth / 2) - (o.w / 2);
		if (o.x < mid) 
		{
			angle = 45 - (o.x / 3);
		} else {
			angle = ((o.x / 3) - 45) * -1;
		}
		sw = angle < 0 ? 64 - (angle * -1) * 0.35 : 64 - (angle * 0.35);
		if (angle < 0) sx = (o.x + o.w) - sw;
		if (o.retiring) { o.angle = 0; }

		if (g.mode != "levelup" && !o.retiring)
		{
			g.ctx.drawImage(s.spritesheet.image, sx, o.y + 38, sw, s.spritesheet.frameheight);
		}

		if (g.mode != "levelup")
		{
			g.ctx.translate(o.x + (o.w/2),o.y + (o.h/2));
			g.ctx.rotate(angle * (Math.PI / 180));
			g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.w, o.h, -o.w/2, -o.h/2, o.w, o.h);
		} else {
			g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
		}
		g.ctx.restore();
	}
	catch (e)
	{
		write("DrawPlayer: " + o.frame + " - " + e.message);
	}

};

function drawFloor(o)
{
	try
	{
		fillRectangle(g.towerfalling ? g.reds[1] : o.colour,null,o.x,o.y,o.w,o.h);
	}
	catch (e)
	{
		write(o.x+","+o.y+","+o.w+","+o.h);
	}
};

function moveFloor(o)
{
	if (g.pausemode > 0) return;
	try
	{
		o.inc += (o.y - g.horizon) * 0.006;
		o.h += o.inc;
		o.y += o.inc;
		if (o.y > g.canvasheight)
		{
			o.y = g.horizon;
			o.h = 0;
			o.inc = o.baseinc;
		}
	}
	catch (e)
	{
		write("Move floor: " + o.id);
	}
};

function draw(o)
{
	if (!o.visible) return;
	try
	{

		if (isNaN(o.attacking)) o.attacking = 0;
		if (o.attacking > 0)
		{
			o.attacking --;
			o.frame = o.spritesheet.attackframe;
		} else if (!o.diving) {
			if (isNaN(o.frame)) o.frame = o.startframe;
			o.framedelay --;
			if (o.framedelay < 0)
			{
				o.framedelay = o.framedelaymax;
				o.frame ++;
				if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
				{
					if (o.spritesheet.type === "explosion")
					{
						kill(o);
					} else {
						o.frame = o.startframe;
					}
				}
			}
			if (o.inpain) { o.frame = o.spritesheet.painframe; o.inpain = false; }
		} else {
			o.frame = 0;
		}
		g.ctx.save();
		if (o.diving)
		{
			var angle = 0;
			if (o.divestage === 1) angle = o.divedirection === 6 ? -45 : 45;
			if (o.divestage === 2) angle = o.divedirection === 6 ? 225 : 135;
			if (o.divestage === 3) angle = o.divedirection === 6 ? 165 : -165;
			g.ctx.translate(o.x + (o.w/2),o.y + (o.h/2));
			g.ctx.rotate(angle * (Math.PI / 180));
			g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.w, o.h, -o.w/2, -o.h/2, o.w, o.h);
		} else {
			g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.w, o.h, o.x, o.y, o.w, o.h);
		}
		g.ctx.restore();
	}
	catch (e)
	{
		write("Draw: Angle = " + o.angle + " - " + o.spritesheet.type + ", " + o.frame + " - " + e.message);
	}

};

function moveLaser(o)
{
	try
	{
		if (!o.visible || o.dead || g.pausemode > 0) return;
		o.h -= 0.5;
		o.w -= 0.5;
		o.speed -= 0.1;

		if (o.h > 10) 
		{
			o.y -= o.speed / 2;
			o.x -= o.lasers > 0 ? o.xmod / 48 : 0;
		} else {
			o.y -= o.speed / 32;
			o.x -= o.lasers > 0 ? o.xmod / 8 : 0;
		}
		if (o.lasers > 0)
		{
			if (o.type == 0)
			{
				o.x += 0.3;
			} else {
				o.x -= 0.3;
			}
		} else {
			o.x += 0.1;
		}
		if (o.w < 1) { o.w = 1; }
		if (o.h < 1) { o.h = 1; }
		if (o.y < (g.horizon - 8)) { kill(o); }

		o.distance ++;

		/*
		o.colourstep += 1; 
		if (m.player.lasers < 3)
		{
			if (o.colourstep > g.lasercolours.length - 1) { o.colourstep = g.lasercolours.length - 1; }
		} else {
			if (o.colourstep > g.superlasercolours.length - 1) { o.colourstep = g.superlasercolours.length - 1; }
		}
		o.colour = m.player.lasers < 3 ? g.lasercolours[Math.round(o.colourstep)] : g.superlasercolours[Math.round(o.colourstep)];
		*/
		//if (o.y < g.horizon - 12) { kill(o); }
		//if (o.h < 0) { kill(o); }
	}
	catch (e)
	{
		write("Move laser: " + e.message);
	}
};

function drawLaser(o)
{
	try
	{
		if (!o.visible || o.dead || g.pausemode > 0) return;
		/*
		g.ctx.fillStyle = o.colour;
		g.ctx.beginPath();
		g.ctx.arc(o.x+4,o.y,o.w, 0, Math.PI*2, true); 
		g.ctx.closePath();
		g.ctx.fill();
		*/
		g.ctx.drawImage(o.spritesheet.image,0,o.row * o.spritesheet.frameheight,o.spritesheet.framewidth,o.spritesheet.frameheight,o.x,o.y,o.w,o.h);
	}
	catch (e)
	{
		write("Draw laser: " + e.message);
	}
};

function moveToTarget(o)
{
	if (!o.visible || o.dead || g.pausemode > 0) return;

	o.oldx = o.x;
	o.oldy = o.y;

	if (o.targetx < 0 && o.targety < 0)
	{
		switch (o.direction)
		{
		case 0:
			o.y -= o.speed;
			break;			
		case 1:
			o.y -= (o.speed / 1.5);
			o.x += (o.speed / 1.5);
			break;			
		case 2:
			o.x += o.speed;
			break;			
		case 3:
			o.y += (o.speed / 1.5);
			o.x += (o.speed / 1.5);
			break;			
		case 4:
			o.y += o.speed;
			break;			
		case 5:
			o.y += (o.speed / 1.5);
			o.x -= (o.speed / 1.5);
			break;			
		case 6:
			o.x -= o.speed;
			break;			
		case 7:
			o.y -= (o.speed / 1.5);
			o.x -= (o.speed / 1.5);
			break;			
		}
	} else {
		if (o.jumping)
		{
			if (o.y >= o.targety)
			{
				if (!o.bounced)
				{
					o.bounced = true;
					o.y = o.y - 8;
					o.speed = -8;
				} else {
					o.speed = o.basespeed;
					o.jumping = false;
				}
			}
			if (o.dying > 0)
			{
				if (o.targetx > o.x) { o.x += o.speed; }
				if (o.targetx < o.x) { o.x -= o.speed; }
				if (o.targety < o.y) { o.y -= o.speed; }
				if (o.targety > o.y) { o.y += o.speed; }
				if (o.y < 0)
				{
					kill(o);
				}
			}
			if (o.bounced) o.speed += 2;
			if (o.y < o.targety) { o.y += o.speed; }
		} else {
			if (o.divestage === 4 && o.diving)
			{
				var thresh = 1;
				if ((Math.round(o.x) >= Math.round(o.targetx) - thresh) 
					&& 
					(Math.round(o.x) <= Math.round(o.targetx) + o.w + thresh) 
					&& 
					(Math.round(o.y) >= Math.round(o.targety) - thresh)
					&& 
					(Math.round(o.y) <= Math.round(o.targety) + o.h + thresh)
					)
				{
					o.divestage = 0;
					o.diving = false;
					write("Back");
					o.speed = o.basespeed;
					g.divingaliens --;
				} else {
					if (o.targetx > o.x) { o.x += o.speed; }
					if (o.targetx < o.x) { o.x -= o.speed; }
					if (o.targety < o.y) { o.y -= o.speed; }
					if (o.targety > o.y) { o.y += o.speed; }
				}
			} else {
				// Target co-ords set by screen touch.
				if (o.targetx > o.x) { o.x += o.speed; }
				if (o.targetx < o.x) { o.x -= o.speed; }
				if (o.targety < o.y) { o.y -= o.speed; }
				if (o.targety > o.y) { o.y += o.speed; }
			}
		}
	}
	if (o.dying < 1)
	{
		if (o.x < g.canvaspadding) o.x = g.canvaspadding;
		if ((o.x + o.w) > (g.canvaswidth - g.canvaspadding)) o.x = g.canvaswidth - g.canvaspadding - o.w;
		if (o.y < g.canvaspadding) o.y = g.canvaspadding;
		if ((o.y + o.h) > (g.canvasheight - g.canvaspadding)) o.y = g.canvasheight - g.canvaspadding - o.h;
	}
};

function move(o)
{
	if (!o.visible || g.pausemode > 0) return;

	var bomb = o.spritesheet.type === "alienbomb" ? true : false;

	switch (o.direction)
	{
	case 0:
		o.y -= o.speed;
		break;			
	case 1:
		o.y -= (o.speed / 1.5);
		o.x += (o.speed / 1.5);
		break;			
	case 2:
		o.x += o.speed;
		break;			
	case 3:
		o.y += (o.speed / 1.5);
		o.x += (o.speed / 1.5);
		break;			
	case 4:
		o.x += bomb ? o.xmod : o.speed;
		o.y += o.speed;
		break;			
	case 5:
		o.y += (o.speed / 1.5);
		o.x -= (o.speed / 1.5);
		break;			
	case 6:
		o.x -= o.speed;
		break;			
	case 7:
		o.y -= (o.speed / 1.5);
		o.x -= (o.speed / 1.5);
		break;			
	}
	if (bomb)
	{
		if (o.y > (g.canvasheight - 70))
		{
			kill(o);
		}
	}
};

function moveCloud(o)
{
	try
	{
		o.x += 0.1;
		if (o.x > g.canvaswidth) o.x = o.w * -1;
	}
	catch (e)
	{
		write("Move cloud: " + e.message);
	}
};

function drawCloud(o)
{
	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = 0;
			}
		}
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, g.planetstage * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw cloud: " + e.message);
	}
};

function moveAlienBomb(o)
{
	if (!o.visible || g.pausemode > 0) return;
	try
	{
		o.speed += 0.25;

		o.w += o.row < 1 ? 0.4 : 0.4;
		o.h += o.row < 1 ? 0.4 : 0.4;

		if (o.row == 0)
		{
			o.x -= o.xmod;
			if (o.xmod != 0)
			{
				if (o.xmod < 0)
				{
					o.x += (o.speed);
				} else {
					o.x -= (o.speed);
				}
			}
			o.y += o.speed;
			if (o.y > g.canvasheight) { kill(o); }
			
			if (o.y > (g.horizon + 20))
			{
				if (o.w >= o.spritesheet.framewidth) o.w = o.spritesheet.framewidth;
				if (o.h >= o.spritesheet.frameheight) o.h = o.spritesheet.frameheight;
			}		
		} 
		if (o.row == 1)
		{
			o.x -= o.xmod;
			o.y += o.ymod;
			o.shadoww += 0.4;
			o.shadowh += 0.2;
			if (o.shadoww > o.w) { o.shadoww = o.w; }
			if (o.shadowh > o.spritesheet.frameheight) { o.shadowh = o.spritesheet.frameheight; }
			o.ymod += 0.25;
			if (o.ymod > o.speed) o.ymod = o.speed;
			if (o.y > (m.player.y - 8)) { spawnExplosion(o,4,1); kill(o); }
			
			if (o.y < (g.horizon + 20))
			{
				//o.w += 0.1;
				//o.h += 0.1;
			} else {
				//o.w += 0.1;
				//o.h += 0.1;
				if (o.w >= o.spritesheet.framewidth) { o.w = o.spritesheet.framewidth; }
				if (o.h >= o.spritesheet.frameheight) { o.h = o.spritesheet.frameheight; }
			}		
		}
	}
	catch (e)
	{
		write("Move alien bomb: " + e.message);
	}
};

function drawAlienBomb(o)
{
	if (!o.visible) return;
	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = 0;
			}
		}
		if (o.row == 1)
		{
			if (o.ymod >= 0)
			{
				g.ctx.drawImage(g.alienshadow,0,0,32,16,o.x,m.player.y + m.player.h,o.shadoww,o.shadowh);
			}
		}
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw alien bomb: " + e.message);
	}
};

function moveCoin(o)
{
	if (!o.visible || g.pausemode > 0) return;
	try
	{
		o.speed += 0.2;
		o.y -= o.ymod;
		o.ymod -= 0.5;
		o.x -= o.xmod;
		//if (o.ymod < -4) { o.ymod = -4; }
		if (o.y > g.canvasheight) { kill(o); }
		
		o.w += 0.5;
		o.h += 0.5;
		if (o.w >= o.spritesheet.framewidth) o.w = o.spritesheet.framewidth;
		if (o.h >= o.spritesheet.frameheight) o.h = o.spritesheet.frameheight;
	}
	catch (e)
	{
		write("Move coin: " + e.message);
	}
};

function drawCoin(o)
{
	if (!o.visible) return;
	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = 0;
			}
		}
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw coin: " + e.message);
	}
};

function moveFighter(o)
{
	try
	{
		o.x -= o.xmod;
		o.xmod -= 0.05;
		o.y += o.ymod;
		o.w += 0.025;
		o.h += 0.01;
	}
	catch (e)
	{
		write("Move fighter: " + e.message);
	}
};

function drawFighter(o)
{
	try
	{
		g.ctx.fillStyle = "#ffffff";
		g.ctx.fillRect(o.x,o.y,o.w,o.h);
	}
	catch (e)
	{
		write("Draw fighter dot: " + e.message);
	}
};

function moveExplosion(o)
{
	if (!o.visible || g.pausemode > 0) return;
	o.w += 1;
	o.h += 1;
	switch (o.direction)
	{
		case 4:
			o.y += o.speed;
			break;
	}
	if (isNaN(o.xmod)) { o.xmod = 0; }
	if (o.explosiontype != "TOWER" && o.explosiontype != "INTRO") { o.x -= o.xmod; }
};

function drawExplosion(o)
{
	if (!o.visible) return;
	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				kill(o);
			}
		}
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw explosion: " + e.message);
	}

};

function moveAlien(o) /* Moves and scales the alien and shadow */
{
	try
	{
		if (!o.visible || g.pausemode > 0) return;

		if (o.hold < 1)
		{
			o.speed += o.speed < 2 ? 0.1 : 0.08;
			o.ymod += 0.05;
			o.w += 1;
			o.h += 1;

			o.distance ++;

			o.shadoww += 1;
			if (o.ymod >= 1.1)
			{
				o.shadowh += 0.2;
			}

			if (o.speed < 2)
			{
				o.y -= 2 - o.speed;
			} else {
				o.y += o.speed - o.ymod;
			}
			if (o.w > o.maxw) { o.w = o.maxw; o.shadoww = o.maxw; }
			if (o.h > o.maxh) { o.h = o.maxh; }

			if (o.xmod != 0)
			{
				o.x -= o.xmod;
			}

		} else {
			o.hold --;
			o.w += 0.5;
			o.h += 0.5;
			o.y += 0.2;
			o.x -= ((o.row > 3 ? o.xmod * - 1 : o.xmod) / (o.row > 3 ? 1 : 4));
			o.shadoww += 0.5;
			o.nextthink --;
			if (o.nextthink < 1)
			{
				spawnAlienBomb(o);
				o.nextthink = o.basenextthink;
			}
		}

		if ((o.y + o.h) > g.horizon && !o.diving) //(m.player.y - 32) && !o.diving)
		{
			o.diving = true;
			o.hold = 32;
			if (o.x >= g.textcentre)
			{
				o.divedir = o.row == 1 ? 6 : 2;
			} else {
				o.divedir = o.row == 1 ? 2 : 6;
			}
		}

		if (o.diving && o.hold < 1)
		{
			if (o.divedir == 6)
			{
				//o.angle -= 1;
				o.x -= o.row == 1 ? 16 : 8;
			} else {
				//o.angle += 1;
				o.x += o.row == 1 ? 16 : 8;
			}
		}

		if (o.y > g.canvasheight) { kill(o); } //kill(o.shadow); }
	}
	catch (e)
	{
		write("Move alien: " + e.message);
	}
};

function drawAlien(o)
{
	if (!o.visible) return;
	try
	{
		// Draw alien shadow
		if ((o.y + o.h + 8) > g.horizon)
		{
			g.ctx.drawImage(g.alienshadow,0,0,32,16,o.x,o.y + o.h + 8,o.shadoww,o.shadowh);
			//fillRectangle("0,0,0",0.3,o.x,o.y + o.h + 8,o.shadow.w,o.shadow.h);
		}
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = o.startframe;
			}
		}
		// Draw alien
		if (o.angle != 0)
		{
			g.ctx.save();
			g.ctx.translate(o.x + (o.w/2),o.y + (o.h/2));
			g.ctx.rotate(o.angle * (Math.PI / 180));
			g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.w, o.h, -o.w/2, -o.h/2, o.w, o.h);
			g.ctx.restore();
		} else {
			g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
		}
	}
	catch (e)
	{
		write("DrawAlien: Angle = " + o.angle + " - " + o.spritesheet.type + ", " + o.frame + " - " + e.message);
	}

};

function moveSaucer(o)
{
	try
	{
		if (!o.visible || g.pausemode > 0) return;

		if (!o.yposition)
		{
			if (o.y < o.targety)
			{
				o.y += o.speed;
			}
			if (o.y > (o.targety - 50))
			{
				o.speed -= 1;
				if (o.speed < 1) o.speed = 1;
			}
			if (o.y === o.targety)
			{
				o.yposition = true;
				o.speed = o.basespeed;
			}
		}
		
		if (o.yposition && !o.xposition)
		{
			if (o.x > o.targetx)
			{
				o.x -= o.speed;
				if (o.x < (o.targetx + 50))
				{
					o.speed -= 1;
					if (o.speed < 1) o.speed = 1;
				}
			}
			if (o.x < o.targetx)
			{
				o.x += o.speed;
				if (o.x > (o.targetx - 50))
				{
					o.speed -= 1;
					if (o.speed < 1) o.speed = 1;
				}
			}
			if (o.x === o.targetx)
			{
				o.xposition = true;
				o.speed = o.basespeed;
			}
		}

		if (o.xposition && o.yposition)
		{
			if (o.row > 0 && !g.towerfalling)
			{
				if (isNaN(o.direction)) o.direction = rnd(10) < 5 ? 2 : 6;

				if (o.direction === 2)
				{
					o.x += o.speed / 2;
					if (o.x + o.w > g.canvaswidth) o.direction = 6;
				}
				if (o.direction === 6)
				{
					o.x -= o.speed / 2;
					if (o.x < 0) o.direction = 2;
				}
			}
			
			if (g.towerfalling)
			{
				o.y -= o.speed / 4;
				if (o.y + o.h < 0) kill(o);
			}

			g.saucerbombcooldown --;
			if (g.saucerbombcooldown < 1)
			{
				spawnSaucerBomb(o,0);
				if (g.level >= 4)
				{
					spawnSaucerBomb(o,-1.8);
					spawnSaucerBomb(o,1.8);
				}
				if (g.level >= 8)
				{
					spawnSaucerBomb(o,-3);
					spawnSaucerBomb(o,3);
				}
				g.saucerbombcooldown = g.saucerbombcooldownmax;
			}
		}	
	}
	catch (e)
	{
		write("Move saucer: " + e.message);
	}
};

function drawSaucer(o)
{
	if (!o.visible) return;
	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = o.startframe;
			}
		}
		if (o.inpain) { o.frame = o.spritesheet.painframe; o.inpain = false; }
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw Saucer: " + e.message);
	}

};

function moveProbe(o)
{
	try
	{
		if (!o.visible || g.pausemode > 0) return;

			if (isNaN(o.direction)) o.direction = rnd(10) < 5 ? 2 : 6;

			if (o.direction === 2)
			{
				o.x += o.speed / 2;
				if (o.x > g.canvaswidth) { kill(o) };
			}
			if (o.direction === 6)
			{
				o.x -= o.speed / 2;
				if (o.x + o.w < 0) { kill(o); }
			}
	}
	catch (e)
	{
		write("Move probe: " + e.message);
	}
};

function drawProbe(o)
{
	if (!o.visible) return;
	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = o.startframe;
			}
		}
		if (o.inpain) { o.frame = o.spritesheet.painframe; o.inpain = false; }
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw probe: " + e.message);
	}

};

function moveObstacle(o) 
{return;
	try
	{
		if (!o.visible || g.pausemode > 0) return;
		o.speed += 0.06;
		o.ymod += 0.01;
		o.w += 1.25;
		o.h += 1.2;

		o.distance ++;

		if (o.distance < 10)
		{
			o.h += 1;
			o.y -= 1;
			//o.y -= 2 - o.speed;
		} else {
			o.y += o.speed * 3;// - o.ymod;
			o.h += 1.5;
		}

		//if (o.y > g.horizon)//(m.player.y - 64))
		//{
		//	o.xmod -= o.xmod < 0 ? 0.2 : -0.2;
		//} else {
			//calculateModsAlien(o);
		//}
		//if (o.w > o.maxw) o.w = o.maxw;
		//if (o.h > o.maxh) o.h = o.maxh;
		o.x -= o.xmod;
		if (o.y > g.canvasheight) { kill(o); }
	}
	catch (e)
	{
		write("Move obstacle: " + e.message);
	}
};

function drawObstacle(o,flag)
{return;
	if (!o.visible) return;
	if (flag === 1 && o.y <= (m.player.y - 32)) return;
	if (flag === 0 && o.y >= (m.player.y - 32)) return;

	try
	{
		if (isNaN(o.frame)) o.frame = o.startframe;
		o.framedelay --;
		if (o.framedelay < 0)
		{
			o.framedelay = o.framedelaymax;
			o.frame ++;
			if (o.frame >= (o.startframe + o.spritesheet.framesperdirection))
			{
				o.frame = o.startframe;
			}
		}
		if (o.inpain) { o.frame = o.spritesheet.painframe; o.inpain = false; }
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw obstacle: Angle = " + o.angle + " - " + o.spritesheet.type + ", " + o.frame + " - " + e.message);
	}
};

function movePowerup(o) 
{
	try
	{
		if (!o.visible || g.pausemode > 0) return;
		o.speed += 0.25;
		o.ymod += 0.05;
		o.w += 2;
		o.h += 0.5;

		o.distance ++;

		if (o.distance < 10)
		{
			o.h += 0.1;
			o.y -= 0.1;
		} else {
			o.y += o.speed; // - o.ymod;
			o.h += 0.5;
		}
		if (o.h > o.maxh) o.h = o.maxh;

		//calculateModsAlien(o);
		o.x -= o.xmod;
		if (o.y > g.canvasheight) { kill(o); }
	}
	catch (e)
	{
		write("Move powerup: " + e.message);
	}
};

function drawPowerup(o)
{
	if (!o.visible) return;

	try
	{
		g.ctx.drawImage(o.spritesheet.image, o.frame * o.spritesheet.framewidth, o.row * o.spritesheet.frameheight, o.spritesheet.framewidth, o.spritesheet.frameheight, o.x, o.y, o.w, o.h);
	}
	catch (e)
	{
		write("Draw powerup: Angle = " + o.angle + " - " + o.spritesheet.type + ", " + o.frame + " - " + e.message);
	}

};

function spawnDive(o)
{
	var x = (g.levelaliens + 1) - (g.levelaliens - g.alienskilled);

	if (rnd(100) > (x * 4) || !o.visible || o.diving || (g.divingaliens >= g.maxdivingaliens) || g.mode != "game") return;
	g.divingaliens ++;
	o.diving = true;
	o.divestage = 1;
	o.direction = 4;
	o.divedirection = o.x < (g.canvaswidth / 2) ? 6 : 2;
	o.inc = 0;
	o.speed = 2;
	o.storedx = o.x;
	o.storedy = o.y;
	o.steps = 0;
	o.turned = false;
};

function changeDirection(o)
{
	switch (o.direction)
	{
	case 0:
		o.direction = 4;
	break;
	case 1:
		o.direction = 5;
	break;
	case 2:
		o.direction = 6;
	break;
	case 3:
		o.direction = 7;
	break;
	case 4:
		o.direction = 0;
	break;
	case 5:
		o.direction = 1;
	break;
	case 6:
		o.direction = 2;
	break;
	case 7:
		o.direction = 3;
	break;
	}
};

function drawMountains()
{
	g.ctx.drawImage(g.mountains[g.planetstage],0,g.mountainsy);
};

function moveMountains()
{
	if (g.pausemode > 0) return;
	//if (g.mode === "game")
	{
		g.mountainsy -= 0.005;//planetdata[g.planetstage].rate / 2;
		if (g.mountainsy < (g.horizon - 100)) g.mountainsy = g.horizon - 100;
	}
};

function drawDot(o)
{
	if (!o.visible) return;
	try
	{
		if (o.alpha < 0)
		{
			if (o.colourindex >= 0 && g.pausemode < 1)
			{
				o.nextthink --;
				if (o.nextthink < 1)
				{
					if (o.spritetype == "UI") { o.colourindex ++; }
					if (o.colourindex >= (o.spritetype == "UI" ? g.UIColours.length : g.explosionColours.length))
					{
						o.colourindex = (o.spritetype == "UI" ? g.UIColours.length - 1 : g.explosionColours.length - 1);
					}
					o.nextthink = 4;
				}
			}
			if (o.colourindex >= 0)
			{
				g.ctx.fillStyle = (o.spritetype == "UI" ? g.UIColours[o.colourindex] : g.explosionColours[o.colourindex]);
			} else {
				g.ctx.fillStyle = o.colour;
			}
		} else {
			g.ctx.fillStyle = "rgba(255,255,0," + (o.alpha * 0.01) + ")";
			o.alpha -= 2;
			if (o.alpha < 0) { kill(o); }
		}
		//g.ctx.fillStyle = o.colourindex >= 0 ? { write(g.explosionColours[o.colourindex]);  : o.colour;
		g.ctx.fillRect(o.x,o.y,o.w,o.h);
	}
	catch (e)
	{
		write("Dot: " + o.colourindex + " - " + e.message);
	}

};

function moveDot(o)
{
	if (!o.visible || g.pausemode > 0) return;
	if (o.y < o.spritetype == "UI" ? g.canvasheight : g.canvasheight - 100)
	{
		switch (o.direction)
		{
		case 0:
			o.y -= o.speed;
			break;			
		case 1:
			o.y -= (o.speed / 1.5);
			o.x += (o.speed / 1.5);
			break;			
		case 2:
			o.x += o.speed;
			break;			
		case 3:
			o.y += (o.speed / 1.5);
			o.x += (o.speed / 1.5);
			break;			
		case 4:
			o.y += o.spritetype == "saucer" ? o.speed / 4 : o.spritetype == "UI" ? o.speed : o.speed;
			break;			
		case 5:
			o.y += (o.speed / 1.5);
			o.x -= (o.speed / 1.5);
			break;			
		case 6:
			o.x -= o.speed;
			break;			
		case 7:
			o.y -= (o.speed / 1.5);
			o.x -= (o.speed / 1.5);
			break;			
		}
		o.speed += 0.6;
		o.x += o.spritetype == "UI" ? o.xmod * 4 : o.xmod;
	} else {
		o.y += 4;
		//o.h -= 0.1;
	}
	o.w += 0.1;
	o.h += 0.1;
	if (o.y > g.canvasheight) { kill(o); }
	if (o.x > g.canvaswidth) { kill(o); }
	if (o.x < 0) { kill(o); }
};
