
/*
	A resource for common and useful functions.
*/

function rnd(threshold)
{
	return Math.floor(Math.random()*threshold) + 1;
};

function dataReset()
{
	try
	{
		localStorage.setItem(GAMETITLE + "-hiscore", "10000"); 
		localStorage.setItem(GAMETITLE + "-stages", "1|0|0|0|0|0|0|0|0|0/1|0|0|0|0|0|0|0|0|0/1|0|0|0|0|0|0|0|0|0/1|0|0|0|0|0|0|0|0|0");
		localStorage.setItem(GAMETITLE + "-stagetimes", "25|25|25|25|25|25|25|25|25|25/40|40|40|40|40|40|40|40|40|40/60|60|60|60|60|60|60|60|60|60/90|90|90|90|90|90|90|90|90|90");
		localStorage.setItem(GAMETITLE + "-awards", "0|0|0|0|0|0/0|0|0|0|0|0/0|0|0|0|0|0/0|0|0|0|0|0"); 
		localStorage.setItem(GAMETITLE + "-planets", "1|0|0|0"); 
		localStorage.setItem(GAMETITLE + "-stageawards", "0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0*0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0*0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0*0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0/0|0|0");
		localStorage.setItem(GAMETITLE + "-credits", 0); 	
		localStorage.setItem(GAMETITLE + "-energy", 5); 	
		localStorage.setItem(GAMETITLE + "-lasers", 0); 	
		localStorage.setItem(GAMETITLE + "-speed", 4); 	
	}
	catch (e)
	{
		write("Data reset: " + e.message);
	}
};

function setAdverts(show,pick)
{
	if (!ADVERTS) return;
	if (show)
	{
		g.banad.style.display = "block";
	} else {
		g.banad.style.display = "none";
	}
	if (pick)
	{
		pickAdURL();
	}
};

function setSplash()
{
	g.mode = "splash";
	g.resetting = 100;
	g.ticker = setTimeout("loop()", 0);
};

function sfx(o)
{
};

function handleAudio()
{
};


function wipe(doentities)
{
	try
	{
		for (var a=0;a<NUM.coins;a++) { kill(m.coins[a]); }
		for (var a=0;a<NUM.dots;a++) { kill(dots[a]); }
		for (var a=0;a<NUM.saucers;a++) { kill(m.saucers[a]); }
		for (var a=0;a<NUM.probes;a++) { kill(m.probes[a]); }
		for (var a=0;a<m.alienbomb.length;a++) { kill(m.alienbomb[a]); }
		for (var a=0;a<m.aliens.length;a++) { kill(m.aliens[a]); }
		for (var a=0;a<m.explosion.length;a++) { kill(m.explosion[a]); }
		for (var a=0;a<m.lasers.length;a++) { kill(m.lasers[a]); }
		for (var a=0;a<m.textsprites.length;a++) { kill(m.textsprites[a]); }
		for (var a=0;a<m.obstacles.length;a++) { kill(m.obstacles[a]); }
		for (var a=0;a<m.powerups.length;a++) { kill(m.powerups[a]); }
	}
	catch (e)
	{
		write("Wipe: " + e.message);
	}
};

function bombBlast()
{
	try
	{
		for (var a=0;a<NUM.aliens;a++) { 
			if (m.aliens[a].visible == true) 
			{ 
				spawnBlastExplosion(m.aliens[a]); 
			} 
			kill(m.aliens[a]); 
		}
		for (var a=0;a<NUM.saucers;a++) { 
			if (m.saucers[a].visible) 
			{ 
				spawnBlastExplosion(m.saucers[a]); 
			} 
			kill(m.saucers[a]); 
		}
		for (var a=0;a<NUM.probes;a++) { 
			if (m.probes[a].visible) 
			{ 
				spawnBlastExplosion(m.probes[a]); 
			} 
			kill(m.probes[a]); 
		}
		for (var a=0;a<NUM.alienbombs;a++) { 
			if (m.alienbomb[a].visible) 
			{ 
				spawnBlastExplosion(m.alienbomb[a]); 
			} 
			kill(m.alienbomb[a]); 
		}
		g.bombblast = 100;
	}
	catch (e)
	{
		write("Bomb blast: " + e.message);
	}
};

function kill(o)
{
	o.visible = false;
};

function calculateModsAlien(alien) 
{
	var steps = (alien.targety - alien.y) / alien.speed;
	alien.xmod = (alien.targetx - alien.x) / steps;
};

function setLandscape()
{
	g.oldmode = g.mode;
	g.mode = "landscape";
};

function writeText(t,x,y,s,f,c,a,alpha,sc)
{
	var sx = x;
	var grid = {};
	grid.w = 10;
	grid.h = 16;
	var text = new String(t);	
	g.ctx.save();
	var ss = "";
	g.ctx.font = "bold "+(LOCALISED ? s : s * 1.1)+"px '"+f+"'";
	g.ctx.textAlign = a ? a : "center";
	if (alpha)
	{
		g.ctx.fillStyle = "rgba(" + c + "," + (alpha * 0.01) + ")";
	} else {
		g.ctx.fillStyle = c ? c : "#FFFF00";
	}

	if (sc != null && SHADOWTEXT)
	{
		g.ctx.shadowColor = sc;
		g.ctx.shadowBlur = 0;
		//g.ctx.shadowOffsetX = -1;
		//g.ctx.shadowOffsetY = -1;
		//g.ctx.fillText(text, x,y+8);
		g.ctx.shadowOffsetX = 2;
		g.ctx.shadowOffsetY = 2;
		wrapText(text,x,y+8,s+4);//g.ctx.fillText(text, x,y+8);
	} else {
		wrapText(text,x,y+8,s+4);//g.ctx.fillText(text, x,y+8);
	}

	g.ctx.restore();
};

function wrapText(text, x, y, lineHeight) {
	var words = text.split(" ");
	var line = "";

	for(var n = 0; n < words.length; n++) {
	  var testLine = line + words[n] + " ";
	  var metrics = g.ctx.measureText(testLine);
	  var testWidth = metrics.width;
	  if(testWidth > (g.canvaswidth - 100)) {
		g.ctx.fillText(line, x, y);
		line = words[n] + " ";
		y += lineHeight;
	  }
	  else {
		line = testLine;
	  }
	}
	g.ctx.fillText(line, x, y);
};

function fillRectangle(c,a,x,y,w,h)
{
	try
	{
		if (a != null)
		{
			g.ctx.fillStyle = "rgba(" + c + "," + a + ")";
		} else {
			g.ctx.fillStyle = c;
		}
		g.ctx.fillRect(x,y,w,h);
	}
	catch (e)
	{
		write("Fill: " + e.message);
	}
};

function fadeScreen(a)
{
	try
	{
		var alpha = 1 - (a * 0.01);
		if (alpha > 1) alpha = 1;
		fillRectangle("0,0,0",alpha,0,0,g.canvaswidth,g.canvasheight);
	}
	catch (e)
	{
		write("Fade out: " + e.message);
	}
};

function colourScreen(a,rgb)
{
	try
	{
		var alpha = a * 0.01;
		if (alpha > 1) alpha = 1;
		fillRectangle(rgb,alpha,0,0,g.canvaswidth,g.canvasheight);
	}
	catch (e)
	{
		write("Fade out: " + e.message);
	}
};

function calculateMods(alien,player,bomb) // s - source object, t - target object, o - object to move
{
	var steps = (player.y - alien.y) / bomb.speed;
	bomb.xmod = (alien.x - (player.x + player.w)) / steps;
};

function calculateModsCoin(player,coin) // s - source object, t - target object, o - object to move
{
	var steps = (player.y - coin.y) / coin.speed;
	coin.xmod = (coin.x - player.x) / steps;
};

function calculateModsXY(s,x,y,o) // s - source object, x,y - target object co-ords, o - object to move
{
	var steps = (y - s.y) / o.speed;
	o.xmod = (x - s.x) / steps;
};

function calculateModsXY1XY2(x1,y1,x2,y2,o) // s - source object, t - target object, o - object to move
{
	var steps = (y2 - y1) / o.speed;
	o.xmod = ((x2 - x1) / steps) * -1;
};

function hiScore()
{return;
	try
	{
		var sScore = new String();
		var sInScore = new String(m.player.hiscore);
		var ls = sInScore.length;
		var s = new String();
		
		for (var a = 0; a < (8-ls); a++) s += "0";
		for (var b = 0; b < sInScore.length; b++) s += "" + sInScore.substring(b,b+1);
		
		writeText(s,g.canvaswidth/2,26,32,SCOREFONT,"#ffff00","center", null,"#000000");
		
	}
	catch (e)
	{
		write(e.message);
	}
};

function updateScore()
{
	try
	{
		/*
		m.player.score += 1;
		if (m.player.score > m.player.targetscore) m.player.score = m.player.targetscore;
		if (m.player.score > 99999999) m.player.score = 99999999;
		var sScore = new String();
		var sInScore = new String(m.player.score);
		var ls = sInScore.length;
		var s = new String();
		
		for (var a = 0; a < (8-ls); a++) s += "0";
		for (var b = 0; b < sInScore.length; b++) s += "" + sInScore.substring(b,b+1);
		*/

		/*if (m.player.score >= 250000 && !g.bonuslife1) 
		{
			m.player.lives ++;
			spawnTextSprite(m.player,"EXTRA LIFE");
			g.bonuslife1 = true;
		}

		if (m.player.score >= 500000 && !g.bonuslife2) 
		{
			m.player.lives ++;
			spawnTextSprite(m.player,"EXTRA LIFE");
			g.bonuslife2 = true;
		}*/

		//writeText(s,g.canvaswidth/2,26,32,SCOREFONT,"#ffff00","center",null,"#000000");

		/* Updated to present credits instead of score */
		
		m.player.credits += 1;
		if (m.player.credits > m.player.targetcredits) { m.player.credits = m.player.targetcredits; }
		if (m.player.credits > 999999) { m.player.credits = 999999; }
		g.ctx.drawImage(g.credit,48, 8);
		writeText(m.player.credits,84,28,32,SCOREFONT,"#ffff00","left",null,"#000000");
	}
	catch (e)
	{
		write("Score: " + e.message);
	}
};

window.onorientationchange = function(event) {
	setCanvasDimensions(event);
};
