
/*
	DISTANT ORBIT
	(C) Mark Wilcox 
	More games at www.spacemonstergames.co.uk
	Please refer to http://www.spacemonsters.co.uk/copyright/  
*/

function init()
{
	try
	{
		window.navigator.standalone = true;
		if (DATARESET) { dataReset(); }

		g.canvas = document.querySelector('canvas');
		g.ctx = g.canvas.getContext('2d');
		g.canvas.setAttribute('class', 'canvas');

		g.orientation = document.getElementById("orientate");
		g.ori = 0;
		g.textblink = 40;
		g.textblinkmax = g.textblink;

		scale();

		g.textblink = 40;
		g.textblinkmax = g.textblink;

		g.console = document.getElementById('console');
		g.console.style.display = DEBUG ? "block" : "none";
		g.console.style.textAlign = 'left';
		write("Console ready.");
		BrowserDetect.init();
		write("Browser: " + BrowserDetect.browser + " " + BrowserDetect.version);
		write("OS: " + BrowserDetect.OS);

		var br = new String(BrowserDetect.OS);
		g.framedelay = 30;
		ISIPHONE = false;
		if (br.indexOf("iPhone") != -1)
		{
			ISIPHONE = true;
		}

		g.banad = document.getElementById("banad");
		setAdverts(false,true);

		g.pausemode = 0;
		g.audiomode = 1;
		g.nextthink = 0;

		preCache();

		write("Version " + VERSION + ":" + BUILDVER);
		write("Date " + LASTDATE);
	}
	catch (e)
	{
		write(e.message);
	}
};

function intro()
{
	setAdverts(false, false);
	g.resetting = 1000;
	g.sequence = 0;
	g.sequencetimer = introsequence[0].timer;
	g.mode = "intro";

	m.motherships[0].x = g.textcentre - 61;
	m.motherships[0].y = -48;
	m.motherships[0].targetx = m.motherships[0].x;
	m.motherships[0].targety = 80;

	m.motherships[1].x = g.canvaswidth + 20;
	m.motherships[1].y = 150;
	m.motherships[1].targetx = g.canvaswidth - 122;
	m.motherships[1].targety = m.motherships[1].y;

	m.motherships[2].x = g.textcentre - 61;
	m.motherships[2].y = g.canvasheight + 20;
	m.motherships[2].targetx = m.motherships[2].x;
	m.motherships[2].targety = 220;

	m.motherships[3].x = -142;
	m.motherships[3].y = 150;
	m.motherships[3].targetx = 0;
	m.motherships[3].targety = m.motherships[3].y;

	for (var a=0;a < NUM.motherships;a++) 
	{ 
		m.motherships[a].inposition = false; 
		m.motherships[a].inpain = 0; /* ticks down to zero and displays the pain frame */
		m.motherships[a].speed = a != 2 ? 0.25 : 0.5;
	}

	g.planetdamage = 0;

	m.fighters[0] = {
		x : g.textcentre,
		y : 200,
		ymod : 1,
		xmod : 2,
		w : 1,
		h : 1,
		sprite : {
			x : -100,
			y : 120,
			w : 100,
			h : 32,
			scale : 1,
			speed : 0.1,
			warp : 1
		}
	};
	m.fighters[1] = {
		x : g.textcentre,
		y : 200,
		ymod : 1.2,
		xmod : 2,
		w : 1,
		h : 1,
		sprite : {
			x : -90,
			y : 160,
			w : 100,
			h : 32,
			scale : 1,
			speed : 0.14,
			warp : 1
		}
	};
	m.fighters[2] = {
		x : g.textcentre,
		y : 200,
		ymod : 1.4,
		xmod : 2,
		w : 1,
		h : 1,
		sprite : {
			x : -100,
			y : 200,
			w : 100,
			h : 32,
			scale : 1,
			speed : 0.18,
			warp : 1
		}
	};

	setStars();
};

function planetSelect()
{
	g.textblink = 0;
	g.resetting = 100;
	g.mode = "planetselect";
	setStars();
};

function chooseStage()
{
	g.mode = "stageselect";
	g.resetting = 100;
	g.textblink = 0;
	setSky();
	setStars();
};

function setShop()
{
	g.mode = "shop";
	g.resetting = 100;
	g.textblink = 0;
	g.pausemode = 0;
	m.player.targetcredits = Math.round(m.player.credits);
	g.level = -1;
	g.cadet = rnd(5) - 1;
	setStars();
};

function setStars()
{
	for (var a=0;a<stars.length;a++) 
	{ 
		stars[a].x = rnd(g.canvaswidth);
		stars[a].y = rnd(g.canvasheight); 
		stars[a].speed = stars[a].basespeed;
		stars[a].direction = g.mode == "planetselect" || g.mode == "title" ? 4 : g.mode == "stageselect" || g.mode == "intro" || g.mode == "shop" ? 6 : 2;
	}
};

function setTitle()
{
	g.levelticker = 0;
	g.planetstage = rnd(4) - 1;
	g.level = 0;
	setSky();
	setFloorColours();
	resetTower();
	setClouds();

	g.mode = "title";
	setAdverts(true, false);
	setFloorColours();
	g.mountainsy = g.horizon - 80;
	g.canvas.style.backgroundImage = "none";
	g.canvas.style.backgroundColor = "#000000";
	g.stage = 0; 
	setStars();
};

function setGame()
{
	m.player.score = 0;
	m.player.targetscore = 0;

	m.player.fighterstage = 0;
	m.player.fightercount = 0;

	m.player.tempstages = [0,0,0,0,0,0,0,0,0,0];
	m.player.tempawards = [0,0,0,0,0]; // No achievements unlocked yet.

	g.animdelaymax = 1;
	g.animdelay = g.animdelaymax;

	g.planetstage = 0;
	g.towerbombresetting = 0;

	g.displaylevel = 1;
	g.bonuspoints = 0;
	g.bonuslife1 = false; // 100,000
	g.bonuslife2 = false; // 500,000
	g.canvas.style.backgroundColor = "#000000";
	g.stagename = "";
	g.introtextspeed = 0.75;
	g.bombblast = 0;

	intro(); 
	//planetSelect();
	setAdverts(false, false);
};

function setLevel()
{
	wipe(true);

	g.wilf = 0;

	g.level ++; if (g.level >= 10) { g.mode = "planetselect"; }

	g.lasercooldown = 0;
	g.alienbombcooldown = 0;

	g.spawnnextthinkmax = 20;
	g.spawnnextthink = g.spawnnextthinkmax;
	
	g.wavetype = 1;

	g.textblink = 10;

	g.shotsfired = 0;
	g.hitratio = 0;
	setClouds();
	playerStart();

	g.cadet = 0;
	g.cadetresetting = 150;

	g.stagename = stageName();
	g.resetting = 200;
	setSky();
	setFloorColours();
	resetTower();

	g.saucerbombcooldownmax = 50 - (g.level * 2);
	g.saucerbombcooldown = g.saucerbombcooldownmax;

	g.displayplanet = rnd(100) < 50 ? true : false;
	if (g.displayplanet)
	{
		g.planetx = rnd(g.canvaswidth / 2);
		g.planety = rnd(20);
		g.planetw = 100 + rnd(156);
	}

	m.player.lives = 3;
	m.player.crystals = 0;
	m.player.damage = 0; // used for awards calculation
	m.player.turretstoshoot = 0; // used for awards calculation
	m.player.turrets = 0; // used for awards calculation
	m.player.showplanet = false;
	m.player.healing = 0;

	g.mode = "newstage";
	g.levelticker = 0;
	g.leveltime = 0;

};

function playerStart()
{
	wipe();

	m.player.basex = (g.canvaswidth / 2) - (m.player.w / 2);
	m.player.basey = g.canvasheight - 160;

	m.player.x = m.player.basex;
	m.player.y = g.canvasheight;

	m.player.targetx = g.textcentre - (m.player.w / 2);
	m.player.targety = g.canvasheight - 80;
	
	m.player.w = m.player.spritesheet.framewidth;
	m.player.h = m.player.spritesheet.frameheight;
	m.player.blastoff = false;

	m.player.visible = true;
	m.player.dying = false;
	m.player.retiring = false;

	m.player.energy = Math.floor(m.player.energymax);
	m.player.speed = Math.floor(m.player.maxspeed);
	m.player.lasers = Math.floor(m.player.maxlasers);

	m.player.showflag = [];

	g.resetting = 10;

	m.player.inpain = 0;

};

function playerDeath(o)
{
	wipe();
	if (m.player.dying) return;
	m.player.dying = true;
	m.player.lives --;
	if (m.player.lives < 0) { 
		m.player.lives = 0; 
		g.textindex = rnd(defeatedtext.length)-1;
	}
	g.resetting = 2;
	g.cadetresetting = 150;
};

function endLevel()
{
	try
	{
		if (g.level + 1 <= m.player.stages[g.planetstage].length) { m.player.stages[g.planetstage][g.level + 1] = 1; }
		
		m.player.showaward = [false,false,false];

		m.player.tempawards = [
			1,
			m.player.stageawards[g.planetstage][g.level][1],
			m.player.stageawards[g.planetstage][g.level][2]
		];
		if (m.player.stageawards[g.planetstage][g.level][0] != 1) { 
			m.player.tempawards[0] = 1; 
			m.player.stageawards[g.planetstage][g.level][0] = 1; 
			m.player.showaward[0] = true;
			m.player.showflag[0] = false;
			m.player.targetcredits += Math.round(g.awardBonus[0]);
		}
		if (m.player.lives == 3 && m.player.stageawards[g.planetstage][g.level][1] != 1) { 
			m.player.tempawards[1] = 1; 
			m.player.stageawards[g.planetstage][g.level][1] = 1; 
			m.player.showaward[1] = true; 
			m.player.showflag[1] = false;
			m.player.targetcredits += Math.round(g.awardBonus[1]);
		}
		if (m.player.energy == m.player.energymax && m.player.lives == 3 && m.player.stageawards[g.planetstage][g.level][2] != 1) { 
			m.player.tempawards[2] = 1; 
			m.player.stageawards[g.planetstage][g.level][2] = 1; 
			m.player.showaward[2] = true; 
			m.player.showflag[3] = false;
			m.player.targetcredits += Math.round(g.awardBonus[2]);
		}
		if (g.leveltime < m.player.stagetimes[g.planetstage][g.level])
		{
			m.player.stagetimes[g.planetstage][g.level] = g.leveltime;
			m.player.targetcredits += Math.round(g.timeBonus);
			m.player.showtimebonus = true;
		} else {
			m.player.showtimebonus = false;
		}

		m.player.credits = m.player.targetcredits;

		exportData();
		g.textindex = rnd(herotext.length) - 1;
	}
	catch (e)
	{
		write("End level: " + e.message);
	}
};

function quitGame(t)
{
	exportQuickData(m.player.credits,m.player.energymax,m.player.maxlasers,m.player.maxspeed);
	g.pausemode = 0;
	switch(t)
	{
		case 0:
			g.mode = "planetselect";
			g.resetting = 100;
			g.textblink = 0;
			g.pausemode = 0;
			g.level = -1;
		break;
		case 1:
			g.mode = "stageselect";
			g.resetting = 100;
			g.textblink = 0;
			g.pausemode = 0;
			g.level = -1;
		break;
		case 2:
			setTitle();
		break;
		case 3:
			setShop();
		break;
		case 4:
			wipe(false);
			intro();
		break;
		case 5:
			g.mode = "cutscene";
			g.resetting = 500;
			for (var a=0;a < 4;a++)
			{
				m.motherships[a].x = m.motherships[a].targetx;
				m.motherships[a].y = m.motherships[a].targety;
			}
		break;
		case 6:
			g.mode = "gamecomplete";
			g.resetting = 500;
			g.sequencetimer = 0;
			g.sequence = 0;
		break;
	}
};

function bounceFighter()
{
	m.player.fighterstage = 3;
	m.player.fightercount = 1;
};

/* --------------------------------------------------------------------------------- */
/* --------------------------------------------------------------------------------- */

function loop()
{
	try
	{
		clearTimeout(g.ticker);

		switch (g.mode)
		{
			case "splash":
				g.ctx.drawImage(g.splash,0,0);
				g.resetting --;
				if (g.resetting < 1)
				{
					setTitle();
				}
			break;
			case "title":
				//g.ctx.drawImage(g.titleback,0,0);
				drawBackdrop();
				planetSurface();

				staging();
				for (var a=0;a < NUM.aliens;a++)
				{
					moveAlien(m.aliens[a]);
					drawAlien(m.aliens[a]);
				}

				g.ctx.drawImage(g.titlescreen,0,0);
				g.textblink --;
				if (g.textblink < (g.textblinkmax / 4) * 3)
				{
					writeText(textdata[1],g.textcentre,g.horizon + 32,18,GAMEFONT,"#ffffff","center",null,"#083760");
					if (g.textblink < 0) g.textblink = g.textblinkmax;
				}
				writeText(textdata[0],g.textcentre,g.horizon + 66,14,GAMEFONT,"#ffffff","center",null,"#083760");
			break;
			case "cutscene":
				g.resetting --; 
				if (g.resetting < 1) 
				{ 
					quitGame(g.destroymothership == 3 ? 6 : 0); 
				}
				g.ctx.drawImage(g.intrographic,0,0);
				g.ctx.drawImage(g.planet,0,((4 - (g.resetting > 200 ? g.destroymothership : g.destroymothership + 1)) * 136),136,136,g.textcentre-68,100,136,136);

				for (var a=g.destroymothership;a < 4;a++)
				{
					if (g.resetting < 200)
					{
						if (a != g.destroymothership)
						{
							drawMothership(m.motherships[a]);
						}
					} else {
						drawMothership(m.motherships[a]);
					}
				}
				if (g.resetting > 200 && g.resetting % 10 == 0)
				{
					spawnMothershipExplosion(m.motherships[g.destroymothership]);
					m.motherships[g.destroymothership].inpain = 2;
				} 
				if (g.resetting < 200)
				{
					showCharacter(3,cutsequence[g.destroymothership], 20, 260);
				}
				for (var a=0;a < NUM.explosions;a++)
				{
					moveExplosion(m.explosion[a]);
					drawExplosion(m.explosion[a]);
				}
			break;
			case "gamecomplete":
				g.resetting --; if (g.resetting < 1) { quitGame(0); }
				g.ctx.drawImage(g.intrographic,0,0);
				g.ctx.drawImage(g.planet,0,0,136,136,g.textcentre-68,100,136,136);
				
				g.sequencetimer --;
				if (g.sequencetimer < 1)
				{
					g.sequence ++;
					if (g.sequence == endsequence.length)
					{
						quitGame(0);
					} else {
						g.sequencetimer = endsequence[g.sequence].timer;
					}
				} else {
					var ch = endsequence[g.sequence].character;
					var txt = endsequence[g.sequence].text;
					showCharacter(ch,txt,20, 260);
				}
			break;
			case "intro":
				if (g.sequence < 3)
				{
					g.ctx.drawImage(g.intrographic,0,0);
					if (g.sequence > 1)
					{
						for (var a=0;a < NUM.fighters;a++)
						{
							moveFighter(m.fighters[a]);
							drawFighter(m.fighters[a]);
						}
					}
					g.ctx.drawImage(g.planet,0,(g.planetdamage * 136),136,136,g.textcentre-68,100,136,136);

					for (var a=0;a < NUM.explosions;a++)
					{
						moveExplosion(m.explosion[a]);
						drawExplosion(m.explosion[a]);
					}
					for (var a=0;a < NUM.motherships;a++)
					{
						moveMothership(m.motherships[a]);
						drawMothership(m.motherships[a]);
					}
				} else {
					fillRectangle("#000000",null,0,0,g.canvaswidth,g.canvasheight);
					for (var a=0;a<NUM.stars;a++) { moveStar(stars[a]); drawStar(stars[a]); }
					for (var a=0;a < NUM.fighters;a++)
					{
						var f = m.fighters[a];
						if (g.sequence >= 14)
						{
							if (f.sprite.x < (g.canvaswidth + 1024))
							{
								f.sprite.warp += 1;
								if (f.sprite.warp > 5) { f.sprite.warp = 5; }
							} else {
								f.sprite.warp -= 1;
								if (f.sprite.warp < 0) { f.sprite.warp = 0; }
							}
							if (f.sprite.warp > 0)
							{
								fillRectangle("#f6cf4a",null,0,f.sprite.y + ((20-f.sprite.warp) * f.sprite.scale),f.sprite.x,f.sprite.warp*2);
							}
						}
						g.ctx.drawImage(g.fighter,0,128,f.sprite.w,f.sprite.h,f.sprite.x,f.sprite.y,f.sprite.w * f.sprite.scale,f.sprite.h * f.sprite.scale);
						f.sprite.x += g.sequence >= 15 ? f.sprite.speed * 700 : f.sprite.speed;
					}
				}

				if (m.motherships[0].inposition && m.motherships[1].inposition && m.motherships[2].inposition && m.motherships[3].inposition)
				{
					if (g.resetting > 0) { g.resetting --; }
					if (g.resetting > 600 && g.resetting % 10 == 0)
					{
						spawnIntroExplosion();
					} else {
						if (rnd(100) < 5)
						{
							spawnIntroExplosion();
						}
					}
					if (g.resetting < 900) { g.planetdamage = 1; } 
					if (g.resetting < 850) { g.planetdamage = 2; } 
					if (g.resetting < 800) { g.planetdamage = 3; } 
					if (g.resetting < 750) { g.planetdamage = 4; } 

				}

				g.sequencetimer --;
				if (g.sequencetimer < 1)
				{
					g.sequence ++;
					if (g.sequence == introsequence.length)
					{
						quitGame(0);
					} else {
						g.sequencetimer = introsequence[g.sequence].timer;
					}
				} else {
					var ch = introsequence[g.sequence].character;
					var txt = introsequence[g.sequence].text;
					showCharacter(ch,txt,20, 260);
				}
				if (g.sequence > 0) { writeText(textdata[10],g.textcentre,16,16,GAMEFONT,"#eeeeee","center",null,"#000000"); }

			/*
				for (var a=0;a<NUM.stars;a++) { moveStar(stars[a]); drawStar(stars[a]); }

				g.ctx.drawImage(g.mothership,g.mothershipx,g.mothershipy);
				g.mothershipx += 0.25;
				if (g.resetting < 990)
				{
					writeText(textdata[10],g.textcentre,16,16,GAMEFONT,"#eeeeee","center",null,"#000000");
				}
			*/
			break;
			case "planetselect":
				if (g.resetting > 0) { g.resetting --; }

				g.ctx.drawImage(g.planetselect,0,0);
				writeText(textdata[9],g.textcentre,20,18,GAMEFONT,"#ffffff","center",null,"#083760");

				if (g.textblink > 0) // planet has been selected
				{
					g.textblink --;
					if (g.textblink < 1)
					{
						chooseStage();
					} else {
						//if (g.textblink % 5 === 0)
						{
							var y = (50 + (g.planetstage * 80)) + 55;
							g.ctx.drawImage(g.planets[g.planetstage],35,50 + (g.planetstage * 80));
							fillRectangle("255,165,40",0.4,37,52 + (g.planetstage * 80),246,46);
							writeText(planetdata[g.planetstage].name,g.textcentre,y - 30,18,GAMEFONT,"#FFC23F","center",null,"#222222");
						}
					}
				} else {
					for (var a=0;a < 4;a++)
					{
						var y = (50 + (a * 80)) + 55;
						g.ctx.drawImage(g.planets[a],35,50 + (a * 80));
						writeText(planetdata[a].name,g.textcentre,y - 30,18,GAMEFONT,"#ffffff","center",null,"#222222");
						if (m.player.planets[a] < 1)
						{
							fillRectangle("0,0,0",0.8,35,50 + (a * 80), 250,50);
							g.ctx.drawImage(g.padlock,g.canvaswidth - 80, 58 + (a * 80));
						}
					}
				}
				
				for (var a=0;a<dots.length;a++) { moveDot(dots[a]); drawDot(dots[a]); }

			break;
			case "stageselect":
				if (g.resetting > 0) { g.resetting --; }

				drawBackdrop();
				planetSurface();
				fadeScreen(60);
				//g.ctx.drawImage(g.levelselect,0,0);
				g.ctx.drawImage(g.back,8,8);
				g.ctx.drawImage(g.credit,g.canvaswidth-70,8);
				g.ctx.drawImage(g.forward,g.canvaswidth-36,8);
				writeText(textdata[14],g.textcentre,24,18,GAMEFONT,"#ffffff","center",null,"#083760");

				if (g.textblink > 0) // stage has been selected
				{
					g.textblink --;
					if (g.textblink < 1)
					{
						setLevel();
					} else {
						//if (g.textblink % 5 === 0)
						{
							var x = g.level % 2 != 0 ? 16 : 176;
							var y = 64;
							switch (g.level)
							{
								case -1:
								case 0:
									y = 64;
									break;
								case 1:
								case 2:
									y = 128;
									break;
								case 3:
								case 4:
									y = 192;
									break;
								case 5:
								case 6:
									y = 256;
									break;
								case 7:
								case 8:
									y = 320;
									break;
							}
							g.ctx.drawImage(g.stageicon,0,g.planetstage*48,128,48,x,y,128,48);
							fillRectangle("255,165,40",0.4,x+2,y+2,124,44);
							writeText(g.level + 2,x + 80,y + 18,18,GAMEFONT,"#FFC23F","left",null,"#222222");
						}
					}
				} else {
					var col = 0;
					var row = 0;
					for (var a=0;a < 10;a++)
					{
						col += 1;
						if (col > 2) { row += 1; col = 1; }
						
						var x = col == 1 ? 16 : 176;
						var y = 64 + (row * 64);
						var h1 = Math.round(g.planetstage*48)+48;

						g.ctx.drawImage(g.stageicon,0,g.planetstage*48,128,48,x,y,128,48);
						writeText(a + 1,x + 80,y + 18,18,GAMEFONT,"#ffffff","left",null,"#333333");
						writeText(textdata[2] + " " + m.player.stagetimes[g.planetstage][a] + " " + textdata[6],x + 2,y + 50,10,TEXTFONT,"#F08030","left",null,null);
						if (m.player.stages[g.planetstage][a] == "0")
						{
							fillRectangle("0,0,0",0.8,x,y,128,48);
							g.ctx.drawImage(g.padlock,x + 110, y + 32);
						}
						for (var b = 0;b < 3;b++)
						{
							if (m.player.stageawards[g.planetstage][a][b] == "1")
							{
								g.ctx.drawImage(g.stageawardon,8+x+(b*18),y+22);
							} else {
								g.ctx.drawImage(g.stageawardoff,8+x+(b*18),y+22);
							}
						}
					}
				}
				
				for (var a=0;a<dots.length;a++) { moveDot(dots[a]); drawDot(dots[a]); }

			break;
			case "shop":
				if (g.resetting > 0) { g.resetting --; }

				fillRectangle("#000000",null,0,g.horizon,g.canvaswidth,(g.canvasheight/2));
				for (var a=0;a<NUM.stars;a++) { moveStar(stars[a]); drawStar(stars[a]); }
				g.ctx.drawImage(g.shopback,0,0);
				g.ctx.drawImage(g.back,8,8);
				//writeText(textdata[15],g.textcentre,24,18,GAMEFONT,"#ffffff","center",null,"#0829F7");

				g.ctx.drawImage(g.credit,g.textcentre - 42, 8);
				writeText(m.player.credits,g.textcentre - 6,24,24,GAMEFONT,"#ffffff","left",null,null);
				showCharacter(g.cadet,shoptext[g.cadet],20,46);
				g.animdelay -= 1;
				if (g.animdelay < 1)
				{
					g.animdelay = g.animdelaymax;
					if (m.player.credits > m.player.targetcredits) { m.player.credits = m.player.targetcredits; }
				}

				/*
					LASERS
				*/
				writeText(g.shop[0].item,g.textcentre,114,14,GAMEFONT,g.colours[5],"center",null,"#000000");
				g.ctx.drawImage(g.upgradelasers,0,128);
				if (m.player.maxlasers < 3)
				{
					writeText(g.shop[0].cost[m.player.maxlasers],g.textcentre + 16,142,14,GAMEFONT,"#ffffff","left",null,"#000000");
				} else {
					fillRectangle("0,0,0",0.5,0,128,g.canvaswidth,32);
				}

				var x1 = g.textcentre - 36;
				var y1 = 165;
				for (var a=0;a < 4;a++)
				{
					fillRectangle("255,165,30",(a <= m.player.maxlasers ? 1.0 : 0.3),x1,y1,16,6);
					x1 += 18;
				}

				/*
					ENERGY
				*/
				writeText(g.shop[1].item,g.textcentre,186,14,GAMEFONT,g.colours[4],"center",null,"#000000");
				g.ctx.drawImage(g.upgradeenergy,0,200);
				if (m.player.energymax < 10)
				{
					writeText(g.shop[1].cost[m.player.energymax],g.textcentre + 16,214,14,GAMEFONT,"#ffffff","left",null,"#000000");
				} else {
					fillRectangle("0,0,0",0.5,0,200,g.canvaswidth,32);
				}
				var x2 = g.textcentre - 54;
				var y2 = 237;
				for (var a=0;a < 6;a++)
				{
					fillRectangle("255,165,30",(a + 5 <= m.player.energymax ? 1.0 : 0.3),x2,y2,16,6);
					x2 += 18;
				}

				/*
					SPEED
				*/
				writeText(g.shop[2].item,g.textcentre,258,14,GAMEFONT,g.colours[1],"center",null,"#000000");
				g.ctx.drawImage(g.upgradespeed,0,272);
				if (m.player.maxspeed < 10)
				{
					writeText(g.shop[2].cost[m.player.maxspeed],g.textcentre + 16,286,14,GAMEFONT,"#ffffff","left",null,"#000000");
				} else {
					fillRectangle("0,0,0",0.5,0,272,g.canvaswidth,32);
				}
				var x3 = g.textcentre - 63;
				var y3 = 309;
				for (var a=0;a < 7;a++)
				{
					fillRectangle("255,165,30",(a + 4 <= m.player.maxspeed ? 1.0 : 0.3),x3,y3,16,6);
					x3 += 18;
				}
				
				for (var a=0;a<dots.length;a++) { moveDot(dots[a]); drawDot(dots[a]); }
				for (var a=0;a <NUM.textsprites;a++)
				{
					moveTextSprite(m.textsprites[a]);
					drawTextSprite(m.textsprites[a]);
				}
				g.ctx.drawImage(g.fighter,0,(m.player.fighterstage * 32),100,32,g.textcentre-50,Math.round((g.canvasheight - 108) + (m.player.fighterstage * 1)),100,32);
				if (m.player.fighterstage > 0)
				{
					m.player.fightercount --;
					if (m.player.fightercount < 1)
					{
						m.player.fighterstage -= 1;
						m.player.fightercount = 2;
					}
				}

			break;
			case "newstage":
				drawBackdrop();
				planetSurface();
				drawHaze();
				g.resetting --;
				if (g.resetting < 1) 
				{ 
					g.mode = "pregame";
					g.textindex = rnd(instructiontext.length)-1;
				}

				if (g.resetting <= 100)
				{
					fadeScreen(100-g.resetting);
					writeText(textdata[12] + " " + planetdata[g.planetstage].name,g.textcentre,148,20,GAMEFONT,"255,255,0","center",g.resetting,"#222222");
					writeText(textdata[13] + " " + (g.level+1),g.textcentre,180,16,GAMEFONT,"255,255,255","center",g.resetting,null);
					//writeText(planetdata[g.planetstage].stages[g.level],g.textcentre,210,18,GAMEFONT,"110,210,240","center",g.resetting,null);
					//writeText(textdata[4],g.textcentre,240,18,GAMEFONT,"255,255,255","center",g.resetting,null);
				} else {
					fadeScreen(0);
					writeText(textdata[12] + " " + planetdata[g.planetstage].name,g.textcentre,148,20,GAMEFONT,"255,255,0","center",200 - g.resetting,"#222222");
					writeText(textdata[13] + " " + (g.level+1),g.textcentre,180,16,GAMEFONT,"255,255,255","center",200 - g.resetting,null);
					//writeText(planetdata[g.planetstage].stages[g.level],g.textcentre,210,18,GAMEFONT,"110,210,240","center",200 - g.resetting,null);
					//writeText(textdata[4],g.textcentre,240,18,GAMEFONT,"255,255,255","center",200 - g.resetting,null);
				}
			break;
			case "pregame":
				drawBackdrop();
				planetSurface();
				drawHaze();
				movePlayer(m.player);
				drawPlayer(m.player);
				g.resetting --;
				if (g.resetting < 1) 
				{ 
					g.resetting = 0;
					g.cadetresetting --;
					if (g.cadetresetting < 1)
					{
						g.mode = "game";
						g.resetting = 3;
					}
					showCharacter(4,instructiontext[g.textindex],20, 90);
				}

				for (var a=0;a < NUM.lasers;a++)
				{
					moveLaser(m.lasers[a]);
					drawLaser(m.lasers[a]);
				}
				
				updateScore();
				playerLives();
			break;
			case "game":
				
				drawBackdrop();
				planetSurface();
				if (g.nextthink > 0) g.nextthink --;

				if (m.player.dying)
				{
					g.resetting --;
					if (g.resetting < 1)
					{
						if (m.player.lives < 1)
						{
							g.cadetresetting --;
							if (g.cadetresetting < 1)
							{
								g.mode = "gameover";
								g.resetting = 200;
								exportQuickData(m.player.credits,m.player.energymax,m.player.maxlasers,m.player.maxspeed);
								setAdverts(true, true);
							}
							showCharacter(0,defeatedtext[isNaN(g.textindex) ? 0 : g.textindex],20, 90);
						} else {
							playerStart();
							g.mode = "pregame";
						}
					}
				}

				if (g.mode != "pregame") // check we've not skipped game modes between cadets
				{
					if (!m.player.retiring) { playerLasers(); }

					//g.alienbombcooldown --;
					//if (g.alienbombcooldown < 1) g.alienbombcooldown = 20;

					for (var a=0;a<dots.length;a++) { moveDot(dots[a]); drawDot(dots[a]); }

					staging();

					for (var a=0;a < NUM.powerups;a++)
					{
						movePowerup(m.powerups[a]);
						drawPowerup(m.powerups[a]);
						playerPowerupCollision(m.powerups[a],m.playershadow,m.player);
					}

					for (var a=0;a < NUM.saucers;a++)
					{
						moveSaucer(m.saucers[a]);
						drawSaucer(m.saucers[a]);
					}

					for (var a=0;a < NUM.probes;a++)
					{
						moveProbe(m.probes[a]);
						drawProbe(m.probes[a]);
					}

					drawHaze();
					for (var a=0;a < NUM.lasers;a++)
					{
						moveLaser(m.lasers[a]);
						drawLaser(m.lasers[a]);
						probeMissileCollision(m.lasers[a]);
						saucerMissileCollision(m.lasers[a]);
						alienMissileCollision(m.lasers[a]);
						obstacleMissileCollision(m.lasers[a]);
						missileTowerCollision(m.lasers[a]);
						missileAlienBombCollision(m.lasers[a]);
					}

					for (var a=0;a <NUM.alienbombs;a++)
					{
						moveAlienBomb(m.alienbomb[a]);
						drawAlienBomb(m.alienbomb[a]);
						alienBombCollision(m.alienbomb[a],m.player);
					}

					for (var a=0;a < NUM.aliens;a++)
					{
						moveAlien(m.aliens[a]);
						drawAlien(m.aliens[a]);
						alienPlayerCollision(m.aliens[a],m.player);
					}

					for (var a=0;a < NUM.obstacles;a++)
					{
						moveObstacle(m.obstacles[a]);
						drawObstacle(m.obstacles[a],0);
						playerObstacleCollision(m.obstacles[a],m.player);
					}

					for (var a=0;a <NUM.textsprites;a++)
					{
						moveTextSprite(m.textsprites[a]);
						drawTextSprite(m.textsprites[a]);
					}

					for (var a=0;a <NUM.coins;a++)
					{
						moveCoin(m.coins[a]);
						drawCoin(m.coins[a]);
						coinCollision(m.coins[a],m.player);
					}

					movePlayer(m.player);
					drawPlayer(m.player);

					for (var a=0;a < NUM.obstacles;a++)
					{
						drawObstacle(m.obstacles[a],1);
					}
					for (var a=0;a < NUM.explosions;a++)
					{
						moveExplosion(m.explosion[a]);
						drawExplosion(m.explosion[a]);
					}

					if (g.bombblast > 0)
					{
						colourScreen(g.bombblast,"246,189,78");
						g.bombblast -= 10;
					}

					updateScore();
					playerLives();
					if (g.towerinrange)
					{
						var dd = 0;
						if (!g.towerfalling)
						{
							dd = Math.round((new Date() - g.leveltime) / 1000);
							writeText(dd + " " + textdata[6],g.textcentre,160,18,SCOREFONT,"#ffff00","center",null,"#000000");
						} else {
							if (g.leveltime < m.player.stagetimes[g.planetstage][g.level]) 
							{
								g.textblink --;
								if (g.textblink < (g.textblinkmax / 4) * 3)
								{
									writeText(textdata[7],g.textcentre,160,18,SCOREFONT,"#ffff00","center",null,"#000000");
									writeText(g.leveltime + " " + textdata[6],g.textcentre,180,18,SCOREFONT,"#ffff00","center",null,"#000000");
									if (g.textblink < 0) g.textblink = g.textblinkmax;
								}
							}
						}
					}

					if (g.cadetresetting > 0 && !m.player.dying)
					{
						g.cadetresetting --;
						if (m.player.retiring)
						{
							if (g.cadetresetting < 1)
							{
								playerDeath();
							}
							showCharacter(m.player.lives-1,damagedtext[g.textindex],20, 90);
						} else
						{
							showCharacter(4,targetapproachtext[g.textindex],20, 90);
						}
					}

					energyBar();

					if (rnd(100) < 2) { spawnProbe(); }
				}

				if (g.towerfalling)
				{
					fillRectangle("208,0,0",0.5,0,0,g.canvaswidth,g.canvasheight);
				}		

			break;

			case "landscape":
			break;
			case "levelup":
				g.resetting --;
				if (g.resetting < 0)
				{
					if (m.player.showplanet || m.player.gamecomplete) { quitGame(5); } else { quitGame(1); } //setLevel(); }
				} else {
					drawBackdrop();
					planetSurface();
					drawHaze();
					updateScore();
					playerLives();
				}
				for (var a=0;a < m.textsprites.length;a++)
				{
					moveTextSprite(m.textsprites[a]);
					drawTextSprite(m.textsprites[a]);
				}
				movePlayer(m.player); 

				if (g.resetting > 100)
				{
					fadeScreen(100-(200-g.resetting));
					writeText(textdata[5],g.textcentre,32,20,GAMEFONT,"255,255,255","center",200 - g.resetting,"#0829F7");
				} else {
					fadeScreen(0);
					writeText(textdata[5],g.textcentre,32,20,GAMEFONT,"#ffffff","center",null,"#0829F7");
				}
				drawPlayer(m.player);

				if (m.player.showplanet)
				{
					writeText(textdata[11] + " " + textdata[12] + ": " + planetdata[g.planetstage+1].name,g.textcentre,58,14,GAMEFONT,"#ffffff","center",null,null);
					writeText("+" + (Math.round((g.planetstage + 1) * 1000)) + " " + textdata[16],g.textcentre,80,18,GAMEFONT,g.colours[rnd(g.colours.length)-1],"center",null,null);
				}

				showCharacter(4,herotext[g.textindex],20, 96);
				
				if (m.player.showtimebonus)
				{
					writeText(textdata[18] + " +" + g.timeBonus + " " + textdata[16],g.textcentre,240,18,GAMEFONT,g.colours[rnd(g.colours.length)-1],"center",null,null);
				}

				//writeText(planetdata[g.planetstage].name,g.textcentre,240,18,GAMEFONT,"#ffffff","center",null,null);
				//writeText(textdata[13] + " " + (g.level + 1) + " " + textdata[17],g.textcentre,260,14,GAMEFONT,"#ffff00","center",null,null);

				//writeText(planetdata[g.planetstage].stages[g.level],g.textcentre,260,14,GAMEFONT,"#ffff00","center",null,null);

				g.ctx.drawImage(g.credit,g.textcentre - 36, 280);
				writeText(m.player.credits + " " + textdata[16],g.textcentre,294,20,GAMEFONT,"#6dd7ff","left",null,null);

				var y = 298;
				for (var a=0;a < 3;a++)
				{
					if (m.player.showaward[a] == true)
					{
						y += 18;
						writeText("+" + g.awardBonus[a] + " " + textdata[16],g.textcentre - 100,y+8,14,GAMEFONT,"#ffff00","left",null,null);
						g.ctx.drawImage(g.stageawardon,g.textcentre-32, y);
						writeText(awardtext[a],g.textcentre,y+8,12,GAMEFONT,"#ffffff","left",null,null);
						if (m.player.showflag[a] == false)
						{
							UIDotExplosionXY(g.textcentre,y+18);
							m.player.showflag[a] = true;
						}
					}
				}

				for (var a=0;a<dots.length;a++) { moveDot(dots[a]); drawDot(dots[a]); }

			break;
			case "gameover":
				drawBackdrop();
				planetSurface();
				drawHaze();
				writeText(textdata[3],g.textcentre,128,24,GAMEFONT,"#ffcd36","center",null,"#222");
				g.resetting --;
				if (g.resetting < 1)
				{
					setTitle();
				}
				updateScore();
			break;
		}
		
		if (g.mode == "game" && !g.towerfalling) { 
			g.ctx.drawImage(g.playpause, g.pausemode * 32, 0, 32, 32, 8, 8, 32, 32); 
		}

		if (g.pausemode > 0)
		{
			fillRectangle("0,0,0",0.5,0,0,g.canvaswidth,g.canvasheight);
			for (var a=0;a < pausetext.length;a++)
			{
				writeText(pausetext[a],g.textcentre,(g.pausemenuorigin + 17 ) + (a*34),18,GAMEFONT,g.lasercolours[3+a],"center",null,"#222222");					
			}
		}		

		if (isNaN(g.framedelay)) g.framedelay = 30;
		
		g.ticker = setTimeout("loop()", g.framedelay);
	}
	catch (e)
	{
		write("Loop: " + e.message);
	}
};

function testFPS()
{
	try
	{
		// FPS
		if (isNaN(g.fps)) g.fps = 0;
		if (g.fps) 
		{
			var d = new Date();
			var c = Math.round(1000 / (d - g.fps));
		}
		var s = new String(c);
		g.fps = new Date();
		//if (c) writeString(s,220,g.canvasheight - 128);
		if (isNaN(g.testy)) g.testy = 0;
		if (isNaN(g.ave)) g.ave = 0;
		if (g.testy < 20) 
		{ 
			g.testy ++; g.ave += c; 
			if (g.testy >= 10)
			{
				if (g.ave > 1000) g.framedelay = 42; // throttle the fast devices
			}
		}
	}
	catch (e)
	{
		write(e.message);
	}
};

/* ------------------------------------------------------------------------------------------- */
/* --------------------------------------- GAME ---------------------------------------------- */
/* ------------------------------------------------------------------------------------------- */

function createFloor()
{
	try
	{
		floors[0] = new floor("floor0", 0, g.horizon, g.canvaswidth, 0, 0.5);
		floors[1] = new floor("floor1", 0, g.horizon + 10, g.canvaswidth, 10, 0.5);
		floors[2] = new floor("floor2", 0, g.horizon + 40, g.canvaswidth, 20, 0.5);
		floors[3] = new floor("floor3", 0, g.horizon + 100, g.canvaswidth, 80, 0.5);
		setFloor();
	}
	catch (e)
	{
		write("createFloor: " + e.message);
	}
};

function setClouds()
{
	spawnCloud(16,g.horizon - 140, 0.1);
	spawnCloud(192,g.horizon - 160, 0.1);
};

function resetTower()
{
	g.towerheight = 2;
	g.towerwidth = 1;
	g.towercolour = "#333333";
	g.towerhp = 40 + (g.planetstage * 40);
	g.towerhpmax = g.towerhp;
	g.towerfalling = false;
	g.towerinrange = false;
	g.towerdefense = true;
	g.energytowers = 10;
	g.mountainsy = g.horizon - 75;
	g.towerpain = 0;
};

function setFloor()
{
	try
	{
		for (var a=0;a<floors.length;a++) 
		{ 
			floors[a].x = floors[a].basex;
			floors[a].y = floors[a].basey; 
			floors[a].w = floors[a].basew;
			floors[a].h = floors[a].baseh; 
			floors[a].speed = floors[a].basespeed;
		}
	}
	catch (e)
	{
		write("SetFloor: " + e.message);
	}
};

function setSky()
{
	try
	{
		var r = g.planetstage;
		g.levelcolour[0] = g.skycolours[r][0];
		g.levelcolour[1] = g.skycolours[r][1];
		g.levelcolour[2] = g.skycolours[r][2];
		g.levelcolour[3] = g.skycolours[r][3];
		g.levelcolour[4] = g.skycolours[r][4];
	}
	catch (e)
	{
		write("set sky: " + e.message);
	}
};

function setFloorColours()
{
	try
	{
		var cc = g.floorcolours[g.planetstage != null ? g.planetstage : 0]; 
		for (var a=0;a<floors.length;a++) 
		{ 
			floors[a].colour = cc[0];
		}
		g.floorcolour = cc[1];
	}
	catch (e)
	{
		write("set floor colours: " + e.message);
	}
};

function alienBonus(a)
{return;
	var bonus = 0;
	bonus = Math.round(a.y * 10);
	if (bonus > 3000)
	{
		spawnTextSpriteXY(a.x,a.y-24,"X5 BONUS!");
		bonus = bonus * 5;
	} else if (bonus > 2500)
	{
		spawnTextSpriteXY(a.x,a.y-24,"X2 BONUS!");
		bonus = bonus * 2;
	}
	spawnTextSprite(a,bonus);
	m.player.score += bonus;
	m.player.targetscore = m.player.score;
	m.player.targetscore += 10;
};


function playerDamage(d,o)
{
	try
	{
		m.player.inpain = 4;
		m.player.energy -= d;
		m.player.damage += 1; // for awards calculation - REDUNDANT
		if (m.player.energy <= 0)
		{
			m.player.retiring = true;
			g.cadetresetting = 100;
			g.textindex = rnd(damagedtext.length)-1;
		} else {
			m.player.y = m.player.basey + 8;
		}
	}
	catch (e)
	{
		write("Player damage: " + e.message);
	}
};

function alienKill(o)
{
	try
	{
		if (o.spritesheet.type === "saucer")
		{
			spawnTowerExplosion(o.x,o.y);
			spawnTowerExplosion(o.x + 24,o.y);
		} else if (o.spritesheet.type == "alien")
		{
			dotExplosion(o);
		} else {
			spawnExplosionXY(o.x,o.y,0,1,o);
		}
	}
	catch (e)
	{
		write("Alien kill: " + e.message);
	}
};

function drawHaze()
{
	if (!g.towerfalling) { g.ctx.drawImage(g.haze,0,(g.planetstage * 64),320,64,0,g.horizon-10,320,64); }
};

function drawBackdrop()
{
	try
	{
		g.ctx.save();
		/* Sky */
		/*
				g.sky.addColorStop(0.6, g.reds[2]);
				g.sky.addColorStop(0.8, g.reds[3]);
		} else {
				g.sky.addColorStop(0, g.levelcolour[0]);
				g.sky.addColorStop(0.5, g.levelcolour[1]);
				g.sky.addColorStop(1, g.levelcolour[2]);
		}

		g.ctx.fillStyle = g.sky;
		g.ctx.fillRect(0, 0, g.canvaswidth, g.canvasheight);
		*/

		if (g.towerfalling)
		{
			fillRectangle(g.reds[0],null,0,0,g.canvaswidth,g.horizon);
		} else {
			fillRectangle(g.levelcolour[0],null,0,0,g.canvaswidth,g.horizon-(g.horizon * 0.2));
			fillRectangle(g.levelcolour[1],null,0,g.horizon-(g.horizon * 0.2),g.canvaswidth,g.horizon-(g.horizon * 0.15));
			fillRectangle(g.levelcolour[2],null,0,g.horizon-(g.horizon * 0.15),g.canvaswidth,g.horizon-(g.horizon * 0.1));
			fillRectangle(g.levelcolour[3],null,0,g.horizon-(g.horizon * 0.1),g.canvaswidth,g.horizon-(g.horizon * 0.05));
			fillRectangle(g.levelcolour[4],null,0,g.horizon-(g.horizon * 0.05),g.canvaswidth,g.horizon-(g.horizon * 0.05));
		}

		drawPlanet();

		//if (g.mode != "title")
		//{
			for (var a=0;a < NUM.clouds;a++)
			{
				moveCloud(m.clouds[a]);
				drawCloud(m.clouds[a]);
			}
			moveMountains();
			drawMountains();
			tower();
		//}

		/* Floor */
		fillRectangle(g.towerfalling ? g.reds[0] : g.floorcolour,null,0,g.horizon,g.canvaswidth,g.canvasheight - g.horizon);
		
		g.ctx.restore();
	}
	catch (e)
	{
		write("Draw Backdrop: " + e.message);
	}
};

function tower()
{
	//if (g.mode != "game") return;
	if (g.pausemode > 0) return;
	try
	{
		if (g.towerpain > 0) { g.towerpain --; }
		g.ctx.drawImage(g.towergraphic,g.planetstage * 32, (g.towerpain > 0 ? 150 : 0), 32, 150, g.textcentre - (g.towerwidth / 2),g.horizon-g.towerheight,g.towerwidth,150);
		if (g.towerfalling)
		{
			g.towerpain --;
			if (g.towerpain < 0) { g.towerpain = 4; }
			g.towerheight -= 1;
			g.resetting --;
			if (g.resetting <= 0)
			{
				g.resetting = 10;
				spawnTowerExplosion(g.textcentre - g.towerwidth + rnd(g.towerwidth + 32), g.horizon - 8);
			}
			if (g.towerheight <= 0)
			{
				endLevel();
			}
		} else {
			if (g.mode == "game")
			{
				g.towerheight += (g.towerheight > 90 ? planetdata[g.planetstage].rate * (1 + (0.5 * g.planetstage)) : planetdata[g.planetstage].rate) / 4;
				g.towerwidth += planetdata[g.planetstage].rate/16; 
				if (g.towerwidth > 32) g.towerwidth = 32;
			}

			if (g.towerheight > 120)
			{
				if (!g.towerinrange)
				{
					g.leveltime = new Date();
				}
				g.towerinrange = true;
				if (g.towerheight > 150) { g.towerheight = 150; }

				if (g.mode != "gameover")
				{
					/* Show the damage bar */
					var w = 120 - ((g.towerhp/g.towerhpmax) * 120);
					fillRectangle("111,19,12",0.4,g.textcentre - 64,g.horizon - 50,128,16);
					fillRectangle("#D12424",null,g.textcentre - 60,g.horizon - 46,w,8);
					g.towerbombresetting --;
					if (g.towerbombresetting < 1)
					{
						g.towerbombresetting = 100 - (g.level * 2);
						if (g.planetstage > 0 || g.level > 4) { spawnTowerBomb(); }
					}
				}
			}
			if (g.towerheight >= 110 && g.towerheight <= 112 && g.cadetresetting < 1)
			{
				g.cadetresetting = 150;
				g.textindex = rnd(targetapproachtext.length) - 1;
				while (g.cadet === m.player.lives-1)
				{
					g.cadet = rnd(3)-1;
				}
			}
		}
	}
	catch (e)
	{
		write("Tower: " + e.message);
	}
};

function stageName()
{
	var p1 = ["AN", "TYR", "EN", "XYN"];
	var p2 = ["EN", "IN", "AN", "ES", "IS", "AS"];
	var p3 = ["DUS", "NES", "BAI", "", " DAR", " SOO", " KAI", " KLYN"];
	return p1[rnd(p1.length)-1] + p2[rnd(p2.length)-1] + p3[rnd(p3.length)-1];
};

function planetSurface()
{
	try
	{
		for (var a=0;a<floors.length;a++) { moveFloor(floors[a]); drawFloor(floors[a]); }
	}
	catch (e)
	{
		write("PlanetSurface: " + e.message);
	}
};

function showCharacter(cindex,text, x, y)
{
	try
	{
		if (text != "") { fillRectangle("0,0,0",0.45,0,y-4,g.canvaswidth,72); }
		if (cindex >= 0) { g.ctx.drawImage(g.characters, cindex * 48, 0, 48, 64, x, y, 48, 64); }
		writeText(text,(cindex >=0 ? x + 76 : x),y+10,10,TEXTFONT,(g.mode == "pregame" ? "#ffffff" : "#f8e070"),"left",null,null);
	}
	catch (e)
	{
		write("Show character: " + e.message + ", " + cindex);
	}
};

function playerLasers()
{
	try
	{
		if (g.lasercooldown < 1)
		{
			switch (m.player.lasers)
			{
				case 0:
					spawnLaser(m.player.x + 28, m.player.y - 8,0);
					break;
				case 1:
					spawnLaser(m.player.x + 16, m.player.y - 8,0);
					spawnLaser(m.player.x + m.player.w - 24, m.player.y - 8,1);
					break;
				case 2:
					spawnLaser(m.player.x + 28, m.player.y - 8,0);
					spawnLaser(m.player.x + 16, m.player.y - 8,0);
					spawnLaser(m.player.x + m.player.w - 24, m.player.y - 8,1);
					//spawnLaser(m.player.x, m.player.y - 8,0);
					//spawnLaser(m.player.x + m.player.w - 24, m.player.y - 8,1);
					//spawnLaser(m.player.x + 24, m.player.y - 8,2);
					//spawnLaser(m.player.x + m.player.w, m.player.y - 8,3);
					//spawnLaser(m.player.x - 4, m.player.y - 8,2);
					//spawnLaser(m.player.x + m.player.w, m.player.y - 8,3);
					break;
				case 3:
					spawnLaser(m.player.x + 22, m.player.y - 8,0);
					spawnLaser(m.player.x + m.player.w - 18, m.player.y - 8,1);
					break;
			}
			g.lasercooldown = 14 - (m.player.lasers * 2);
			if (g.lasercooldown < 6) { g.lasercooldown = 6; }
		} else {
			g.lasercooldown --;
		}
	}
	catch (e)
	{
		write("Player lasers: " + e.message);
	}
};

function energyBar()
{
	try
	{
		//writeText(textdata[8],16,72,12,TEXTFONT,"#000000","left",null,null);
		g.ctx.drawImage(g.energyicon,18,58);
		var x = 72;
		for (var a=0;a<m.player.energy;a++)
		{
			g.ctx.drawImage(g.energybar,0,0,20,20,x,64,20,20);
			x += 22;
		}
		for (var a=m.player.energy;a<m.player.energymax;a++)
		{
			g.ctx.drawImage(g.energybar,0,20,20,20,x,64,20,20);
			x += 22;
		}
	}
	catch (e)
	{
		write("Energy bar: " + e.message);
	}
};

function drawPlanet()
{return;
	try
	{
		if (g.displayplanet)
		{
			g.ctx.drawImage(g.planet,0,0,256,256,g.planetx,g.planety,g.planetw,g.planetw);
		}
	}
	catch (e)
	{
		write("Draw planet: " + e.message);
	}
};

function staging()
{
	try
	{
		if (m.player.dying || m.player.dead || g.pausemode > 0 || g.towerfalling) return;
		var thresh = 48;
		g.levelticker ++;
		if (g.levelticker % thresh == 0)
		{
			var c = Math.round(g.levelticker / thresh) - 1;
			if (c <= leveldata[g.planetstage][g.level].length)
			{
				var ln = leveldata[g.planetstage][g.level].length;
				var l = new String();
				l = leveldata[g.planetstage][g.level][ln-c];
				if (l)
				{
					/* Which position is the object in ? */
					var t = [];
					t = l.split(",");
					for (var a=0;a < t.length;a++)
					{
						switch(t[a])
						{
							case "A":
								spawnAlien(80 + (a * 32), g.horizon - 8,g.xmod[a],0);
								break;
							case "B":
								spawnAlien(80 + (a * 32), g.horizon - 8,g.xmod[a],1);
								break;
							case "C":
								spawnAlien(80 + (a * 32), g.horizon - 8,g.xmod[a],rnd(10)<5?2:4);
								break;
							case "D":
								spawnAlien(80 + (a * 32), g.horizon - 8,g.xmod[a],rnd(10)<5?3:5);
								break;
							case "S":
								spawnSaucer(80 + (a * 32), -16,0);
								break;
							case "Z":
								spawnSaucer(80 + (a * 32), -16,1);
								break;
							case "E":
								spawnPowerup(80 + (a * 32), g.horizon,0,g.xmod[a]);
								break;
							case "X":
								spawnPowerup(80 + (a * 32), g.horizon,1,g.xmod[a]);
								break;
							case "I":
								spawnObstacle(80 + (a * 32), g.horizon-16,false,g.xmod[a]);
								break;
							case "T":
								m.player.turretstoshoot ++;
								spawnObstacle(80 + (a * 32), g.horizon-16,true,g.xmod[a]);
								break;
						}
					}
				} 
			} else {
				g.levelticker = 0;
			}
		}
	}
	catch (e)
	{
		write("Staging: " + e.message);
	}
};

function writeString(s,x,y)
{
	var o = m.spritesheets["numberssheet"];
	for (var a=0;a<s.length;a++)
	{
		x += o.framewidth;
		var i = s.substr(a,1);
		g.ctx.drawImage(o.image, i*o.framewidth, 0, o.framewidth, o.frameheight, x, y, o.framewidth, o.frameheight);
	}
};

function writeLevel()
{
	var ph = new String();
	var ph2 = new String(g.level);
	var ls = ph2.length;
	var s = new String();
	
	for (var b = 0; b < ph2.length; b++) s += ph2.substring(b,b+1);
	
	writeString(s,190,200);

};


