/*
	The global namespace is appended with new name/value pairs throughout the game's initiation.
	This data is the core information required to set up the game.
*/


var g = {
	go : 0,
	sky : null,
	levelcolour : [],
	shop : [
	{	
		"item" : "LASERS",
		"cost" : [ 5000,10000,25000 ]
	},
	{
		"item" : "ENERGY",
		"cost" : [ 0,0,0,0,0,750,1500,3500,6000,10000 ]
	},
	{
		"item" : "SPEED",
		"cost" : [ 0,0,0,0,500,1500,3500,6000,10000,15000 ]
	}
	],
	awardBonus : [ 50,150,500 ],
	saucerBonus : [ 20,50 ],
	timeBonus : 250,
	checkSum : gamedata.imageFiles.length,
	checkCount : 0,
	imageData : [],
	audioData : [],
	aliensArray : [],
	mountains : [],
	cadets : [],
	xmod : [ 3.5, 2, 0, -1.8, -4.5 ],
	planets : [],
	pausemenuorigin : 128
}; 

var dots = [];

g.colours = [];
g.colours[0] = "#bf0000";
g.colours[1] = "#4386d0";
g.colours[2] = "#28d98c";
g.colours[3] = "#3de231";
g.colours[4] = "#d8e231";
g.colours[5] = "#feba4f";
g.colours[6] = "#fe5b4f";
g.colours[7] = "#fe4fd7";
g.colours[8] = "#ca4ffe";

g.reds = [];
g.reds[0] = "#a00d0d";
g.reds[1] = "#b63722";
g.reds[2] = "#c7491d";
g.reds[3] = "#d9632f";

g.lasercolours = [];
g.lasercolours[0] = "#bf0000";
g.lasercolours[1] = "#4386d0";
g.lasercolours[2] = "#28d98c";
g.lasercolours[3] = "#ffffaa";
g.lasercolours[4] = "#ffe651";
g.lasercolours[5] = "#ffc51f";
g.lasercolours[6] = "#ff911a";
g.lasercolours[7] = "#E0784A";
g.lasercolours[8] = "#F38E61";

g.superlasercolours = [];
g.superlasercolours[0] = "#eaff00";
g.superlasercolours[1] = "#ea3213";
g.superlasercolours[2] = "#eaff00";

g.skycolours = [];
g.skycolours[0] = [];
g.skycolours[1] = [];
g.skycolours[2] = [];
g.skycolours[3] = [];

/* Blue scheme */
g.skycolours[0][0] = "#70A0D0";
g.skycolours[0][1] = "#80B0E0";
g.skycolours[0][2] = "#90C0E0";
g.skycolours[0][3] = "#90D0E0";
g.skycolours[0][4] = "#B0E0E0";

/* Terracotta scheme */
g.skycolours[1][0] = "#EAB494";
g.skycolours[1][1] = "#EDBC99";
g.skycolours[1][2] = "#F2CCA4";
g.skycolours[1][3] = "#F5D4A9";
g.skycolours[1][4] = "#FEF1BC";

/* Red / green scheme */
g.skycolours[2][0] = "#E37E7E";
g.skycolours[2][1] = "#E88D89";
g.skycolours[2][2] = "#EB9891";
g.skycolours[2][3] = "#EEA299";
g.skycolours[2][4] = "#FCCCB7";

/* Alien scheme */
g.skycolours[3][0] = "#A88090";
g.skycolours[3][1] = "#B69690";
g.skycolours[3][2] = "#C4AC8F";
g.skycolours[3][3] = "#D3C28E";
g.skycolours[3][4] = "#ECE98E";

g.floorcolours = [];
g.floorcolours[0] = ["#223546", "#2D3C57"];
g.floorcolours[1] = ["#AB3431", "#9D302D"];
g.floorcolours[2] = ["#3A4929", "#495B38"];
g.floorcolours[3] = ["#645324", "#6F5E31"];

g.energybarcolours = [];
g.energybarcolours[0] = "#61BB78";
g.energybarcolours[1] = "#63A073";
g.energybarcolours[2] = "#61BB78";
g.energybarcolours[3] = "#63A073";
g.energybarcolours[4] = "#61BB78";
g.energybarcolours[5] = "#63A073";
g.energybarcolours[6] = "#61BB78";
g.energybarcolours[7] = "#63A073";
g.energybarcolours[8] = "#61BB78";
g.energybarcolours[9] = "#63A073";

g.explosionColours = [];
g.explosionColours[0] = "#148484";
g.explosionColours[1] = "#148484";
g.explosionColours[2] = "#47D500";
g.explosionColours[3] = "#47D500";
g.explosionColours[4] = "#CF6503";
g.explosionColours[5] = "#CF162C";

g.UIColours = [];
g.UIColours[0] = "#E5F6FA";
g.UIColours[1] = "#BBE2F3";
g.UIColours[2] = "#9DD2F0";
g.UIColours[3] = "#71C2F1";
g.UIColours[4] = "#50AEE4";
g.UIColours[5] = "#2694D3";

g.starcolours = [ "#335077", "#445C9D", "#627CC1", "#AAD2EB", "#B4EDFA" ];


/*
	The 'm' namespace is used to pool sprite objects.
*/

var m = { 
	spritesheets : [],
	player : {},
	playershadow : null,
	explosion : [],
	lasers : [],
	aliens : [],
	alienbomb : [],
	textsprites : [],
	//shadows : [],
	obstacles : [],
	clouds : [],
	powerups : [],
	saucers : [],
	probes : [],
	awards : null,
	sparks : [],
	coins : [],
	motherships : [],
	fighters : []
};

var floors = [];
var gameaudio = []; 

/*
	NUM is shorthand for use in iterative loops.
*/

var NUM = {};
NUM.alienbombs = 16;
NUM.aliens = 20;
NUM.explosions = 20;
NUM.lasers = 48;
NUM.textsprites = 40;
NUM.obstacles = 20;
NUM.clouds = 2;
NUM.powerups = 8;
NUM.saucers = 4;
NUM.probes = 1;
NUM.sparks = 8;
NUM.stars = 100;
NUM.dots = 64;
NUM.coins = 20;
NUM.motherships = 4;
NUM.fighters = 3;

var stars = [];

var planetdata = [
	{
		"name" : "TRANQUIS",
		"rate" : 0.1
	},
	{
		"name" : "FALSTAR",
		"rate" : 0.09
	},
	{
		"name" : "ZORBAN",
		"rate" : 0.085
	},
	{
		"name" : "CARUSAN",
		"rate" : 0.08
	}
];