

function importData()
{
	try
	{
		if (typeof localStorage.key === "function")
		{
			if (localStorage.getItem(GAMETITLE + "-hiscore") != null)
			{
				m.player.hiscore = localStorage.getItem(GAMETITLE + "-hiscore");
			} else {
				m.player.hiscore = 0;
			}

			/* STAGES */
			if (localStorage.getItem(GAMETITLE + "-stages") != null)
			{
				var a = localStorage.getItem(GAMETITLE + "-stages");
				var b = [];
				b = a.split('/');
				for (var c = 0;c < b.length;c++)
				{
					var d = [];
					d = b[c].split('|');
					for (var e=0;e < d.length;e++)
					{
						m.player.stages[c][e] = d[e];
					}
				}
			}

			/* STAGE TIMES */
			if (localStorage.getItem(GAMETITLE + "-stagetimes") != null)
			{
				var a = localStorage.getItem(GAMETITLE + "-stagetimes");
				var b = [];
				b = a.split('/');
				for (var c = 0;c < b.length;c++)
				{
					var d = [];
					d = b[c].split('|');
					for (var e=0;e < d.length;e++)
					{
						m.player.stagetimes[c][e] = d[e];
					}
				}
			}

			/* STAGE AWARDS */
			if (localStorage.getItem(GAMETITLE + "-stageawards") != null)
			{
				var a = localStorage.getItem(GAMETITLE + "-stageawards");
				var b = [];
				b = a.split('*');
				for (var c = 0;c < b.length;c++)
				{
					var d = [];
					d = b[c].split('/');
					for (var e=0;e < d.length;e++)
					{
						var f = [];
						f = d[e].split('|');
						for (var g=0;g < f.length;g++)
						{
							m.player.stageawards[c][e][g] = f[g];
						}
					}
				}
			}

			/* PLANETS */
			if (localStorage.getItem(GAMETITLE + "-planets") != null)
			{
				var p = localStorage.getItem(GAMETITLE + "-planets");
				m.player.planets = p.split('|');
			}

			/* CREDITS */
			if (localStorage.getItem(GAMETITLE + "-credits") != null)
			{
				m.player.credits = Math.floor(localStorage.getItem(GAMETITLE + "-credits"));
			} else {
				m.player.credits = 0;
			}
			m.player.targetcredits = m.player.credits;

			/* ENERGY */
			if (localStorage.getItem(GAMETITLE + "-energy") != null)
			{
				m.player.energymax = Math.floor(localStorage.getItem(GAMETITLE + "-energy"));
			} else {
				m.player.energymax = 5;
			}

			/* LASERS */
			if (localStorage.getItem(GAMETITLE + "-lasers") != null)
			{
				m.player.maxlasers = Math.floor(localStorage.getItem(GAMETITLE + "-lasers"));
			} else {
				m.player.maxlasers = 0;
			}

			/* SPEED */
			if (localStorage.getItem(GAMETITLE + "-speed") != null)
			{
				m.player.maxspeed = Math.floor(localStorage.getItem(GAMETITLE + "-speed"));
			} else {
				m.player.maxspeed = 4;
			}

		}	

	}
	catch (e)
	{
		write("importData: " + e.message);
	}
};

function exportData()
{
	try
	{
		// Write out player data and achievements
		if (m.player.score > m.player.hiscore) 
		{
			m.player.hiscore = Math.round(m.player.score);
			localStorage.setItem(GAMETITLE + "-hiscore", m.player.hiscore);
		}

		// Update the local storage with new player data - do not overwrite a 1 with a 0.
		var text = "";

		/* STAGE AWARDS */
		for (var a=0;a < 4;a++)
		{
			if (a === g.planetstage)
			{
				for (var b=0;b < 10;b++)
				{
					if (b === g.level)
					{
						text += 
						m.player.tempawards[0] + "|" + 
						m.player.tempawards[1] + "|" + 
						m.player.tempawards[2] + "/"; 
					} else {
						text += 
						m.player.stageawards[a][b][0] + "|" + 
						m.player.stageawards[a][b][1] + "|" + 
						m.player.stageawards[a][b][2] + "/"; 
					}
				}
			} else {
				for (var b=0;b < 10;b++)
				{
					text += 
					m.player.stageawards[a][b][0] + "|" + 
					m.player.stageawards[a][b][1] + "|" + 
					m.player.stageawards[a][b][2] + "/"; 
				}
			}
			text = text.substr(0,text.length-1);
			text += "*";
		}
		text = text.substr(0,text.length-1);
		localStorage.setItem(GAMETITLE + "-stageawards", text); 
		//write(text);

		/* STAGES */
		text = "";
		for (var a=0;a < 4;a++)
		{
			text += 
			m.player.stages[a][0] + "|" + 
			m.player.stages[a][1] + "|" + 
			m.player.stages[a][2] + "|" + 
			m.player.stages[a][3] + "|" + 
			m.player.stages[a][4] + "|" + 
			m.player.stages[a][5] + "|" + 
			m.player.stages[a][6] + "|" + 
			m.player.stages[a][7] + "|" + 
			m.player.stages[a][8] + "|" + 
			m.player.stages[a][9] + "/";
		}
		text = text.substr(0,text.length-1);
		localStorage.setItem(GAMETITLE + "-stages", text); 

		/* STAGE TIMES */
		text = "";
		for (var a=0;a < 4;a++)
		{
			text += 
			m.player.stagetimes[a][0] + "|" + 
			m.player.stagetimes[a][1] + "|" + 
			m.player.stagetimes[a][2] + "|" + 
			m.player.stagetimes[a][3] + "|" + 
			m.player.stagetimes[a][4] + "|" + 
			m.player.stagetimes[a][5] + "|" + 
			m.player.stagetimes[a][6] + "|" + 
			m.player.stagetimes[a][7] + "|" + 
			m.player.stagetimes[a][8] + "|" + 
			m.player.stagetimes[a][9] + "/";
		}
		text = text.substr(0,text.length-1);
		localStorage.setItem(GAMETITLE + "-stagetimes", text); 

		/* PLANETS */
		if (g.level >= 9)
		{
			var p = g.planetstage + 1;
			if (p == 4)
			{
				m.player.gamecomplete = true;
				g.destroymothership = g.planetstage;
			} else {
				if (p < 4 && m.player.planets[p] != 1)
				{
					m.player.planets[p] = 1;
					g.destroymothership = g.planetstage;
					m.player.showplanet = true;
					m.player.credits += Math.round(p * 1000);
					m.player.targetcredits = m.player.credits;
				}
				m.player.gamecomplete = false;
			}
		}

		text = 
			m.player.planets[0] + "|" +
			m.player.planets[1] + "|" +
			m.player.planets[2] + "|" +
			m.player.planets[3];
		localStorage.setItem(GAMETITLE + "-planets", text); 	
		
		exportQuickData(m.player.credits,m.player.energymax,m.player.maxlasers,m.player.maxspeed);

		/* All done now display the end of level sequence */
		g.mode = "levelup";
		g.resetting = 200;
		g.towerfalling = false;
		m.player.speed = 16;

	}
	catch (e)
	{
		write("exportData: " + e.message);
	}
};

function exportQuickData(credits,energy,lasers,speed)
{
	try
	{
		localStorage.setItem(GAMETITLE + "-credits", credits); 	
		localStorage.setItem(GAMETITLE + "-energy", energy); 	
		localStorage.setItem(GAMETITLE + "-lasers", lasers); 	
		localStorage.setItem(GAMETITLE + "-speed", speed); 	
	}
	catch (e)
	{
		write("Export quick data: " + e.message);
	}
};
