function scale()
{
	sizeHandler();
};

function sizeHandler () {

	if (!document.getElementById('game'))
	{
		return;
	}

	g.gamecanvas = document.getElementById('game');

	window.setTimeout(function() {
		window.scrollTo(0, 1);

		var rw = GAMEWIDTH;
		var rh = GAMEHEIGHT;
		var w = window.innerWidth;
		var h = window.innerHeight;

		g.factorx = w / rw;
		g.factory = h / rh;

		var multiplier = Math.min((h / rh), (w / rw));
		var actualCanvasWidth = rw * multiplier;
		var actualCanvasHeight = rh * multiplier;

		g.canvaswidth = rw;
		g.canvasheight = rh;
		g.canvas.width = g.canvaswidth;
		g.canvas.height = g.canvasheight;

		g.canvaspadding = 32;
		g.displaypadding = 0;

		g.textcentre = g.canvaswidth / 2;
		g.canvascentre = g.canvasheight / 2;
		g.horizon = g.canvasheight / 2;

		g.widthratio = w / g.canvaswidth;
		g.heightratio = h / g.canvasheight;

		if (w > h)
		{
			document.getElementById('orientate').style.display = "none";
			g.gamecanvas.style.display = "block";
			g.gamecanvas.style.width = actualCanvasWidth + "px";
			g.gamecanvas.style.height = actualCanvasHeight + "px";
			g.gamecanvas.style.position = "relative";
			g.gamecanvas.style.margin = "0px auto 0px auto";
		}
		else
		{
			if (w == 320)
			{
				multiplier = 1;
				document.getElementById('orientate').style.display = "none";
				g.gamecanvas.style.display = "block";
				g.gamecanvas.style.width = "320px";
				g.gamecanvas.style.height = "480px";
				g.gamecanvas.style.position = "absolute";
				g.gamecanvas.style.left = "0px";
				g.gamecanvas.style.top = "0px";
			}
			else if (w > 320)
			{
				document.getElementById('orientate').style.display = "none";
				g.gamecanvas.style.display = "block";
				g.gamecanvas.style.width = actualCanvasWidth + "px";
				g.gamecanvas.style.height = actualCanvasHeight + "px";
				g.gamecanvas.style.position = "relative";
				g.gamecanvas.style.margin = "0px auto 0px auto";
			}
		}
		createFloor();
	}, 1000);
};

window.addEventListener('resize', function(evt) { sizeHandler(); }, false);
window.addEventListener('orientationchange', function(evt) { sizeHandler(); }, false);