function createstars()
{
	try
	{
		for (var a=0;a<NUM.stars;a++) 
		{ 
			var starindex = rnd(g.starcolours.length)-1;
			stars[a] = new star("star"+a, rnd(g.canvaswidth), rnd(g.canvasheight), 2, 1, 4, g.starcolours[starindex], starindex); 
		}
	}
	catch (e)
	{
		write("createstars: " + e.message);
	}
};

function spawnTextSprite(o,t)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<m.textsprites.length;a++)
	{
		if (!m.textsprites[a].visible)
		{
			var e = m.textsprites[a];
			e.visible = true;
			e.ticks = 100;
			e.x = o.x;
			e.y = o.y;
			e.text = t;
			e.speed = 1;
			e.colour = "#F8E070";
			break;
		}
	}
};

function spawnTextSpriteXY(x,y,t)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<m.textsprites.length;a++)
	{
		if (!m.textsprites[a].visible)
		{
			var e = m.textsprites[a];
			e.visible = true;
			e.ticks = 100;
			e.x = x;
			e.y = y;
			e.text = t;
			e.speed = 1;
			e.colour = "#F8E070";
			break;
		}
	}
};

function spawnExplosion(o,d,sp)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<NUM.explosions;a++)
	{
		if (!m.explosion[a].visible)
		{
			var e = m.explosion[a];
			e.visible = true;
			e.direction = d;
			e.x = o.x;
			e.y = o.y;
			e.w = e.spritesheet.framewidth;
			e.h = e.spritesheet.frameheight;
			e.speed = 0.1;
			e.frame = 0;
			e.explosiontype = "";
			break;
		}
	}
};

function spawnBlastExplosion(o)
{
	try
	{
		if (g.pausemode > 0) { return; }
		for (var a=0;a<NUM.explosions;a++)
		{
			if (!m.explosion[a].visible)
			{
				var e = m.explosion[a];
				e.visible = true;
				e.direction = 0;
				e.x = o.x;
				e.y = o.y;
				e.w = o.w;
				e.h = o.h;
				e.speed = 0.1;
				e.frame = 0;
				e.explosiontype = "";
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn blast explosion: " + e.message);
	}
};

function spawnBombExplosion(o,d,sp,bomb)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<NUM.explosions;a++)
	{
		if (!m.explosion[a].visible)
		{
			var e = m.explosion[a];
			e.visible = true;
			e.direction = d;
			e.x = o.x;
			e.y = o.y;
			e.w = e.spritesheet.framewidth;
			e.h = e.spritesheet.frameheight;
			e.speed = 0.1;
			e.frame = 0;
			e.explosiontype = "";
			e.xmod = bomb.xmod;
			break;
		}
	}
};

function spawnExplosionXY(x,y,d,sp,o)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<NUM.explosions;a++)
	{
		if (!m.explosion[a].visible)
		{
			var e = m.explosion[a];
			e.visible = true;
			e.direction = d;
			e.x = x - 8;
			e.y = y - 8;
			e.speed = sp;
			e.frame = 0;
			//write(e.w + ", " + e.h + ", o = " + o.w + ", " + o.h);
			e.w = o.w * 1.5; //e.spritesheet.framewidth;
			e.h = o.h * 1.5; //e.spritesheet.frameheight;
			e.xmod = 0;
			e.explosiontype = "";
			break;
		}
	}
};

function spawnObstacleExplosionXY(x,y,d,sp,o)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<NUM.explosions;a++)
	{
		if (!m.explosion[a].visible)
		{
			var e = m.explosion[a];
			e.visible = true;
			e.direction = d;
			e.x = x - 8;
			e.y = y - 8;
			e.speed = sp;
			e.frame = 0;
			e.w = o.w;
			e.h = o.w; /* NOT height! */
			e.xmod = o.xmod;
			e.explosiontype = "";
			break;
		}
	}
};

function spawnTowerExplosion(x,y)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<NUM.explosions;a++)
	{
		if (!m.explosion[a].visible)
		{
			var e = m.explosion[a];
			e.visible = true;
			e.direction = 0;
			e.x = x - 8;
			e.y = y - 8;
			e.speed = 1;
			e.frame = 0;
			e.w = 16;
			e.h = 16;
			e.explosiontype = "TOWER";
			break;
		}
	}
};

function spawnIntroExplosion()
{
	try
	{
		var x = 68 + rnd(128);
		var y = 100 + rnd(128);
		for (var a=0;a<NUM.explosions;a++)
		{
			if (!m.explosion[a].visible)
			{
				var e = m.explosion[a];
				e.visible = true;
				e.direction = 0;
				e.x = x;
				e.y = y;
				e.speed = 1;
				e.frame = 0;
				e.w = e.spritesheet.framewidth;
				e.h = e.spritesheet.frameheight;
				e.explosiontype = "INTRO";
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn intro explosion: " + e.message);
	}
};

function spawnMothershipExplosion(o)
{
	try
	{
		var x = (o.targetx - 32) + rnd(122);
		var y = (o.targety - 32) + rnd(28);
		for (var a=0;a<NUM.explosions;a++)
		{
			if (!m.explosion[a].visible)
			{
				var e = m.explosion[a];
				e.visible = true;
				e.direction = 0;
				e.x = x;
				e.y = y;
				e.speed = 1;
				e.frame = 0;
				e.w = e.spritesheet.framewidth;
				e.h = e.spritesheet.frameheight;
				e.explosiontype = "MOTHERSHIP";
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn mothership explosion: " + e.message);
	}
};

function spawnCloud(x,y,s)
{
	try
	{
		for (var a=0;a < NUM.clouds;a++)
		{
			var o = m.clouds[a];
			if (!o.visible)
			{
				o.visible = true;
				o.x = x;
				o.y = y;
				o.speed = s;
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn cloud: " + e.message);
	}
};

function spawnObstacleChance()
{
	if (g.pausemode > 0 || g.towerfalling) return;
	try
	{
		if (g.energytowers > 0 && rnd(100) < 80)
		{
			spawnObstacle(128 + rnd(80),g.horizon - 16,true);
		} else {
			spawnObstacle(128 + rnd(80),g.horizon - 16,false);
		}
	}
	catch (e)
	{
		write("Spawn obstacle chance: " + e.message);
	}
};

function spawnObstacle(x,y,energytower,xmod)
{
	if (g.pausemode > 0) return;
	try
	{
		var mid = g.canvaswidth / 2;
		for (var a=0;a<NUM.obstacles;a++)
		{
			if (!m.obstacles[a].visible)
			{
				var e = m.obstacles[a];
				e.visible = true;
				e.type = energytower ? "ENERGY" : "OBSTACLE";
				e.hp = energytower ? 2 : 100;
				e.maxw = e.spritesheet.framewidth;
				e.maxh = e.spritesheet.frameheight;
				e.w = e.maxw / 8;
				e.h = e.maxh / 8;
				e.x = x;
				e.y = y+4;
				e.speed = 0;
				e.basespeed = e.speed;
				e.frame = 0;
				e.row = energytower ? 1 : 0;
				e.nextthink = 16;
				e.decay = 0;
				e.basenextthink = e.nextthink;
				e.startframe = 0;
				e.inpain = 0;
				e.ymod = 0;
				e.distance = 0;
				e.xmod = xmod;
				//calculateModsAlien(e);
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn obstacle: " + e.message);
	}
};

function spawnPowerupChance()
{
	if (g.pausemode > 0 || g.towerfalling) return;
	try
	{
		spawnPowerup(128 + rnd(80),g.horizon);
	}
	catch (e)
	{
		write("Spawn obstacle chance: " + e.message);
	}
};

function spawnPowerup(x,y,row,xmod)
{
	if (g.pausemode > 0) return;
	try
	{
		var mid = g.canvaswidth / 2;
		for (var a=0;a<NUM.powerups;a++)
		{
			if (!m.powerups[a].visible)
			{
				var e = m.powerups[a];
				e.visible = true;
				e.maxw = e.spritesheet.framewidth;
				e.maxh = e.spritesheet.frameheight;
				e.w = e.maxw / 4;
				e.h = 1;//e.maxh / 4;
				e.x = x;
				e.y = y;
				e.speed = 0;
				e.basespeed = e.speed;
				e.frame = 0;
				e.row = row;
				e.nextthink = 16;
				e.decay = 0;
				e.basenextthink = e.nextthink;
				e.startframe = 0;
				e.inpain = 0;
				e.targetx = rnd(g.canvaswidth);
				e.targety = g.canvasheight + 16;
				e.ymod = 0;
				e.distance = 0;
				e.xmod = xmod;
				//calculateModsAlien(e);
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn alien: " + e.message);
	}
};

function spawnAlienChance()
{
	if (g.pausemode > 0 || g.towerfalling) return;
	try
	{
		spawnAlien(128 + rnd(80),g.horizon - 8);
	}
	catch (e)
	{
		write("Spawn alien chance: " + e.message);
	}
};

function spawnAlien(x,y,xmod,row)
{
	if (g.pausemode > 0 || g.towerfalling) return;
	try
	{
		/*
		var xmod = 0;
		if (x < g.textcentre) xmod = -1.5;
		if (x <= g.textcentre - 32) xmod = -2.5;
		if (x > g.textcentre) xmod = 1.5;
		if (x >= g.textcentre + 32) xmod = 2.5;
		*/
		var hp = 1;
		var mid = g.canvaswidth / 2;
		for (var a=0;a<NUM.aliens;a++)
		{
			if (!m.aliens[a].visible)
			{
				var e = m.aliens[a];
				e.visible = true;
				//spawnShadow(e);
				e.maxw = e.spritesheet.framewidth;
				e.maxh = e.spritesheet.frameheight;
				e.w = e.maxw / 8;
				e.h = e.maxh / 8;
				e.shadoww = e.w;
				e.shadowh = 2;
				e.x = x;
				e.y = y;
				//e.shadow.x = x;
				//e.shadow.y = y + e.h;
				e.hp = hp;
				e.speed = 0;
				e.basespeed = e.speed;
				e.frame = 0;
				e.row = row;
				e.nextthink = 16 - (g.planetstage * 3); 
				if (e.row > 3) { e.nextthink -= 6; }
				e.basenextthink = e.nextthink;
				e.decay = 0;
				e.startframe = 0;
				e.inpain = 0;
				e.targetx = rnd(g.canvaswidth);
				e.targety = g.canvasheight + 16;
				e.ymod = 0;
				e.distance = 0;
				e.xmod = xmod;//calculateModsAlien(e);
				e.direction = rnd(10) < 5 ? 2 : 6;
				e.angle = 0;
				e.diving = false;
				e.divedir = 0;
				e.hold = 0;
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn alien: " + e.message);
	}
};

function spawnShadow(e)
{
	if (g.pausemode > 0) return;
	try
	{
		for (var a=0;a<NUM.shadows;a++)
		{
			var s = m.shadows[a];
			if (!s.visible)
			{
				s.visible = true;
				e.shadow = s;
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn shadow: " + e.message);
	}
};

function spawnSaucer(x,y,row)
{
	if (g.pausemode > 0 || g.towerfalling) return;
	try
	{
		var t = 0;
		var hp = t === 0 ? (row === 0 ? 10 : 20) : 30;
		var mid = (g.canvaswidth / 2) - 16;
		for (var a=0;a<NUM.saucers;a++)
		{
			if (!m.saucers[a].visible)
			{
				var e = m.saucers[a];
				e.visible = true;
				e.type = t; // 0 = lander, 1 = float
				e.maxw = e.spritesheet.framewidth;
				e.maxh = e.spritesheet.frameheight;
				e.w = t === 0 ? e.spritesheet.framewidth : e.spritesheet.framewidth; // * 2;
				e.h = t === 0 ? e.spritesheet.frameheight : e.spritesheet.frameheight; // * 2;
				e.x = x;
				e.y = y;
				e.direction = t === 0 ? (rnd(10) < 5 ? 2 : 6) : (x < 0 ? 2 : 6);
				e.hp = hp;
				e.speed = 8;
				e.basespeed = e.speed;
				e.frame = 0;
				e.row = row;
				e.nextthink = 16;
				e.basenextthink = e.nextthink;
				e.startframe = 0;
				e.inpain = false;
				e.targetx = row == 0 ? mid : x;
				e.targety = g.horizon - 16;
				e.xposition = false;
				e.yposition = false;
				e.direction = rnd(10) < 5 ? 2 : 6;
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn saucer: " + e.message);
	}
};

function spawnProbe()
{
	if (g.pausemode > 0 || g.towerfalling) return;
	try
	{
		var t = 1;
		var hp = 4;
		var mid = (g.canvaswidth / 2) - 16;
		var x = rnd(10) < 5 ? -32 : g.canvaswidth;
		var y = g.horizon + 12;
		var row = g.planetstage;//g.towerinrange ? rnd(4) - 1 : rnd(2) - 1;;

		for (var a=0;a<NUM.probes;a++)
		{
			if (!m.probes[a].visible)
			{
				var e = m.probes[a];
				e.visible = true;
				e.type = t; // 0 = lander, 1 = float
				e.maxw = e.spritesheet.framewidth;
				e.maxh = e.spritesheet.frameheight;
				e.w = t === 0 ? e.spritesheet.framewidth : e.spritesheet.framewidth; // * 2;
				e.h = t === 0 ? e.spritesheet.frameheight : e.spritesheet.frameheight; // * 2;
				e.x = x;
				e.y = y;
				e.direction = t === 0 ? (rnd(10) < 5 ? 2 : 6) : (x < 0 ? 2 : 6);
				e.hp = hp;
				e.speed = 6 + row;
				e.basespeed = e.speed;
				e.frame = 0;
				e.row = row;
				e.nextthink = 16;
				e.basenextthink = e.nextthink;
				e.startframe = 0;
				e.inpain = false;
				e.targetx = row == 0 ? mid : x;
				e.targety = g.horizon - 16;
				e.xposition = false;
				e.yposition = false;
				e.direction = rnd(10) < 5 ? 2 : 6;
				break;
			}
		}
	}
	catch (e)
	{
		write("Spawn probe: " + e.message);
	}
};

function spawnEntityChance(o)
{
	if (g.pausemode > 0) return;
	var x = 0; var y = 0;
	if ((rnd(100) < 10) && g.pausemode < 1) 
	{
		x = o.x + 32 + (rnd(g.roadwidth - 64));
		y = 0;
		var row = parseInt(m.spritesheets["entitysheet"].height) / parseInt(m.spritesheets["entitysheet"].frameheight);
		var r = rnd(100)<(g.level)?rnd(3)-1:2+rnd(row-3);
		if (g.level < 5 && r === 5)
		{
			if (rnd(100)>5) r = 4; // frig to prevent too much missile exposure on early levels
		}
		spawnEntity(x, y, r);
	}
};

function spawnEntity(x,y,row)
{
	if (g.pausemode > 0) return;
	for (var a=0;a<m.entity.length;a++)
	{
		if (!m.entity[a].visible)
		{
			var s = m.entity[a];
			s.visible = true;
			s.x = x;
			s.y = y;
			s.direction = 4;
			s.speed = g.roadspeed;
			s.dying = 0;
			s.row = row;
			break;
		}
	}
};

function spawnAlienBomb(o)
{
	if (!o.visible) { return; }
	if (g.towerfalling) { return; }
	if (g.pausemode > 0) { return; }
	if (g.mode != "game") { return; }
	if (m.player.dying) { return; }
	if (o.distance > 22) { return; }
	if (rnd(100) < 80 || o.row == 0)
	{
		for (var a=0;a<m.alienbomb.length;a++)
		{
			if (!m.alienbomb[a].visible)
			{
				var s = m.alienbomb[a];
				s.visible = true;
				s.x = o.x + (o.w/2);
				s.y = o.y + (o.h/2);
				s.w = 8;
				s.h = 8;
				s.row = 0;
				s.frame = 0;
				s.xmod = 0;
				s.speed = o.spritesheet.type == "saucer" ? 0.001 : 0.01;
				s.hp = 2;
				if (o.row < 2) { calculateMods(o,m.player,s); }
				s.distance = o.distance;
				break;
			}
		}
	}
};

function spawnCoin(o,xmod)
{
	if (g.towerfalling) { return; }
	if (g.pausemode > 0) { return; }
	if (g.mode != "game") { return; }
	if (m.player.dying) { return; }
	//if (o.distance > 22) { return; }
	for (var a=0;a<m.coins.length;a++)
	{
		if (!m.coins[a].visible)
		{
			var s = m.coins[a];
			s.visible = true;
			s.x = o.x + (o.w/2);
			s.y = o.y + (o.h/2);
			s.w = 16;
			s.h = 16;
			s.row = rnd(3)-1;
			s.frame = 0;
			s.xmod = xmod;
			s.ymod = 8;
			s.speed = 1;
			s.hp = 2;
			s.distance = o.distance;
			break;
		}
	}
};

function spawnBombBlast(o,xmod,row)
{
	if (g.towerfalling) { return; }
	if (g.pausemode > 0) { return; }
	if (g.mode != "game") { return; }
	if (m.player.dying) { return; }
	//if (rnd(100) > 10) { return; }
	for (var a=0;a<m.coins.length;a++)
	{
		if (!m.coins[a].visible)
		{
			var s = m.coins[a];
			s.visible = true;
			s.x = o.x + (o.w/2);
			s.y = o.y + (o.h/2);
			s.w = 16;
			s.h = 16;
			s.row = row;
			s.frame = 0;
			s.xmod = xmod;
			s.ymod = 8;
			s.speed = 1;
			s.hp = 2;
			s.distance = o.distance;
			break;
		}
	}
};

function spawnSaucerBomb(o,xmod)
{
	if (!o.visible) { return; }
	if (g.towerfalling) { return; }
	if (g.pausemode > 0) { return; }
	if (g.mode != "game") { return; }
	if (m.player.dying) { return; }
	if (rnd(40) < ((g.planetstage + 1) * 10) || o.row == 0)
	{
		for (var a=0;a<m.alienbomb.length;a++)
		{
			if (!m.alienbomb[a].visible)
			{
				var s = m.alienbomb[a];
				s.visible = true;
				s.x = o.x + (o.w/2) - 8;
				s.y = o.y + (o.h/2) - 8;
				s.w = 6;
				s.h = 6;
				s.row = 0;
				s.frame = 0;
				s.speed = 0.001;
				s.xmod = xmod;
				break;
			}
		}
	}
};

function spawnTowerBomb()
{
	if (g.towerfalling) { return; }
	if (g.pausemode > 0) { return; }
	if (g.mode != "game") { return; }
	if (m.player.dying) { return; }
	for (var a=0;a<m.alienbomb.length;a++)
	{
		if (!m.alienbomb[a].visible)
		{
			var s = m.alienbomb[a];
			s.visible = true;
			s.x = g.textcentre - 8;
			s.y = g.horizon - 8;
			s.w = 4;
			s.h = 4;
			s.row = 1;
			s.frame = 0;
			s.speed = 1;
			calculateModsXY1XY2(g.textcentre-8,g.horizon-8,m.player.x+24,m.player.y,s);
			s.ymod = -10;
			s.shadoww = 0;
			s.shadowh = 0;
			break;
		}
	}
};

function spawnLaser(x,y,type)
{
	if (g.pausemode > 0 || g.towerfalling) return;
	/* type = left or right (0,1) */
	try
	{
		if (m.player.dying) return;
		for (var a=0;a<m.lasers.length;a++)
		{
			if (!m.lasers[a].visible)
			{
				var s = m.lasers[a];
				s.visible = true;
				s.x = x;
				s.y = y;
				s.w = 16;
				s.h = 16;
				s.speed = 12;
				s.dead = false;
				s.damage = 2;
				s.type = type;

				s.row = m.player.lasers;
				
				/*
				var c1 = 100 + rnd(155);
				var c2 = 100 + rnd(155);
				var c3 = 100 + rnd(155);
				s.colourstep = 0;
				*/

				g.shotsfired ++;

				var mid = (g.canvaswidth / 2) - 32;
				var tx = mid;
				if (m.player.x <= mid)
				{
					tx = (mid / 2) - (m.player.x * -0.5);
				} else { 
					tx = (mid / 2) + (m.player.x * 0.5);
				}

				s.distance = 0;
				calculateModsXY(m.player,tx,g.horizon,s);
				break;
			}
		}
	}
	catch (e)
	{
		write("SpawnLaser: " + e.message);
	}
};

function dotExplosion(o)
{
	for (var a=0;a < 16;a ++)
	{
		spawnDot(o,o.x,o.y);
	}
};

function UIDotExplosionXY(x,y)
{
	for (var a=0;a < 32;a ++)
	{
		spawnUIDot(x,y);
	}
};

function dotBombExplosion(o)
{
	for (var a=0;a < 4;a ++)
	{
		spawnDot(o,o.x,o.y,o.row == 0 ? "#bf0000" : "#bf0000");
	}
};

function dotBlobExplosion(o)
{
	for (var a=0;a < 32;a ++)
	{
		spawnDot(o,o.x + (o.w / 2),o.y,"#bf0000");
	}
};

function spawnDot(o,x,y,c)
{
	try
	{
		if (m.player.dying) return;
		for (var a=0;a<NUM.dots;a++)
		{
			if (!dots[a].visible)
			{
				var s = dots[a];
				s.visible = true;
				s.x = x;
				s.y = y;
				s.speed = (2 + rnd(6)) * -1;
				s.dir = 4;
				s.alpha = -1;
				s.xmod = rnd(10) < 5 ? rnd(4) : rnd(4) * -1;
				if (c) 
				{	s.colour = c; 
					s.colourindex = -1; 
				} else { 
					//s.colour = g.explosionColours[o.row]; 
					s.colourindex = o.row; 
					s.nextthink = 10;
				}
				s.w = o.spritesheet.type == "saucer" ? 0.1 : 1 + rnd(3);
				s.spritetype = o.spritesheet.type;
				s.h = s.w;
				break;
			}
		}
	}
	catch (e)
	{
		write("SpawnDot: " + e.message);
	}
};

function spawnUIDot(x,y)
{
	try
	{
		for (var a=0;a<NUM.dots;a++)
		{
			if (!dots[a].visible)
			{
				var s = dots[a];
				s.visible = true;
				s.x = x;
				s.y = y;
				s.speed = (2 + rnd(10)) * -1;
				s.dir = 4;
				s.xmod = rnd(10) < 5 ? (rnd(20) * 0.1) : (rnd(20) * 0.1) * -1;
				s.alpha = 100;

				//s.colour = g.explosionColours[rnd(g.explosionColours.length)-1]; 
				//s.colourindex = 0; 
				s.nextthink = 10;

				s.w = 1 + rnd(3);
				s.spritetype = "UI";
				s.h = s.w;
				break;
			}
		}
	}
	catch (e)
	{
		write("SpawnDot: " + e.message);
	}
};