function checkForTouch() {	
	try
	{
		var d = document.createElement("div");
		d.setAttribute("ontouchmove", "return;");
		//return ('ontouchstart' in d);
		return typeof d.ontouchmove === "function" ? true : false;
	}
	catch (e)
	{
		write("Check for touch: " + e.message);
	}
};

function initTouch()
{
	try
	{
		if(checkForTouch()) {
			if (document.body.addEventListener)
			{
				document.body.addEventListener('touchmove', touchMove, false);
				document.body.addEventListener('touchstart', touchStart, false);
				document.body.addEventListener('touchend', touchEnd, false);
			} else {
				window.addEventListener('touchmove', touchMove, false);
				window.addEventListener('touchstart', touchStart, false);
				window.addEventListener('touchend', touchEnd, false);
			}
			write("Touch enabled device.");
		} else {
			window.addEventListener('mousemove', mouseMove, false);
			window.addEventListener('mousedown', mouseDown, false);
			write("No touch capability.");
		}
	}
	catch (e)
	{
		write("Init touch: " + e.message);
	}
};

function touch(event) {

	if (g.towerfalling || g.mode == "levelup" || m.player.retiring) return;
	
	var tx = Math.floor(event.pageX / g.widthratio); /* - g.canvas.offsetLeft; */
	var ty = Math.floor(event.pageY / g.heightratio); /* - g.canvas.offsetTop; */

	if (g.mode == "game" || g.mode == "pregame")
	{
		m.player.targetx = Math.round(tx - (m.player.w / 2));
		if (m.player.targetx + m.player.w > g.canvaswidth) { m.player.targetx = g.canvaswidth - m.player.w; }
		if (m.player.targetx < 0) { m.player.targetx = 0; }
	}

};

function touchStart(event) { // exclusively the pause function
	event.preventDefault();
	var tx = event.touches[0].pageX; /* (event.touches[0].pageX - g.canvas.offsetLeft); */
	var ty = event.touches[0].pageY; /* (event.touches[0].pageY - g.canvas.offsetTop); */
	backend(tx,ty);
};

function touchMove(event) {
	event.preventDefault();
	touch(event.touches[0]);
};

function touchEnd(event) {
	event.preventDefault();
};

function mouseMove(event) {
	touch(event);
};

function mouseDown(event) {
	event.preventDefault();
	var tx = event.pageX; /* (event.pageX - g.canvas.offsetLeft); */
	var ty = event.pageY; /* (event.pageY - g.canvas.offsetTop); */
	backend(tx,ty);
};

function backend(tx,ty)
{
	try
	{
		tx = tx / g.widthratio;
		ty = ty / g.heightratio;

		//write(tx + ", " + ty + ", wr=" + g.widthratio + ", hr=" + g.heightratio);

		if (g.mode == "title") { setGame(); }
		if (tx < g.textcentre && ty < 100 && g.mode == "game") 
		{ 
			g.pausemode ++; 
			if (g.pausemode > 1) 
			{ 
				g.pausemode = 0; 
			} 
		}
		if (g.mode == "intro" && g.sequence > 0) 
		{
			g.mode = "planetselect";
			g.resetting = 100;
			g.textblink = 0;
		}
		if (g.mode == "planetselect" && g.resetting < 95) 
		{
			if (tx < g.textcentre && ty < 60) { quitGame(4); }
			var y = [];
			y[0] = (50 + (0 * 80));
			y[1] = (50 + (1 * 80));
			y[2] = (50 + (2 * 80));
			y[3] = (50 + (3 * 80));

			if (ty > y[0] && ty < y[1] && m.player.planets[0] > 0)	{ g.planetstage = 0; g.textblink = 20; }//UIDotExplosionXY(g.textcentre,y[0]+16); }
			if (ty > y[1] && ty < y[2] && m.player.planets[1] > 0)	{ g.planetstage = 1; g.textblink = 20; }//UIDotExplosionXY(g.textcentre,y[1]+16); }
			if (ty > y[2] && ty < y[3] && m.player.planets[2] > 0)	{ g.planetstage = 2; g.textblink = 20; }//UIDotExplosionXY(g.textcentre,y[2]+16); }
			if (ty > y[3] && m.player.planets[3] > 0)				{ g.planetstage = 3; g.textblink = 20; }//UIDotExplosionXY(g.textcentre,y[3]+16); }
		}
		if (g.mode == "stageselect" && g.resetting < 95 && g.textblink < 1)
		{
			if (tx < g.textcentre && ty < 60) { quitGame(0); }
			if (tx > g.textcentre && ty < 60) { quitGame(3); }
			var y = [];
			for (a=0;a<5;a++) { y[a] = 64 + (a * 64); }
			if (tx < g.textcentre)
			{
				if (ty > y[0] && ty < y[1] && m.player.stages[g.planetstage][0] > 0)	{ g.level = -1; g.textblink = 20; }//UIDotExplosionXY(g.textcentre / 2,y[0]+14); }
				if (ty > y[1] && ty < y[2] && m.player.stages[g.planetstage][2] > 0)	{ g.level = 1; g.textblink = 20; }//UIDotExplosionXY(g.textcentre / 2,y[1]+14); }
				if (ty > y[2] && ty < y[3] && m.player.stages[g.planetstage][4] > 0)	{ g.level = 3; g.textblink = 20; }//UIDotExplosionXY(g.textcentre / 2,y[2]+14); }
				if (ty > y[3] && ty < y[4] && m.player.stages[g.planetstage][6] > 0)	{ g.level = 5; g.textblink = 20; }//UIDotExplosionXY(g.textcentre / 2,y[3]+14); }
				if (ty > y[4] && m.player.stages[g.planetstage][8] > 0)					{ g.level = 7; g.textblink = 20; }//UIDotExplosionXY(g.textcentre / 2,y[4]+14); }
			} else {
				if (ty > y[0] && ty < y[1] && m.player.stages[g.planetstage][1] > 0)	{ g.level = 0; g.textblink = 20; }//UIDotExplosionXY(g.textcentre + (g.textcentre / 2),y[0]+14); }
				if (ty > y[1] && ty < y[2] && m.player.stages[g.planetstage][3] > 0)	{ g.level = 2; g.textblink = 20; }//UIDotExplosionXY(g.textcentre + (g.textcentre / 2),y[1]+14); }
				if (ty > y[2] && ty < y[3] && m.player.stages[g.planetstage][5] > 0)	{ g.level = 4; g.textblink = 20; }//UIDotExplosionXY(g.textcentre + (g.textcentre / 2),y[2]+14); }
				if (ty > y[3] && ty < y[4] && m.player.stages[g.planetstage][7] > 0)	{ g.level = 6; g.textblink = 20; }//UIDotExplosionXY(g.textcentre + (g.textcentre / 2),y[3]+14); }
				if (ty > y[4] && m.player.stages[g.planetstage][9] > 0)					{ g.level = 8; g.textblink = 20; }//UIDotExplosionXY(g.textcentre + (g.textcentre / 2),y[4]+14); }
			}
			/* g.level set to -1 of its intended value as it gets bumped in setLevel() */

		}
		if (g.mode == "shop" && g.resetting < 95)
		{
			if (tx < g.textcentre && ty < 40) { quitGame(1); }
			var y = [];
			y[0] = 128;
			y[1] = 200;
			y[2] = 272;
			y[3] = 314;
			//if (tx > g.textcentre - 64 && tx < g.textcentre + 64)
			{
				if (ty > y[0] && ty < y[1])
				{ // Lasers
					var cost = g.shop[0].cost[m.player.maxlasers];
					if (m.player.credits >= cost)
					{
						m.player.targetcredits -= cost;
						m.player.maxlasers ++;
						m.player.lasers ++;
						UIDotExplosionXY(g.textcentre,g.canvasheight-108);
						bounceFighter();
						exportQuickData(m.player.targetcredits,m.player.energymax,m.player.maxlasers,m.player.maxspeed);
						spawnTextSpriteXY(g.textcentre-64,y[0],g.shop[0].item + " " + textdata[19]);
					}
				}
				if (ty > y[1] && ty < y[2])
				{ // Energy
					var cost = g.shop[1].cost[m.player.energymax];
					if (m.player.credits >= cost)
					{
						m.player.targetcredits -= cost;
						m.player.energymax ++;
						UIDotExplosionXY(g.textcentre,g.canvasheight-108);
						bounceFighter();
						exportQuickData(m.player.targetcredits,m.player.energymax,m.player.maxlasers,m.player.maxspeed);
						spawnTextSpriteXY(g.textcentre-64,y[1],g.shop[1].item + " " + textdata[19]);
					}
				}
				if (ty > y[2] && ty < y[3])
				{ // Speed
					var cost = g.shop[2].cost[m.player.maxspeed];
					if (m.player.credits >= cost)
					{
						m.player.targetcredits -= cost;
						m.player.maxspeed ++;
						UIDotExplosionXY(g.textcentre,g.canvasheight-108);
						bounceFighter();
						exportQuickData(m.player.targetcredits,m.player.energymax,m.player.maxlasers,m.player.maxspeed);
						spawnTextSpriteXY(g.textcentre-64,y[2],g.shop[2].item + " " + textdata[19]);
					}
				}
			}
		}
		if (g.mode == "game" && g.pausemode > 0) 
		{
			var y = [];
			y[0] = (100);
			y[1] = (g.pausemenuorigin + 34);
			y[2] = (g.pausemenuorigin + (34 * 2));
			y[3] = (g.pausemenuorigin + (34 * 3));
			y[4] = (g.pausemenuorigin + (34 * 4));

			if (ty > y[0] && ty < y[1]) { g.pausemode = 0; }
			if (ty > y[1] && ty < y[2]) { quitGame(0); }
			if (ty > y[2] && ty < y[3]) { quitGame(1); }
			if (ty > y[3] && ty < y[4]) { quitGame(2); }
		}

	}
	catch (e)
	{
		write("Backend: " + e.message);
	}
};



